//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


// TrayDialog.cpp: implementation of the TrayDialog class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ETBuddies.h"
#include "TrayDialog.h"
#include "ETBuddiesDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

#define WM_TRAY_CALLBACK		(WM_USER + 0x500)

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

TrayDialog::TrayDialog(UINT nIDTemplate, CWnd* pParentWnd /*= NULL*/) : CDialog (nIDTemplate, pParentWnd) 
{
	TrayCreate() ;
}
TrayDialog::TrayDialog(LPCTSTR lpszTemplateName, CWnd* pParentWnd /*= NULL*/) : CDialog (lpszTemplateName, pParentWnd) 
{
	TrayCreate() ;
}	
TrayDialog::TrayDialog() {
	TrayCreate() ;
}

TrayDialog::~TrayDialog() 
{
}


void TrayDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TrayDialog)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TrayDialog, CDialog)
	//{{AFX_MSG_MAP(TrayDialog)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_TRAY_CALLBACK,OnTrayNotify)
END_MESSAGE_MAP()



void TrayDialog::TrayCreate ()
{
	memset (&this->m_hTrayIcon, 0, sizeof(NOTIFYICONDATA)) ;
	m_hTrayIcon.cbSize = sizeof(NOTIFYICONDATA) ;
	m_hTrayIcon.uCallbackMessage = WM_TRAY_CALLBACK ;
	m_hTrayIcon.uFlags = NIF_ICON | NIF_MESSAGE ;
	m_hTrayIcon.uID = 1 ;

	m_nDefaultPos = 0 ;
}


/* add this icon to systray */
void TrayDialog::TrayShow ()
{
	m_hTrayIcon.hWnd = m_hWnd ;
	Shell_NotifyIcon (NIM_ADD, &m_hTrayIcon) ;
}

/* remove this icon from systray */
void TrayDialog::TrayHide ()
{
	m_hTrayIcon.hWnd = m_hWnd ;
	Shell_NotifyIcon (NIM_DELETE, &m_hTrayIcon) ;
}

void TrayDialog::TraySetIcon (HICON hIcon) 
{
	this->m_hTrayIcon.hIcon = hIcon ;

}

LRESULT TrayDialog::OnTrayNotify(WPARAM wParam, LPARAM lParam)
{
	   UINT uID; 
    UINT uMsg; 
 
    uID = (UINT) wParam; 
    uMsg = (UINT) lParam; 
 
	if (uID != 1)
		return false;
	
	CPoint pt;	

    switch (uMsg)
	{ 
	/*	case WM_MOUSEMOVE:
			GetCursorPos(&pt);
			ClientToScreen(&pt);
			OnTrayMouseMove(pt);
			break;*/
	/*	case WM_LBUTTONDOWN:
			GetCursorPos(&pt);
			ClientToScreen(&pt);
			OnTrayLButtonDown(pt);
			break;*/
		case WM_LBUTTONDBLCLK:
		//	if (IsIconic()) {
			//	ShowWindow(SW_RESTORE) ;
				MAIN_DLG->OnRestore();
		//	}
			break;
		case WM_RBUTTONUP:
		case WM_CONTEXTMENU:
			GetCursorPos(&pt);
			OnTrayRButtonUp(pt);
			break;
	/*	case WM_RBUTTONDBLCLK:
			GetCursorPos(&pt);
			ClientToScreen(&pt);
			OnTrayRButtonDblClk(pt);
			break;*/
		case WM_LBUTTONUP:
	//		ReleaseCapture();
		/*	if(m_bdoubleclicked)
			{
				if(TrayHide())
					ShowWindow(SW_SHOW);
				m_bdoubleclicked=false;
			}*/
			break;
	} 
	return true; 
}

void TrayDialog::OnTrayRButtonUp(CPoint pt)
{
	m_menu.GetSubMenu(0)->TrackPopupMenu(TPM_LEFTALIGN|TPM_LEFTBUTTON, pt.x, pt.y, this);
	m_menu.SetDefaultItem (m_nDefaultPos) ;
}

/* associate this menu with tray */
void TrayDialog::TraySetMenu (HMENU menu, UINT nDefaultPos/*=0*/) 
{
	m_menu.Detach() ;
	m_menu.Attach (menu) ;
	m_menu.GetSubMenu(0)->SetDefaultItem (nDefaultPos) ;
}


void TrayDialog::TraySetMenu (LPCTSTR lpszMenuName, UINT nDefaultPos/*=0*/)
{
	m_menu.Detach() ;
	m_menu.LoadMenu (lpszMenuName) ;
	m_menu.GetSubMenu(0)->SetDefaultItem (nDefaultPos) ;
}

void TrayDialog::TraySetMenu (UINT idMenu, UINT nDefaultPos/*=0*/)
{
	m_menu.Detach() ;
	m_menu.LoadMenu (idMenu) ;
	m_menu.GetSubMenu(0)->SetDefaultItem (nDefaultPos) ;
}


/* update tool tip */
void TrayDialog::TraySetToolTip (CString toolTip)
{
	strncpy (m_hTrayIcon.szTip, STR_BUFFER(toolTip), sizeof (m_hTrayIcon.szTip) - 1) ;
	m_hTrayIcon.szTip[sizeof (m_hTrayIcon.szTip) - 1] = '\0' ;
	m_hTrayIcon.uFlags |= NIF_TIP ;


	Shell_NotifyIcon (NIM_MODIFY, &m_hTrayIcon) ;
}