//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// TitreImage.cpp: implementation of the TitreImage class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ETBuddies.h"
#include "TitreImage.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// differents etats du boutons
/*static*/ UINT TitreImage::RELACHE = 1 ;
/*static*/ UINT TitreImage::ENFONCE = 2 ;


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

TitreImage::TitreImage(CString nom) : Image(nom) 
{

}

TitreImage::~TitreImage()
{

}

// indique a l'image que l'utilisateur a clique a cette position
/*virtual*/ BOOL TitreImage::OnLButtonDown (CPoint pSouris) 
{
	BOOL retour = Image::OnLButtonDown(pSouris) ;
	if (retour && this->getEtat () != ENFONCE) 
	{
		//MessageBox (AfxGetMainWnd()->m_hWnd, "Bouton appuy...","Click",MB_OK) ;
	//	GetCursorPos (&this->oldSouris) ;
		CRect r ;
		CWnd * wnd = AfxGetMainWnd() ;
		wnd->GetWindowRect (r) ;

		this->oldSouris = CPoint (pSouris.x + r.left, pSouris.y + r.top) ;
		this->setEtat (ENFONCE) ;
	}
	return (retour) ;
}

// indique a l'image que l'utilisateur a clique a cette position
/*virtual*/ BOOL TitreImage::OnLButtonUp (CPoint pSouris)
{
	BOOL retour = Image::OnLButtonUp(pSouris) ;
	if (retour) 
	{
		//MessageBox (AfxGetMainWnd()->m_hWnd, "...bouton relev!","Click",MB_OK) ;
		this->setEtat (RELACHE) ;
	}
	return (retour) ;
}

// indique a l'image que l'utilisateur a boug la souris
// retourne TRUE si la souris se trouve sur l'image
/*virtual*/ BOOL TitreImage::OnMouseMove (CPoint pSouris)
{
	BOOL retour = Image::OnMouseMove (pSouris) ;

	CRect r ;
	CWnd * wnd = AfxGetMainWnd() ;
	wnd->GetWindowRect (r) ;
	pSouris = CPoint (pSouris.x + r.left, pSouris.y + r.top) ;

	if (this->getEtat() == ENFONCE && pSouris != this->oldSouris)
	{
		
		CPoint dep  = pSouris - this->oldSouris ;
		wnd->SetWindowPos (NULL, r.left + dep.x, r.top + dep.y, 0, 0, SWP_NOSIZE|SWP_NOZORDER) ;
		this->oldSouris = pSouris ;
		
	}
	return (retour) ;
}

void TitreImage::setEtat (UINT etat)	throw (Exception)
{
	if (etat != RELACHE && etat != ENFONCE)
	{
		CString ex = ""  ;
		ex.Format ("Erreur TitreImage::setEtat : l'etat demande n'est pas valide (%d)", etat) ;
		throw (Exception (CString (ex))) ;
	}

	this->etat = etat ;

}
