//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// TexteColore.h: interface for the TexteColore class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TEXTECOLORE_H__80056E09_9E1B_4F61_A50E_51A79944D615__INCLUDED_)
#define AFX_TEXTECOLORE_H__80056E09_9E1B_4F61_A50E_51A79944D615__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define COULEUR2INCO(texte)				TexteColore::Couleur2Inco(texte)
#define GET_COULEUR(texte,pos)			TexteColore::GetCouleurCar(texte,pos)
#define TEXTE_OUT(dc,texte,rect,flags)	TexteColore::dessinerTexte(dc, texte, rect, flags)
#define TEXTE_OUT2(dc,texte,rect,flags)	TexteColore::dessinerTexte(dc, texte, rect, flags, false)


class CC 
{
public:
	char lettre ;
	COLORREF couleur ;
	CC(char l, COLORREF c) {this->lettre = l; this->couleur=c;}
} ;

class TexteColore
{
private:
	CString texte ;
public:

	
	TexteColore();
	TexteColore(LPCTSTR chaine) ;
	TexteColore(CString chaine) ;

	/********************************************************
	* Transforme un texte colore en texte debarrass des	*
	* couleurs												*
	********************************************************/
	static CString Couleur2Inco (CString texteColore) ;

	/********************************************************
	* Retourne la couleur du caracter a cette posisition 	*
	* dans le texte colore									*
	********************************************************/
	static COLORREF GetCouleurCar (CString texteColore, int pos) ;

	/********************************************************
	* Indique si cette couleur existe					 	*
	********************************************************/
	static bool existe (char couleur) ;

	/********************************************************
	* Dessine le texte avec les bonnes couleurs sur ce CDC 	*
	********************************************************/
	static CSize dessinerTexte (CDC * dc, CString texteColore, CRect * rect, UINT flags, bool testeTaille = true) ;
	CSize afficher (CDC *dc, CRect * rect, UINT flags = DT_LEFT, bool testeTaille = true) ;

	static COLORREF getCouleur (char couleur) ;



	virtual ~TexteColore();

};

#endif // !defined(AFX_TEXTECOLORE_H__80056E09_9E1B_4F61_A50E_51A79944D615__INCLUDED_)
