//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// TexteColore.cpp: implementation of the TexteColore class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ETBuddies.h"
#include "TexteColore.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


#define NB_FIN_PIXEL		30
#define COULEUR_DEFAULT		RGB(0,0,0)

#define LOWER(c)			(((c) >= 'A' && (c) <= 'Z') ? (c) + ('a' - 'A') : (c))


static CC couleurs[] = 
	{
		CC('0', 0x000000),
		CC('1', 0xDA0120),
		CC('2', 0x00B906),
		CC('3', 0xE8FF19),
		CC('4', 0x170BDB),
		CC('5', 0x23C2C6),
		CC('6', 0xE201DB),
		CC('7', 0xFFFFFF),
		CC('8', 0xCA7C27),
		CC('9', 0x757575),
		CC('a', 0xEB9F53),
		CC('b', 0x106F59),
		CC('c', 0x5A134F),
		CC('d', 0x035AFF),
		CC('e', 0x681EA7),
		CC('f', 0x5097C1),
		CC('g', 0xBEDAC4),
		CC('h', 0x024D2C),
		CC('i', 0x7D081B),
		CC('j', 0x90243E),
		CC('k', 0x743313),
		CC('l', 0xA7905E),
		CC('m', 0x555C26),
		CC('n', 0xAEAC97),
		CC('o', 0xC0BF7F),
		CC('p', 0x000000),
		CC('q', 0xDA0120),
		CC('r', 0x00B906),
		CC('s', 0xE8FF19),
		CC('t', 0x170BDB),
		CC('u', 0x23C2C6),
		CC('v', 0xE201DB),
		CC('w', 0xFFFFFF),
		CC('x', 0xCA7C27),
		CC('y', 0x757575),
		CC('z', 0xCC8034),
		CC('/', 0xDBDF70),
		CC('*', 0xBBBBBB),
		CC('-', 0x747228),
		CC('+', 0x993400),
		CC('?', 0x670504),
		CC('@', 0x623307),
		CC('_', 0x660303)
	} ;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

TexteColore::TexteColore()
{
}

TexteColore::TexteColore(LPCTSTR chaine)
{
	this->texte = chaine ;
}

TexteColore::TexteColore(CString chaine)
{
	this->texte = chaine ;
}


TexteColore::~TexteColore()
{

}

/********************************************************
* Transforme un texte colore en texte debarrass des	*
* couleurs												*
********************************************************/
/*static*/ CString TexteColore::Couleur2Inco(CString texteColore)
{
	char * texte = STR_BUFFER(texteColore);
	CString retour = "";


	while (*texte != '\0') 
	{
		if (*texte == '^' && existe(*(texte + 1)))
		{
			/* Le caractere suivant est une couleur, on le saute */
			texte++ ;
		}
		else {
			/* Ce caractere fait partie du nom, on l'ajoute */
			retour += *texte ;
		}
		
		texte++;
	}
	return (retour) ;

}

/********************************************************
* Retourne la couleur du caracter a cette posisition 	*
* dans le texte colore									*
********************************************************/
/*static*/ COLORREF TexteColore::GetCouleurCar (CString texteColore, int pos)
{
	COLORREF retour = COULEUR_DEFAULT ;
	COLORREF derniereCouleur = retour ;
	char * texte = STR_BUFFER(texteColore);
	int posEnCours = 0 ;



	while (*texte != '\0') 
	{
		if (*texte == '^' && existe(*(texte + 1)))
		{
			/* Le caractere suivant est une couleur, on le saute */
			derniereCouleur = getCouleur (*(texte + 1)) ;
			texte++ ;
		}
		else if (*texte == '\n') {
			derniereCouleur = COULEUR_DEFAULT ;
			posEnCours++;
		}
		else {
			/* Ce caractere fait partie du nom, on l'ajoute */
			if (posEnCours == pos) {
				retour = derniereCouleur ;
			}
			posEnCours++;
		}
		
		texte++;
	}

	return (retour) ;

}

/********************************************************
* Indique si cette couleur existe					 	*
********************************************************/
/*static*/ bool TexteColore::existe (char couleur)
{
	bool retour = false ;
	char c = LOWER(couleur) ;
	for (int i = 0 ; i < TAILLE_LISTE(couleurs) && !retour ; i++)
	{
		if (couleurs[i].lettre == c) {
			retour = true;
		}
	}
	return (retour) ;
}


/*static*/ COLORREF TexteColore::getCouleur (char couleur)
{
	COLORREF retour = COULEUR_DEFAULT ;
	for (int i = 0 ; i < TAILLE_LISTE(couleurs) ; i++)
	{
		if (couleurs[i].lettre == LOWER(couleur)) {
			BYTE * coul = (BYTE*)&couleurs[i].couleur ;
			retour =  RGB(coul[2],coul[1],coul[0]) ;
		}
	}
	return (retour) ;
}

/********************************************************
* Dessine le texte avec les bonnes couleurs sur ce CDC 	*
* Retourne la taille qu'occupe le texte					*
********************************************************/
/*static*/ CSize TexteColore::dessinerTexte (CDC * dc, CString texteColore, CRect * rect, UINT flags, bool testeTaille /*= true*/)
{
	CSize retour(0,0) ;
	int largeurLigne = 0;
	bool fin = false ;				/* indique si le texte depasse la taille du rectangle */
	int nbCar ;

	CString texte = COULEUR2INCO(texteColore) ;
	nbCar = texte.GetLength() ;
	/* parcours du tableau de caracteres */
	CRect r(*rect) ;
	for (int j = 0 ; j < nbCar && !fin; j++)
	{
		

		/* si le texte depasse, on affiche "..." et on passe a la ligne suivante */
		if (testeTaille && largeurLigne > rect->Width() - NB_FIN_PIXEL && j < nbCar - 3) {
			COLORREF oldC = dc->SetTextColor (COULEUR_DEFAULT) ;
			dc->DrawText ("...", &r, flags) ;
			dc->SetTextColor (oldC) ;

			while (j < nbCar && texte[j] != '\n') {
				j++ ;
			}

		}

		if (j < nbCar) {
			/* Recuperation du caractere en cours */
			CString car = texte[j] ;

			if (car == '\n') {
				/* Le caractere est un retour a la ligne, on passe a la ligne suivante */
				r.left = rect->left ;
				int taille = dc->GetTextExtent(car).cy ;
				r.top += taille ;
				retour.cy += taille ;
				if (retour.cx < largeurLigne) {
					retour.cx = largeurLigne ;
				}
				largeurLigne = 0 ;
			}
			else {
				/* Recuperation de la couleur de ce caractere */
				COLORREF oldC = dc->SetTextColor (GET_COULEUR(texteColore, j)) ;
				
				/* Affichage du caractere et decalage de la position */
				dc->DrawText (STR_BUFFER(car), &r, flags) ;
				int largeur = dc->GetTextExtent(car).cx ;
				r.left += largeur ;
				largeurLigne += largeur ;
				
				/* Restauration de la couleur precedente */
				dc->SetTextColor (oldC) ;
			}
		}
	}

	if (retour.cx < largeurLigne) {
		retour.cx = largeurLigne ;
	}

	return (retour) ;
}

CSize TexteColore::afficher (CDC *dc, CRect * rect, UINT flags /*= DT_LEFT*/, bool testeTaille /*= true*/)
{
	return (TexteColore::dessinerTexte(dc, this->texte, rect, flags, testeTaille)) ;
}