//this file is part of ETBuddies
//Copyright (C)2004-2005 Jos ( josb@oreka.com / http://www.etbuddies.tk )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// StartPrograms.cpp: implementation of the StartPrograms class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ETBuddies.h"
#include "StartPrograms.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

#define FICHIER_SOFTWARES		"softwares.dat"

/*static*/ CString StartPrograms::NOM_CLASSE = "StartPrograms" ;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

StartPrograms::StartPrograms(): Objet(NOM_CLASSE) 
{

}

StartPrograms::~StartPrograms()
{

}



/* add a server to the list */
void StartPrograms::addSoftware (CString soft, CString args) {
	removeSoftware(soft) ;
	m_softwares.insert (Soft2Args::value_type(soft, args)) ;
	try {
		saveSoftwares() ;
	}
	catch (Exception e) {}
}

	
CString StartPrograms::getArgument(CString soft) {
	Soft2Args::iterator i ;
	bool trouve = false ;
	CString retour = "" ;


	for (i = m_softwares.begin() ; i != m_softwares.end() && !trouve; i++) {
		if (i->first == soft) {
			trouve = true ;
			retour = i->second ;
		}
	}

	return (retour) ;
}

vector<CString> StartPrograms::getSoftwares() 
{
	vector<CString> retour ;
	Soft2Args::iterator i ;

	for (i = m_softwares.begin() ; i != m_softwares.end(); i++) {
		retour.push_back(i->first) ;
	}

	return (retour) ;
}


/* remove this server from list if exist */
void StartPrograms::removeSoftware (CString soft) {
	Soft2Args::iterator i ;
	bool trouve = false ;

	for (i = m_softwares.begin() ; !trouve && i != m_softwares.end() ; i++) {
		if (i->first == soft) {
			trouve = true ;
			m_softwares.erase(i) ;
			try {
				saveSoftwares() ;
			}
			catch (Exception e) {}
			break;
		}
	}
}


/*virtual*/ void StartPrograms::serialize (Fichier * f) throw (Exception) 
{
	Objet::serialize(f) ;

	int nbElem = m_softwares.size() ;
	/* write number of passwords */
	f->Write (&nbElem, 1, sizeof (int)) ;

	Soft2Args::iterator i ;
	for (i = m_softwares.begin() ; i != m_softwares.end(); i++) 
	{
		f->WriteString(i->first) ;
		f->WriteString(i->second) ;
	}

}
/*static*/ Objet * StartPrograms::getFromFile (Fichier * f) throw (Exception) {
	// verification de la validite du fichier
	delete (Objet::getFromFile(f, NOM_CLASSE)) ;

	StartPrograms * retour = new StartPrograms() ;

	int nbElem = 0 ;
	/* read number of passwords */
	f->Read (&nbElem, 1, sizeof (int)) ;
	if (nbElem < 0)		FICHIER_CORROMPU(f) ;

	CString soft ;
	CString args ;
	

	/* reads ip adress of every favorite */
	for (int i = 0 ; i < nbElem ; i++) 
	{
		soft = f->ReadString() ;
		args = f->ReadString() ;
		retour->addSoftware (soft, args) ;
	}

	return (retour) ;

}


void StartPrograms::saveSoftwares() throw (Exception) 
{
	Fichier f (FICHIER_SOFTWARES, Fichier::MODE_WRITE) ;
	serialize (&f) ;
}

/*static*/ StartPrograms * StartPrograms::loadSoftwares() throw (Exception) 
{
	Fichier f (FICHIER_SOFTWARES, Fichier::MODE_READ) ;
	return (StartPrograms*)StartPrograms::getFromFile(&f) ;
}