//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// Socket.h: interface for the Socket class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SOCKET_H__10E067CD_3C6F_4185_B9E5_78E80625FD6F__INCLUDED_)
#define AFX_SOCKET_H__10E067CD_3C6F_4185_B9E5_78E80625FD6F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Exception.h"
#include "Packet.h"
#include "Objet.h"
//#include <winsock.h>

#define TEST_NEW_SOCK

class Socket : public CAsyncSocket, public Objet  
{
protected:

#ifndef	TEST_NEW_SOCK
	SOCKET sock ;
#endif
	
	bool ouvert ;
	DWORD timeOut ;
public:
	Socket();
	virtual ~Socket();

	// cree un socket
	void create (UINT nSocketPort = 0, int nSockType = SOCK_STREAM, LPCTSTR lpszSocketAdresse = NULL) throw (Exception) ;

	// connecte le socket a un server distant
	// attention : le socket doit avoir ete cr avant!
	void connect (LPCTSTR lpszHostAdresse, UINT port, bool getHost = true) throw (Exception) ;

	// envoie dataLength octets sur le socket
	// retourne le nombre de caracteres emis
	int send (const char * data, int dataLength) throw (Exception) ;
	
	// recoit dataLength caracteres maximum dans data
	// retourne le nombre de caracteres recu
	int receive (char * data, int dataLength) throw (Exception) ;

	// ferme le socket
	virtual void Close () ;
	void close () ;

	// indique si le socket est ouvert
	bool estOuvert () {return (this->ouvert);}

	// provoquera un timeout losque la lecture prendra plus de milliSec millisecondes
	void setTimeOut (DWORD milliSec) {this->timeOut = milliSec;}

	// indique si le serveur est time out en fonction du temps de depart
	bool estTimeOut (DWORD tempsDepart) {return (GetTickCount() - tempsDepart > this->timeOut);}

	virtual void OnReceive (int nErrorCode ) ;

	// traite le paquet entrant
	// leve une exception si le packet est incorrect
	// ATTENTION, n'appeller Socket::traiterPacket qu'a la fin du traitement!!
	virtual void traiterPacket (Packet * packet) throw (Exception)  ;


};

#endif // !defined(AFX_SOCKET_H__10E067CD_3C6F_4185_B9E5_78E80625FD6F__INCLUDED_)
