//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// Socket.cpp: implementation of the Socket class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ETBuddies.h"
#include "Socket.h"
#include <afxpriv.h>
#include "EtbuddiesDlg.h"

//#include <winsock.h>


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

#define MAX_BUFF		4096

/*
#define	ERREUR	\
	{\
		CString erreur ;\
		LPVOID lpMsgBuf;\
		FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,\
		NULL, GetLastError(), MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),\
		(LPTSTR) &lpMsgBuf, 0, NULL);\
		erreur.Format ("Erreur socket : %s", (LPTSTR)lpMsgBuf) ;\
		throw (Exception((CString)erreur)) ;\
	}
*/

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Socket::Socket() : Objet ("Socket")
{
	//this->socket = new CSocket () ;
	this->ouvert = false ;
	this->setTimeOut(5000) ;
}

Socket::~Socket()
{
	//delete (this->socket) ;
	this->close() ;
}


void Socket::create (UINT nSocketPort /*= 0*/, int nSockType /*= SOCK_STREAM*/, LPCTSTR lpszSocketAdresse /*= NULL*/) throw (Exception)
{
/*	WORD version= MAKEWORD(2,2);
    WSADATA wsa_data;
    if ( WSAStartup(version,&wsa_data) != 0)  {
		throw (Exception("Could not open winsock")) ;
    }*/

#ifndef	TEST_NEW_SOCK
	this->sock = socket (AF_INET, nSockType,  IPPROTO_UDP) ;

//	if (!this->socket->Create (nSocketPort, nSockType, lpszSocketAdresse))
	if (this->sock == INVALID_SOCKET)
	{
		ERREUR("Erreur Socket::create") ;
	}
#else
	if (this->Create (nSocketPort, nSockType) == 0)	{
		ERREUR("Erreur Socket::create") ;
	}
#endif

}

void Socket::connect (LPCTSTR lpszHostAdresse, UINT port, bool getHost /*= true*/) throw (Exception)
{
//	if (!this->socket->Connect (lpszHostAdresse, port))

#ifndef TEST_NEW_SOCK
	UINT ipaddr = 0 ;
	hostent * h = NULL ;

	if (getHost) {
		h = gethostbyname (lpszHostAdresse) ;
		if (h == NULL)			ERREUR("Erreur Socket::connect");
	}
	else {
		ipaddr = inet_addr(lpszHostAdresse) ;
	}

	

	sockaddr_in  addr ;
	addr.sin_family = AF_INET ;
	addr.sin_port = htons(port) ;
	memset (addr.sin_zero,0, sizeof(addr.sin_zero)) ;

	if (getHost)		addr.sin_addr = *((struct in_addr*)h->h_addr);
	else				addr.sin_addr.s_addr = ipaddr ;


	if (addr.sin_addr.s_addr == INADDR_NONE)
		ERREUR("Erreur Socket::connect");

	//addr.sin_addr =// lpszHostAdresse
	if (::connect (this->sock, (struct sockaddr*)&addr, sizeof (struct sockaddr)) == SOCKET_ERROR)
	{
		ERREUR("Erreur Socket::connect");
	}
#else
	if (!this->Connect (lpszHostAdresse, port)) {
		ERREUR("Erreur Socket::connect");
	}
#endif

	this->ouvert = true;
}

int Socket::send (const char * data, int dataLength) throw (Exception)
{
#ifndef TEST_NEW_SOCK
	int retour = ::send(this->sock, data, dataLength, 0) ;
/*	int retour = this->socket->Send (data, dataLength) ;*/
	if (retour == SOCKET_ERROR)
	{
		ERREUR("Erreur Socket::send()") ;
	}
#else
	int retour = this->Send (data, dataLength) ;
	if (retour == SOCKET_ERROR && GetLastError() != WSAEWOULDBLOCK) {
		ERREUR("Erreur Socket::send()") ;
	}
#endif


	return (retour) ;
//	return 0;
}


int Socket::receive (char * data, int dataLength) throw (Exception)
{
	//int retour = this->socket->Receive (data, dataLength) ;
	DWORD tempsDepart = GetTickCount() ;

#ifndef TEST_NEW_SOCK
	int retour = recv (this->sock, data, dataLength, 0) ;
	if (retour == SOCKET_ERROR)
	{
		ERREUR("Erreur Socket::receive") ;
	}
#else
	// lecture des infos jusqu'a time-out
	int retour ;
	do
	{
		retour = this->Receive (data, dataLength) ;
	} while (!this->estTimeOut(tempsDepart) && retour == SOCKET_ERROR && GetLastError() == WSAEWOULDBLOCK) ;

	if (retour == SOCKET_ERROR && GetLastError() != WSAEWOULDBLOCK)	{
		ERREUR("Erreur Socket::send()") ;
	}
#endif

	return (retour) ;
//	return 0;
}

void Socket::close ()
{
//	this->socket->Close () ;
//	WSACleanup();
	if (estOuvert())
	{
		this->ouvert = false ;
#ifndef TEST_NEW_SOCK
		closesocket (this->sock) ;
#else
	this->Close() ;

#endif
	}
}


/*virtual*/ void Socket::Close()
{
	// For the socket about to be closed.
     SOCKET hDeadSocket = m_hSocket;

     if (m_hSocket != INVALID_SOCKET)
	{
		VERIFY(SOCKET_ERROR != closesocket(m_hSocket));
		//CAsyncSocket::KillSocket(m_hSocket, this);
		m_hSocket = INVALID_SOCKET;
	}

    /* MSG msg;
     CSocket::ProcessAuxQueue();
     while(::PeekMessage(&msg,NULL,
             WM_SOCKET_NOTIFY,WM_SOCKET_DEAD,PM_REMOVE))
     {
       ::DispatchMessage(&msg);
       if( (msg.message==WM_SOCKET_DEAD) &&
           ((SOCKET)msg.wParam==hDeadSocket))
         break;
     }*/

}

/*virtual*/ void Socket::OnReceive (int nErrorCode )
{
	BYTE buffer[MAX_BUFF] ;
	CString servFrom ;
	UINT portFrom ;

	int longueur ;
/*	do
	{*/
		longueur = this->ReceiveFrom (buffer, MAX_BUFF, servFrom, portFrom) ;
		if (longueur != SOCKET_ERROR)
		{
			try
			{
			/*	CString ip ;
				ip.Format ("%s:%d", servFrom, portFrom) ;*/
				char server[1024] ;
				sprintf (server, "%s:%d", STR_BUFFER(servFrom), portFrom) ;
				this->traiterPacket (new Packet(buffer, longueur, server)) ;
			}
			CATCH_EXCEPTION_NO_MSG;
		}
/*	} while (longueur > 0 && longueur != SOCKET_ERROR) ;*/

}

// traite le paquet entrant
// leve une exception si le packet est incorrect
// ATTENTION, n'appeller Socket::traiterPacket qu'a la fin du traitement!!
/*virtual*/ void Socket::traiterPacket (Packet * packet)
{
	delete (packet) ;
}
