//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// Skin.h: interface for the Skin class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SKIN_H__9000D9E7_F9A8_4916_9EE7_99F52020EB46__INCLUDED_)
#define AFX_SKIN_H__9000D9E7_F9A8_4916_9EE7_99F52020EB46__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Preferences.h"
#include "Image.h"
#include "Exception.h"
#include <vector>
#include "Buddie.h"
#include "ListeBuddies.h"
#include "BuddyImage.h"
#include "Observer.h"
#include "ProgressImage.h"
#include "ScrollImage.h"
#include "JoueursDlg.h"
#include "BackgroundJoueur.h"

using namespace std ;

class CETBuddiesDlg ;

// nombre d'image que compose le skin
#define NB_IMAGES		15

enum {	MAIN, MAIN_TITLE,		// interface principale
		MENU_FILES,MENU_OPTIONS,MENU_ABOUT, MAIN_CLOSE,												// boutons du menu
		BOUTON_REFRESH, BOUTON_ADD/*, BOUTON_DELETE*/, BOUTON_EXIT,	BOUTON_STOP_R,					// boutons du bas	
		BUDDY_ONLINE, BUDDY_OFFLINE, PROGRESS, SCROLL, BACK_JOUEURS} ;

#define BUDDY				0xF0															


// taille du skin
#define SKIN_MIN_SIZE		CSize(205,301)

class Skin : public Observer, public Objet
{
private:
	Preferences * pref ;
	Image * images [NB_IMAGES] ;
//	Police * police ;
	vector <BuddyImage*> listeBudImages ;
	ProgressImage * progress ;
	ScrollImage * scroll ;
	BackgroundJoueur * back ;
	CETBuddiesDlg * parent ;

	// nom du dernier skin charg
	CString nomSkin ;

	// taille totale du skin
	CSize taille ;
	

	
	// charge la liste des BuddyImage
	void chargerBuddies () ;

	/****************************************************************
	* Efface toutes les images de la liste							*
	****************************************************************/
	void effacerImages () ;

	/****************************************************************
	* Indique si le buddy numero n est visible sur le skin			*
	****************************************************************/
	bool estBuddyVisible (int n, BuddyImage * buddy) ;

	/****************************************************************
	* Met a jour les donnes du Scrolling en fonction de la taille	*
	* de la fenetre													*
	****************************************************************/
	void MAJScrolling () ;

	
	/****************************************************************
	* Affiche les images buddy sur la nieme ligne					*
	* si l'image ne depasse pas de la fenetre						*
	* Affiche egalement les infos du joueur							*
	****************************************************************/
	void afficherBuddy (CDC *dc/*, CSize tailleFen*/, int n/*, Buddie * bud*/) ;

	
public:

	Skin(Preferences * pref, CETBuddiesDlg * parent);
	virtual ~Skin();

	/****************************************************************
	* Charge le skin portant ce nom									*
	* Leve une exception en cas de probleme							*
	****************************************************************/
	void chargerSkin (CString nomSkin) throw (Exception) ;

	/****************************************************************
	* Charge le skin numero n de la liste getListeSkins				*
	* Leve une exception en cas de probleme							*
	****************************************************************/
	void chargerSkin (int n) throw (Exception) ;


	/****************************************************************
	* Retourne le repertoire d'installation du skin					*
	****************************************************************/
	CString getPath () ;


	/****************************************************************
	* renvoie la chaine de caractere correspondant a l'id			*
	* du morceau de skin											*
	****************************************************************/
	static CString getChaine (UINT id, bool getExt = false) ;

	/****************************************************************
	* Affichage du skin												*
	****************************************************************/
	void afficherSkin (CDC * dc, CSize tailleFen, ListeBuddies * liste) throw (Exception) ;
	
	/****************************************************************
	* Retourne la taille minimale du skin							*
	****************************************************************/
	CSize getMinSize(CDC * dc) throw (Exception) ;

	/****************************************************************
	* Retourne l'image representant le online						*
	****************************************************************/
	Image * getImageOnline () ;



	/****************************************************************
	* Diverses interactions effectue sur le skin					*
	****************************************************************/
	void OnLButtonDown (CPoint pSouris) ;
	void OnLButtonUp (CPoint pSouris) ;
	void OnMouseMove (CPoint pSouris) ;
	void OnLButtonDblClk (CPoint pSouris) ;
	void OnRButtonUp (CPoint pSouris) ;
	virtual void ajouterObserver (Observer * e) ;

	/****************************************************************
	* Affiche tous les joueurs connects de ce buddie				*
	****************************************************************/
	void afficherJoueurs (JoueursDlg * dialog, CDC * dc, Buddie * buddie) throw (Exception) ;


	/****************************************************************
	* Retourne la liste des nom de skins disponibles				*
	****************************************************************/
	vector<CString> getListeSkins () ;

	/****************************************************************
	* Retourne le skin numero n ou "" s'il n'existe pas				*
	****************************************************************/
	CString getSkin (int n) ;


	/****************************************************************
	* Retourne le numero du skin portant ce nom ou -1 s'il			*
	* n'existe pas													*
	****************************************************************/
	int getSkin (CString nom) ;

	// appelle la fonction lorsque l'objet a ete modifie
	virtual void OnChange (Objet * obj, UINT msg, void * param1,void * param2) ;

	// retourne le ProgressImage du skin
	ProgressImage * getProgress ()	{return (this->progress);}

};

#endif // !defined(AFX_SKIN_H__9000D9E7_F9A8_4916_9EE7_99F52020EB46__INCLUDED_)
