//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// Skin.cpp: implementation of the Skin class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ETBuddies.h"
#include "ETBuddiesDlg.h"
#include "Skin.h"
#include "BoutonImage.h"
#include "BoutonFiles.h"
#include "TitreImage.h"
#include "BoutonFermer.h"
#include "BoutonAbout.h"
#include "BoutonActualiser.h"
#include "BuddyImage.h"
#include "BoutonAdd.h" 
#include "BoutonSub.h"
#include "BoutonExit.h"
#include "MainImage.h"
#include "ProgressImage.h"
#include "BoutonOptions.h"
#include "ScrollImage.h"
#include "BoutonStopRefresh.h"
#include "BackgroundJoueur.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

#define PATH(rep)		rep + CString ("skins\\")
#define EXT				CString (".bmp")

#define HAUTEUR_TEXTE	15

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////





#define HAUTEUR_TITRE		4			//  Nb de pixel separant le titre de la barre du haut

// position du menu files par rapport a la limite gauche de la fenetre
#define MENU_FILES_X		18
// position du menu about par rapport a la limite droite de la fenetre
#define MENU_ABOUT_X		18

#define MAIN_CLOSE_X		9
// position des menu par rapport au haut de la fenetre
#define MENU_Y				27
// ordonnee des boutons du bas par rapport au bas de la fenetre
#define BOUTONS_BAS_Y		35
// abscisse des boutons du bas par rapport au bord gauche de la fenetre
#define BOUTONS_BAS_X		29
// nb de pixel separant chaque boutons
#define BOUTONS_SEPAR		39

#define BUDDY_X				23
#define BUDDY_Y				62
#define BUDDYR_X			57
#define ECART_BUDDY			8
#define FIN_BUDDY_Y			70
#define HAUTEUR_BUDDY		34

#define PROGRESS_X			10
#define PROGRESS_Y			54

#define SCROLL_X			30
#define SCROLL_Y			62
#define END_SCROLL_Y		FIN_BUDDY_Y
#define LARGEUR_SCROLL		9

// taille en pixel du bord de la fenetre des joueurs
#define BORD_FENETRE_X		5




Skin::Skin(Preferences * pref, CETBuddiesDlg * parent) : Objet("skin")
{
	this->pref = pref ;
	memset (this->images, 0, sizeof(this->images)) ;
	this->parent = parent ;
	//this->police = NULL ;
	this->progress = NULL ;
	parent->getListeBud()->ajouterObserver (this) ;
}

Skin::~Skin()
{
	this->effacerImages () ;
//	if (this->police)	delete (this->police) ;
	EFFACER_LISTE(BuddyImage, this->listeBudImages) ;
}

/****************************************************************
* Efface toutes les images de la liste							*
****************************************************************/
void Skin::effacerImages ()
{
	for (int i = 0 ; i < NB_IMAGES ; i++)
	{
		if (this->images[i])
		{
			delete (this->images[i]) ;
			this->images [i] = NULL ;
		}
	}
	/*if (this->police)
	{
		delete (this->police) ;
		this->police = NULL ;
	}*/
	EFFACER_LISTE(BuddyImage, this->listeBudImages) ;
}

/****************************************************************
* Retourne le repertoire d'installation du skin					*
****************************************************************/
CString Skin::getPath ()
{
	if (this->nomSkin == "") {
		return ("") ;
	}
	return (GET_SKIN_DIR + nomSkin + "\\") ;
}

/****************************************************************
* Charge le skin portant ce nom									*
* Leve une exception en cas de probleme							*
****************************************************************/
void Skin::chargerSkin (CString nomSkin)
{
	this->nomSkin = nomSkin ;

	this->effacerImages () ;
	CString path = this->getPath() ;
	CString nomIm, enfonce ;
	

	for (int i = 0 ; i < NB_IMAGES ; i++)
	{
		nomIm = path + getChaine(i)  ;
		enfonce = nomIm + "_c" ;
		nomIm += EXT ;
		enfonce += EXT ;
		

		switch (i)
		{
			/*********************** Bouton files ***************************************/
		case MENU_FILES:
			this->images[i] = new BoutonFiles (nomIm, nomIm) ;
			break ;

			/*********************** Bouton options	*************************************/
		case MENU_OPTIONS:
			this->images [i] = new BoutonOptions (nomIm, nomIm) ;
			break;

			/*********************** Bouton about ***************************************/
		case  MENU_ABOUT:
			this->images [i] = new BoutonAbout (nomIm, nomIm) ;
			break ;

			/*********************** Titre **********************************************/
		case MAIN_TITLE:
			this->images [i] = new TitreImage (nomIm) ;
			break;

			/*********************** Bouton fermer **************************************/
		case MAIN_CLOSE:
			this->images [i] = new BoutonFermer (nomIm, nomIm) ;
			break;

			/*********************** Bouton ajouter *************************************/
		case BOUTON_ADD: 
			this->images [i] = new BoutonAdd (nomIm, enfonce) ;
			break;

			/*********************** Bouton supprimer ***********************************/
/*		case BOUTON_DELETE: 
			this->images [i] = new BoutonImage (nomIm, enfonce) ;
			break;*/

			/*********************** Bouton quitter *************************************/
		case BOUTON_EXIT:
			this->images [i] = new BoutonExit (nomIm, enfonce) ;
			break ;

			/*********************** Bouton rafraichissement ****************************/
		case BOUTON_REFRESH:
			this->images [i] = new BoutonActualiser (nomIm, enfonce) ;
			break ;

			/*********************** Image principale ***********************************/
		case MAIN:
			this->images [i] = new MainImage (nomIm) ;
			break ;

			/*********************** Barre de progre ************************************/
		case PROGRESS:
			this->progress  = new ProgressImage (nomIm) ;
			this->images [i] = this->progress ;
			break;

		case SCROLL:
			this->scroll = new ScrollImage (nomIm) ;
			this->images [i] = this->scroll ;
			break ;

		case BOUTON_STOP_R:
			this->images [i] = new BoutonStopRefresh (nomIm, enfonce) ;
			break ;

		case BACK_JOUEURS:
			this->back = new BackgroundJoueur (nomIm) ;
			this->images [i] = this->back ;
			break ;


			/*********************** Image classique ************************************/
		default:
			this->images[i] = new Image (nomIm) ;
			break ;
		}
	}
//	this->police = new Police (path + CString("polices.bmp"), IDR_POLICED, "DATA") ;

	this->chargerBuddies () ;
}

/****************************************************************
* Retourne l'image representant le online						*
****************************************************************/
Image * Skin::getImageOnline ()
{
	return (this->images[BUDDY_ONLINE]) ;
}

/****************************************************************
* renvoie la chaine de caractere correspondant a l'id			*
* du morceau de skin											*
****************************************************************/
/*static*/ CString Skin::getChaine (UINT id, bool getExt /*= false*/)
{
	CString retour = "" ;
	switch (id)
	{
	case MAIN:			retour = "main" ;				break ;
	case MAIN_TITLE:	retour = "main_title";			break ;
	case MENU_FILES:	retour = "menu_files";			break ;
	case MENU_OPTIONS:	retour = "menu_options";		break ;
	case MENU_ABOUT:	retour = "menu_about";			break ;
	case MAIN_CLOSE:	retour = "main_close";			break ;
	case BOUTON_REFRESH:retour = "bouton_refresh" ;		break ;
	case BOUTON_ADD:	retour = "bouton_add" ;			break ;
//	case BOUTON_DELETE:	retour = "bouton_delete" ;		break ;
	case BOUTON_EXIT:	retour = "bouton_exit" ;		break ;
	case BOUTON_STOP_R:	retour = "bouton_stop" ;		break ;
	case BUDDY:			retour = "buddy";				break ;
	case BUDDY_ONLINE:	retour = "buddy_online" ;		break ;
	case BUDDY_OFFLINE:	retour = "buddy_offline" ;		break ;
	case PROGRESS:		retour = "progress" ;			break ;
	case SCROLL:		retour = "scroll" ;				break ;
	case BACK_JOUEURS:	retour = "background_joueurs";	break ;
	default:			retour = "erreur";				break ;
	}
	if (getExt)			retour += EXT ;
	return (retour) ;
}

/****************************************************************
* Affichage du skin												*
****************************************************************/
void Skin::afficherSkin (CDC * dc, CSize tailleFen, ListeBuddies * liste) throw (Exception)
{
	this->taille = tailleFen ;
	CSize imSize[NB_IMAGES] ;
	CSize tailleSkin = this->getMinSize(dc) ;
	this->MAJScrolling () ;


	/****************************************************************
	* Recuperation des tailles des images composant le skin			*
	****************************************************************/
	for (int i = 0 ; i < NB_IMAGES ; i++)
	{
		imSize [i] = this->images[i]->getSize(dc) ;
	}


	/****************************************************************
	* Affichage du skin principal									*
	****************************************************************/
	this->images [MAIN]->afficher (dc, 0, 0, tailleFen.cx, tailleFen.cy) ;


	/****************************************************************
	* Affichage du titre et du bouton fermer du skin				*
	****************************************************************/
	this->images[MAIN_TITLE]->afficher(dc, (tailleFen.cx  - imSize[MAIN_TITLE].cx) / 2, HAUTEUR_TITRE) ;
	this->images[MAIN_CLOSE]->afficher (dc, tailleFen.cx  - imSize[MAIN_CLOSE].cx - MAIN_CLOSE_X, HAUTEUR_TITRE) ;


	/****************************************************************
	* Affichage du menu du skin										*
	****************************************************************/
	this->images[MENU_FILES]->afficher (dc, MENU_FILES_X, MENU_Y) ;
	this->images[MENU_OPTIONS]->afficher (dc, (tailleFen.cx  - imSize[MENU_OPTIONS].cx) / 2, MENU_Y) ;
	this->images[MENU_ABOUT]->afficher (dc, tailleFen.cx  - imSize[MENU_ABOUT].cx - MENU_ABOUT_X, MENU_Y) ;

	


	/****************************************************************
	* Affichage des bouton du bas									*
	****************************************************************/
	this->images[BOUTON_REFRESH]->afficher (dc,
		BOUTONS_BAS_X,
		tailleFen.cy - BOUTONS_BAS_Y) ;

	this->images[BOUTON_STOP_R]->afficher (dc,
		BOUTONS_BAS_X + BOUTONS_SEPAR,
		tailleFen.cy - BOUTONS_BAS_Y) ;

	this->images[BOUTON_ADD]->afficher (dc,
		BOUTONS_BAS_X + BOUTONS_SEPAR * 2,
		tailleFen.cy - BOUTONS_BAS_Y) ;

	this->images[BOUTON_EXIT]->afficher (dc,
		BOUTONS_BAS_X + BOUTONS_SEPAR * 3,
		tailleFen.cy - BOUTONS_BAS_Y) ;



	/****************************************************************
	* Affichage de la barre de progression							*
	****************************************************************/
	this->images[PROGRESS]->afficher (dc, PROGRESS_X, tailleFen.cy - PROGRESS_Y, tailleFen.cx - 2 * PROGRESS_X, imSize[PROGRESS].cy) ;

	this->images[SCROLL]->afficher (dc, tailleFen.cx - SCROLL_X, SCROLL_Y, LARGEUR_SCROLL, tailleFen.cy - END_SCROLL_Y - SCROLL_Y) ;


	/****************************************************************
	* Affichage des buddies											*
	****************************************************************/
	for (i = 0 ; i < liste->getSize () ; i++)
	{
		this->afficherBuddy (dc/*, tailleFen*/, i/*, liste->getBuddie (i)*/) ;
	}

}

/****************************************************************
* Affiche tous les joueurs connects de ce buddie				*
****************************************************************/
void Skin::afficherJoueurs (JoueursDlg * dialog, CDC * dc, Buddie * buddie) throw (Exception)
{
	vector<Server*> * serveurs = buddie->getServeurs() ;
	vector<BuddyJoueurImage*> * listeJ = dialog->getListeJoueurs() ;

	UINT nbJoueurs = listeJ->size() ;
	CPoint tailleBords = this->images[BACK_JOUEURS]->getSize (dc) ;
	UINT dialogX, dialogY ;

	dialogX = dialog->getTaille().cx ;
	dialogY = tailleBords.y + nbJoueurs * (HAUTEUR_BUDDY + ECART_BUDDY) - 22 ;
	dialog->setTaille (CSize (dialogX, dialogY)) ;
	this->back->afficher (dc, 0, 0, dialogX - BORD_FENETRE_X, dialogY) ;

	/****************************************************************
	* Affichage des BuddyImage										*
	****************************************************************/
	int i = 0 ;
	
	FOR_VECTOR_IND(BuddyJoueurImage*, (*listeJ), j)
	{
		/****************************
		* Affichage de l'image		*
		****************************/
		CPoint depart = this->back->getPointDepart() ;
		depart.y = depart.y + i * (HAUTEUR_BUDDY + ECART_BUDDY) ;
		(*j)->afficher (
			dc,
			depart.x, depart.y,
			dialogX - BORD_FENETRE_X - this->back->getTailleBordure()
			) ;

		/****************************
		* Affichage du texte		*
		****************************/
		/*	BUDDY_X + 5, coory + tailleLeft.y / 2 + 3,
		BUDDY_X + 5 + budIm->getSize(dc).x,*/
		CRect rect (5 + depart.x, 5 + depart.y, 0, 0) ;
		rect.bottom = rect.top + HAUTEUR_TEXTE ;
		rect.right = rect.left + 5 + (*j)->getSize(dc).x ;
		(*j)->afficherLigne1 (dc, rect) ;

		rect = CRect (5 + depart.x, depart.y + (*j)->getSize(dc).y / 2, 0, 0) ;
		rect.bottom = rect.top + HAUTEUR_TEXTE ;
		rect.right = rect.left + 5 + (*j)->getSize(dc).x ;
		(*j)->afficherLigne2 (dc, rect) ;

		i++ ;
	}
	

}


/****************************************************************
* Retourne la taille minimale du skin							*
****************************************************************/
CSize Skin::getMinSize(CDC * dc) throw (Exception)
{
	if (!this->images[0])
	{
		throw (Exception (CString ("Skin::getMinSize() : Aucun skin charg!"))) ;
	}
	CSize retour ;
	return (this->images[MAIN]->getSize(dc)) ;
}


/****************************************************************
* Retourne la liste des nom de skins disponibles				*
****************************************************************/
vector<CString> Skin::getListeSkins ()
{
	CFileFind find ;
	vector<CString> retour ;
	CString path = PATH(this->pref->getRepInstall()) + CString ("*.*") ;
	BOOL trouve = TRUE ;
	if (find.FindFile (path))
	{
		while (trouve)
		{
			trouve = find.FindNextFile () ;
			if (find.IsDirectory () && !find.IsDots())
			{
				retour.push_back (find.GetFileName ()) ;
			}
		}
	}

	return (retour) ;
}


/****************************************************************
* Charge le skin numero n de la liste getListeSkins				*
* Leve une exception en cas de probleme							*
****************************************************************/
void Skin::chargerSkin (int n) throw (Exception)
{
	CString skin = this->getSkin (n) ;
	if (skin.Compare("") == 0)
	{
		throw (Exception ("Erreur Skin::chargerSkin : parametre incorrect")) ;
	}
	this->chargerSkin (skin) ;
}


/****************************************************************
* Retourne le skin numero n ou "" s'il n'existe pas				*
****************************************************************/
CString Skin::getSkin (int n)
{
	if (n < 0)		return ("") ;
	int j = 0 ;
	vector<CString> liste = this->getListeSkins () ;

	vector<CString>::iterator i;
	for (i = liste.begin() ; i != liste.end() && j < n ; i++,j++)
	{
	}

	if (i == liste.end())	return ("") ;
	return (*i) ;

}

/****************************************************************
* Retourne le numero du skin portant ce nom ou -1 s'il			*
* n'existe pas													*
****************************************************************/
int Skin::getSkin (CString nom)
{
	int retour = -1 ;
	int j = 0;
	vector<CString> liste = this->getListeSkins () ;

	vector<CString>::iterator i;
	for (i = liste.begin() ; i != liste.end()  && retour == -1; i++,j++)
	{
		if ((*i).Compare(nom) == 0)
		{
			retour = j ;
		}
	}

	return (retour) ;
}

/****************************************************************
* Affiche les images buddy sur la nieme ligne					*
* si l'image ne depasse pas de la fenetre						*
* Affiche egalement les infos du joueur							*
****************************************************************/
void Skin::afficherBuddy (CDC *dc/*, CSize tailleFen*/, int n/*, Buddie * bud*/)
{
	BuddyImage * budIm = NULL ;
	int enCours = 0 ;
	UINT nbOnlines = 0 ;
	Buddie * bud ;
	vector<BuddyImage*> listeTriee ;
	CSize tailleFen = this->taille ;
	bool estOnline ;					// indique si le buddy en cours est online


	

	/****************************************************************
	* Cre la liste des buddy images tris							*
	* Ajoute les joueurs Online...									*
	****************************************************************/
	{
		FOR_VECTOR(BuddyImage*, this->listeBudImages)
		{
			if ((*i)->getBuddy()->estConnecte()) {
				listeTriee.push_back (*i) ;
			}
		}
	}
	/****************************************************************
	* ... puis Offline												*
	****************************************************************/
	{
		FOR_VECTOR(BuddyImage*, this->listeBudImages)
		{
			if (  !((*i)->getBuddy()->estConnecte())  ) {
				listeTriee.push_back (*i) ;
			}
		}
	}
	

	/****************************************************************
	* Recherche de l'image a afficher								*
	****************************************************************/
	FOR_VECTOR_COND(BuddyImage*, listeTriee, !budIm)
	{
		if (enCours == n)		budIm = *i ;
		enCours++ ;
	}
	if(!budIm)			return ;
	bud = budIm->getBuddy() ;

	if (!this->estBuddyVisible (n, budIm))		return ;

	estOnline = bud->estConnecte() ;

	/****************************************************************
	* Mise a jour de la position du buddy en fonction de la barre	*
	* de scrolling													*
	****************************************************************/
	n = n - this->scroll->getPosition() ;


	/****************************************************************
	* Affichage de l'image											*
	****************************************************************/
	CPoint tailleLeft = budIm->getSize (dc) ;	
	CPoint tailleOn = this->images[BUDDY_ONLINE]->getSize (dc) ;
	CPoint tailleOff = this->images[BUDDY_OFFLINE]->getSize (dc) ;
	int pas = ECART_BUDDY + tailleLeft.y ;
	UINT coory = BUDDY_Y + pas * n ;
	budIm->afficher (dc, BUDDY_X, coory, tailleFen.cx - BUDDYR_X,  tailleLeft.y) ; 
	


	/****************************************************************
	* Affichage de la premiere ligne d'info							*
	****************************************************************/
//	Ip * ip = bud->getIp() ;
	CString nom ;
	if (estOnline)
	{
//		Joueur * j = bud->getJoueur() ;
//		ASSERT(j) ;
		nom.Format ("%s"/* : %d XP / Ping : %dms"*/, bud->getNom()/*, j->getXp(), j->getPing()*/) ;
	}
	else
	{
		nom = bud->getNom() ;
	}
	//this->police->afficherTexte (dc, nom, BUDDY_X + 5, coory + 5, 0, BUDDY_X + 5 + budIm->getSize(dc).x) ;
	CRect rect (BUDDY_X + 5, coory + 2, 0, 0) ;
	rect.bottom = rect.top + HAUTEUR_TEXTE ;
	rect.right = rect.left + BUDDY_X + 5 + budIm->getSize(dc).x ;
	budIm->afficherLigne1 (dc, rect, nom) ;


	/****************************************************************
	* Affichage de la deuxieme ligne d'info							*
	****************************************************************/
	//this->images[estOnline ? BUDDY_ONLINE : BUDDY_OFFLINE]->afficher (dc, BUDDY_X + 5, coory + tailleLeft.y / 2 + 3) ;
	CString texte ;
//	int posTexte ;
	if (estOnline)
	{
		texte.Format ("Online") ;
	//	posTexte = tailleOn.x + BUDDY_X + 10 ;
	}
	else
	{
		texte = "Offline" ;
	//	posTexte = tailleOff.x + BUDDY_X + 10 ;
	}
	//this->police->afficherTexte (dc, texte, posTexte, coory + tailleLeft.y / 2 + 3, 0, BUDDY_X + 5 + budIm->getSize(dc).x) ;
	rect = CRect (BUDDY_X + 5, coory + tailleLeft.y / 2, 0, 0) ;
	rect.bottom = rect.top + HAUTEUR_TEXTE ;
	rect.right = rect.left + BUDDY_X + 5 + budIm->getSize(dc).x ;

	budIm->afficherLigne2 (dc, rect, this->images[estOnline ? BUDDY_ONLINE : BUDDY_OFFLINE], texte) ;

}

/****************************************************************
* Cre une nouvelle liste de BuddyImage	contenant tous les		*
* joueurs de la liste des buddies								*
****************************************************************/
void Skin::chargerBuddies ()
{
	if (nomSkin != "" && ::IsWindow(parent->m_hWnd))
	{
		BuddyImage * bud ;
		ListeBuddies * liste = parent->getListeBud() ;
		int nbBuddies = liste->getSize() ;
		EFFACER_LISTE(BuddyImage, this->listeBudImages) ;
		CString path = GET_SKIN_DIR + nomSkin + "\\";
		
		/****************************************************************
		* Cration des BuddyImages associs aux buddies de la liste		*
		****************************************************************/
		for (int i = 0 ; i < nbBuddies ; i++)
		{
			bud = new BuddyImage(
				path + this->getChaine (BUDDY, true),
				liste->getBuddie (i)) ;
			this->listeBudImages.push_back (bud) ;

			/****************************************************************
			* Ajout des observers associs aux autres images				*
			****************************************************************/
			ASSERT (this->images[0]) ;
			vector<Observer*> * liste = this->getListeObserver () ;
			FOR_VECTOR_IND(Observer*,(*liste),j)
			{
				bud->ajouterObserver ((*j)) ;
			}
			
		}
		
		
	}
}

// appelle la fonction lorsque l'objet a ete modifie
/*virtual*/ void Skin::OnChange (Objet * obj, UINT msg, void * param1,void * param2)
{
	if (obj->getNomClasse() == ListeBuddies::NOM_CLASSE)
	{
		if (/*msg == Objet::ON_CHANGE ||*/
			msg == ListeBuddies::ON_ADD_BUD ||
			msg == ListeBuddies::ON_DEL_BUD)
		{
			this->chargerBuddies () ;
			MAIN_DLG->Invalidate(FALSE) ;
		}
	}
}

/****************************************************************
* Indique si le buddy numero n est visible sur le skin			*
****************************************************************/
bool Skin::estBuddyVisible (int n, BuddyImage * buddy) 
{
	bool retour = true ;
	if (!this->scroll) {
		return (false) ;
	}
	
	if (n < this->scroll->getPosition()) {
		retour = false ;
	}

	// nombre max de buddies affichables
	UINT nbMaxAffiche = this->listeBudImages.size() - this->scroll->getMaxPosition() ;

	if (n > nbMaxAffiche + this->scroll->getPosition()) {
		retour = false ;
	}


	buddy->setVisible (retour) ;

	return (retour) ;
}

/****************************************************************
* Met a jour les donnes du Scrolling en fonction de la taille	*
* de la fenetre													*
****************************************************************/
void Skin::MAJScrolling ()
{
	if (!this->scroll)			return ;

	CRect rectUtilisable = CRect (BUDDY_X, BUDDY_Y, taille.cx - BUDDYR_X, taille.cy - FIN_BUDDY_Y) ;

	UINT nbBudAffiche = rectUtilisable.Height() / (HAUTEUR_BUDDY + ECART_BUDDY)  - 1 ;
	this->scroll->setMaxPosition (this->listeBudImages.size() - nbBudAffiche) ;

}

//********************************************************************
// diverses actions effectues sur le skin
//********************************************************************
void Skin::OnLButtonDown (CPoint pSouris){
	for (int i = 0 ; i < NB_IMAGES ; i++)
	{
		this->images[i]->OnLButtonDown (pSouris) ;
	}

	FOR_VECTOR_IND(BuddyImage*, this->listeBudImages, j)
	{
		(*j)->OnLButtonDown (pSouris) ;
	}
}

void Skin::OnLButtonUp (CPoint pSouris){
	for (int i = 0 ; i < NB_IMAGES ; i++)
	{
		this->images[i]->OnLButtonUp (pSouris) ;
	}

	FOR_VECTOR_IND(BuddyImage*, this->listeBudImages, j)
	{
		(*j)->OnLButtonUp (pSouris) ;
	}
}

void Skin::OnRButtonUp (CPoint pSouris) {
	for (int i = 0 ; i < NB_IMAGES ; i++)
	{
		this->images[i]->OnRButtonUp (pSouris) ;
	}

	FOR_VECTOR_IND(BuddyImage*, this->listeBudImages, j)
	{
		(*j)->OnRButtonUp (pSouris) ;
	}
}

void Skin::OnMouseMove (CPoint pSouris){
	for (int i = 0 ; i < NB_IMAGES ; i++)
	{
		this->images[i]->OnMouseMove (pSouris) ;
	}

	FOR_VECTOR_IND(BuddyImage*, this->listeBudImages, j)
	{
		(*j)->OnMouseMove (pSouris) ;
	}
}

void Skin::OnLButtonDblClk (CPoint pSouris){
	for (int i = 0 ; i < NB_IMAGES ; i++)
	{
		this->images[i]->OnLButtonDblClk (pSouris) ;
	}

	FOR_VECTOR_IND(BuddyImage*, this->listeBudImages, j)
	{
		(*j)->OnLButtonDblClk (pSouris) ;
	}
}

void Skin::ajouterObserver (Observer * e){
	Objet::ajouterObserver (e) ;
	for (int i = 0 ; i < NB_IMAGES ; i++)
	{
		this->images[i]->ajouterObserver (e) ;
	}

	FOR_VECTOR_IND(BuddyImage*, this->listeBudImages, j)
	{
		(*j)->ajouterObserver (e) ;
	}
}

