//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#if !defined(AFX_SERVERLISTDLG_H__7A7572F0_129C_48FE_9DA9_39A30DC30971__INCLUDED_)
#define AFX_SERVERLISTDLG_H__7A7572F0_129C_48FE_9DA9_39A30DC30971__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// ServerListDlg.h : header file
//

#include "ResizableLib/ResizableDialog.h"
#include "ClientMaster.h"
#include "ServerListCtrl.h"
#include "FlatToolTipCtrl.h"
#include "InfosServeurDlg.h"
#include "Observer.h"
#include "FilterListBox.h"




/////////////////////////////////////////////////////////////////////////////
// ServerListDlg dialog

class ServerListDlg : public CResizableDialog, public Objet, public Observer
{
	ClientMaster * maitre ;
	Server * selectionne ;
//	InfosServeurDlg infosDlg ;

	CToolTipCtrlEx toolTip ;

	CMenu context ;

	void modifierFiltre (UINT filtre, int etatBouton) ;

	/********************************************************
	* Initialise l'etat des filtres avec les preferences	*
	********************************************************/
	void initFiltres () ;

	/********************************************************
	* Initialise la liste de serveurs						*
	********************************************************/
	void initServeurs () ;

	/********************************************************
	* Initialise les statistiques							*
	********************************************************/
	void initStats () ;

	/********************************************************
	* Met a jour le CButton correspondant a idc_filtre		*
	********************************************************/
	void updateFiltre (UINT idc_filtre) ;

	/********************************************************
	* Met a jour la liste des serveurs en fonction des		*
	* filtres												*
	********************************************************/
	void updateServeurs () ;

	/********************************************************
	* Met a jour le serveur selectionn	dans la liste		*
	********************************************************/
	int updateSelection () ;

	void afficherInfos () ;
	

public:
	ServerListDlg(CWnd* pParent = NULL);   // standard constructor
	virtual ~ServerListDlg() ;


	/********************************************************
	* Indique si ce serveur doit etre affich en fonction	*
	* des filtres											*
	********************************************************/
	bool matchFiltres (Server * serveur) ;

	// appelle la fonction lorsque l'objet a ete modifie
	virtual void OnChange (Objet * obj, UINT msg, void * param1,void * param2) ;

	void afficher (ClientMaster * maitre) ;

	CProgressCtrl * getProgress() {return &m_progress;}

// Dialog Data
	//{{AFX_DATA(ServerListDlg)
	enum { IDD = IDD_SERVER_LIST };
	CProgressCtrl	m_progress;
	FilterListBox	m_filters;
	CButton	m_balanced;
	CButton	m_antiLag;
	CButton	m_pb;
	CButton	m_restrict;
	CButton	m_maxLives;
	CButton	m_ff;
	CButton	m_needPass;
	CButton	m_emptyFull;
	ServerListCtrl	m_listeServers;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(ServerListDlg)
	public:
	virtual int DoModal(ClientMaster * maitre);
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(ServerListDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnEmptyFull();
	afx_msg void OnNeedPass();
	afx_msg void OnFf();
	afx_msg void OnMaxLives();
	afx_msg void OnRestrict();
	afx_msg void OnPb();
	afx_msg void OnAntiLag();
	afx_msg void OnBalanced();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnRclickServers(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnClickServers(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnItemActivate(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnSort(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnColumnclickServers(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnMove(int x, int y);
	afx_msg void OnRefresh();
	afx_msg void OnActionRefrehallservers();
	afx_msg void OnServerGetinformations();
	afx_msg void OnServerJointhisserver();
	afx_msg void OnServerRefreshthisserver();
	afx_msg void OnUseFilters();
	afx_msg void OnUpdateActionRefrehallservers(CCmdUI* pCmdUI);
	afx_msg void OnUpdateServerGetinformations(CCmdUI* pCmdUI);
	afx_msg void OnUpdateServerJointhisserver(CCmdUI* pCmdUI);
	afx_msg void OnUpdateServerRefreshthisserver(CCmdUI* pCmdUI);
	afx_msg void OnAddToFav();
	afx_msg void OnRemoveFromFav();
	afx_msg void OnUpdateAddToFav(CCmdUI* pCmdUI);
	afx_msg void OnAddFilter();
	afx_msg void OnRemoveFilter();
	afx_msg void OnClear();
	afx_msg void OnEditFilter();	
	afx_msg void OnSelchangeFilters();
	afx_msg void OnPassword();
	afx_msg void OnAdministrate();
	//}}AFX_MSG
	afx_msg void OnCheckchange();
	afx_msg void OnJoin();
	afx_msg void OnInfos();
	afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual void OnOK();
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SERVERLISTDLG_H__7A7572F0_129C_48FE_9DA9_39A30DC30971__INCLUDED_)
