//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// ServerListDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ETBuddies.h"
#include "ServerListDlg.h"
#include "Preferences.h"
#include "ETBuddiesDlg.h"
#include "InfosServeurDlg.h"
#include "FindServersDlg.h"
#include "SetPasswordDlg.h"
#include "RconPasswordDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define DISABLE_F		0
#define SHOW_F			1
#define HIDE_F			2

#define NB_FILTRES		8

#define	TEXTE_SHOW		"Only show"
#define TEXTE_HIDE		"Don't show"
#define TEXTE_DISABLE	"Filter disabled"


#define SZ_AL			"Anti lag"
#define SZ_BALANCED		"Balanced teams"
#define SZ_FF			"Friendly fire"
#define SZ_RESTRICT		"Restricted weapons"
#define SZ_MAX_LIVES	"Max number of lives"
#define	SZ_NEED_PASS	"Pass protection"
#define SZ_PB			"PunkBuster"
#define SZ_EMPTY_FULL	"Empty and full servers"


enum {WM_JOIN = WM_USER + 1,
WM_INFOS,
WM_REFRESH,
WM_ADD_FAV,
WM_REMOVE_FAV,
WM_PASSWORD,
WM_ADMINISTRATE};

#define GDI(idc)			GetDlgItem(idc)


#define SZ_TOTAL_SERV		"%3d servers"
#define SZ_NOT_EMPTY		"%3d"
#define NB_LOST				"%3d [%d%%]"

/* {filtre, ID filtre} */
static UINT match_filtres[NB_FILTRES][2] = {{Preferences::ANTI_LAG,		IDC_ANTI_LAG},
											{Preferences::BALANCED,		IDC_BALANCED},
											{Preferences::EMPTY_FULL,	IDC_EMPTY_FULL},
											{Preferences::FF,			IDC_FF},
											{Preferences::MAX_LIVES,	IDC_MAX_LIVES},
											{Preferences::NEED_PASS,	IDC_NEED_PASS},
											{Preferences::PB,			IDC_PB},
											{Preferences::RESTRICT,		IDC_RESTRICT}} ;
//	{FIN,						FIN}} ;

/////////////////////////////////////////////////////////////////////////////
// ServerListDlg dialog


ServerListDlg::ServerListDlg(CWnd* pParent /*=NULL*/)
: CResizableDialog(ServerListDlg::IDD, pParent),Objet("ServerListDlg")
{
	this->maitre = NULL ;
	this->selectionne = NULL ;
	this->toolTip.Create (this) ;
	this->Create (IDD, pParent) ;
	//{{AFX_DATA_INIT(ServerListDlg)
	//}}AFX_DATA_INIT
}

ServerListDlg::~ServerListDlg()
{
	if (this->maitre) {
		//this->maitre->enleverObserver (&this->infosDlg) ;
		this->maitre->enleverObserver (&this->m_listeServers) ;
		this->maitre->enleverObserver (this) ;
	}
}


void ServerListDlg::DoDataExchange(CDataExchange* pDX)
{
	CResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(ServerListDlg)
	DDX_Control(pDX, IDC_PROGRESS, m_progress);
	DDX_Control(pDX, IDC_FILTERS, m_filters);
	DDX_Control(pDX, IDC_BALANCED, m_balanced);
	DDX_Control(pDX, IDC_ANTI_LAG, m_antiLag);
	DDX_Control(pDX, IDC_PB, m_pb);
	DDX_Control(pDX, IDC_RESTRICT, m_restrict);
	DDX_Control(pDX, IDC_MAX_LIVES, m_maxLives);
	DDX_Control(pDX, IDC_FF, m_ff);
	DDX_Control(pDX, IDC_NEED_PASS, m_needPass);
	DDX_Control(pDX, IDC_EMPTY_FULL, m_emptyFull);
	DDX_Control(pDX, IDC_SERVERS, m_listeServers);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(ServerListDlg, CResizableDialog)
//{{AFX_MSG_MAP(ServerListDlg)
ON_BN_CLICKED(IDC_EMPTY_FULL, OnEmptyFull)
ON_BN_CLICKED(IDC_NEED_PASS, OnNeedPass)
ON_BN_CLICKED(IDC_FF, OnFf)
ON_BN_CLICKED(IDC_MAX_LIVES, OnMaxLives)
ON_BN_CLICKED(IDC_RESTRICT, OnRestrict)
ON_BN_CLICKED(IDC_PB, OnPb)
ON_BN_CLICKED(IDC_ANTI_LAG, OnAntiLag)
ON_BN_CLICKED(IDC_BALANCED, OnBalanced)
ON_WM_SIZE()
	ON_NOTIFY(NM_RCLICK, IDC_SERVERS, OnRclickServers)
	ON_NOTIFY(NM_CLICK, IDC_SERVERS, OnClickServers)
	ON_NOTIFY(LVN_ITEMACTIVATE, IDC_SERVERS, OnItemActivate)
	ON_NOTIFY(LVM_SORTITEMS, IDC_SERVERS, OnSort)
	ON_NOTIFY(LVN_COLUMNCLICK, IDC_SERVERS, OnColumnclickServers)
	ON_WM_MOVE()
	ON_COMMAND(ID_ACTION_REFREHALLSERVERS, OnActionRefrehallservers)
	ON_COMMAND(ID_SERVER_GETINFORMATIONS, OnServerGetinformations)
	ON_COMMAND(ID_SERVER_JOINTHISSERVER, OnServerJointhisserver)
	ON_COMMAND(ID_SERVER_REFRESHTHISSERVER, OnServerRefreshthisserver)
	ON_COMMAND(ID_FILTER_USEFILTERS, OnUseFilters)
	ON_UPDATE_COMMAND_UI(ID_ACTION_REFREHALLSERVERS, OnUpdateActionRefrehallservers)
	ON_UPDATE_COMMAND_UI(ID_SERVER_GETINFORMATIONS, OnUpdateServerGetinformations)
	ON_UPDATE_COMMAND_UI(ID_SERVER_JOINTHISSERVER, OnUpdateServerJointhisserver)
	ON_UPDATE_COMMAND_UI(ID_SERVER_REFRESHTHISSERVER, OnUpdateServerRefreshthisserver)
	ON_COMMAND(ID_ADD_TO_FAV, OnAddToFav)
	ON_UPDATE_COMMAND_UI(ID_ADD_TO_FAV, OnUpdateAddToFav)
	ON_BN_CLICKED(IDC_ADD_FILTER, OnAddFilter)
	ON_BN_CLICKED(IDC_REMOVE_FILTER, OnRemoveFilter)
	ON_BN_CLICKED(IDC_CLEAR, OnClear)
	ON_BN_CLICKED(IDC_EDIT_FILTER, OnEditFilter)
	ON_WM_KEYUP()
	ON_LBN_SELCHANGE(IDC_FILTERS, OnSelchangeFilters)
	//}}AFX_MSG_MAP
	//ON_BN_CLICKED(IDC_EDIT_FILTER, OnEditFilter)
	ON_CLBN_CHKCHANGE(IDC_FILTERS, OnCheckchange)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// ServerListDlg message handlers

int ServerListDlg::DoModal(ClientMaster * maitre) 
{
	// TODO: Add your specialized code here and/or call the base class
	this->maitre = maitre ;
	if (this->maitre) {
	//	this->maitre->ajouterObserver (&this->infosDlg) ;
		this->maitre->ajouterObserver (&this->m_listeServers) ;
		this->maitre->ajouterObserver (this) ;
	}
	return CResizableDialog::DoModal();
}

BOOL ServerListDlg::OnInitDialog() 
{
	CResizableDialog::OnInitDialog();
	
	// TODO: Add extra initialization here

	this->m_listeServers.initControl(this) ;
	
	this->afficherInfos() ;
	
	AddAnchor (IDC_GROUPE_FILTRES,	TOP_LEFT, TOP_RIGHT) ;
	AddAnchor (IDC_GROUPE_STATS,	TOP_LEFT, TOP_RIGHT) ;
	AddAnchor (IDC_GROUPE_USER,		TOP_RIGHT, TOP_RIGHT) ;
	AddAnchor (IDC_SERVERS,			TOP_LEFT, BOTTOM_RIGHT) ;
	AddAnchor (IDC_FILTERS,			TOP_RIGHT, TOP_RIGHT) ;
	AddAnchor (IDC_ADD_FILTER,		TOP_RIGHT, TOP_RIGHT) ;
	AddAnchor (IDC_REMOVE_FILTER,	TOP_RIGHT, TOP_RIGHT) ;
	//AddAnchor (IDC_EDIT_FILTER,		TOP_RIGHT, TOP_RIGHT) ;
	AddAnchor (IDC_CLEAR,			TOP_RIGHT, TOP_RIGHT) ;
	AddAnchor (IDC_EDIT_FILTER,			TOP_RIGHT, TOP_RIGHT) ;
	AddAnchor (IDC_PROGRESS,		BOTTOM_LEFT, BOTTOM_RIGHT) ;
/*	AddAnchor (IDC_JOIN,			BOTTOM_LEFT) ;
	AddAnchor (IDC_INFOS,			BOTTOM_LEFT) ;
	AddAnchor (IDC_REFRESH,			BOTTOM_LEFT) ;*/

	/* Filtres de droite */
/*	AddAnchor (IDC_RESTRICT,		TOP_RIGHT, TOP_RIGHT) ;
	AddAnchor (IDC_RESTRICT_BMP,	TOP_RIGHT, TOP_RIGHT) ;
	AddAnchor (IDC_PB,				TOP_RIGHT, TOP_RIGHT) ;
	AddAnchor (IDC_PB_BMP,			TOP_RIGHT, TOP_RIGHT) ;
	AddAnchor (IDC_ANTI_LAG,		TOP_RIGHT, TOP_RIGHT) ;
	AddAnchor (IDC_ANTI_LAG_BMP,	TOP_RIGHT, TOP_RIGHT) ;
	AddAnchor (IDC_BALANCED,		TOP_RIGHT, TOP_RIGHT) ;
	AddAnchor (IDC_BALANCED_BMP,	TOP_RIGHT, TOP_RIGHT) ;*/

	context.CreatePopupMenu() ;
	context.InsertMenu (0, MF_BYPOSITION|MF_STRING, WM_JOIN,		 "Join this server") ;
	context.InsertMenu (1, MF_BYPOSITION|MF_STRING, WM_INFOS,		 "Informations") ;
	context.InsertMenu (2, MF_BYPOSITION|MF_STRING, WM_REFRESH,		 "Refresh this server") ;
	context.InsertMenu (3, MF_BYPOSITION|MF_STRING, WM_ADD_FAV,		 "Add to favorites") ;
	context.InsertMenu (4, MF_BYPOSITION|MF_STRING, WM_REMOVE_FAV,	 "Remove from favorites") ;
	context.InsertMenu (5, MF_BYPOSITION|MF_STRING, WM_PASSWORD,	 "Set or edit password") ;
	context.InsertMenu (6, MF_BYPOSITION|MF_STRING, WM_ADMINISTRATE, "Administrate") ;
	context.SetDefaultItem (WM_JOIN) ;


	/* add tooltips for filters */
	this->toolTip.AddTool (GDI(IDC_BALANCED),		SZ_BALANCED) ;
	this->toolTip.AddTool (GDI(IDC_BALANCED_BMP),	SZ_BALANCED) ;

	this->toolTip.AddTool (GDI(IDC_ANTI_LAG),		SZ_AL) ;
	this->toolTip.AddTool (GDI(IDC_ANTI_LAG_BMP),	SZ_AL) ;

	this->toolTip.AddTool (GDI(IDC_FF),				SZ_FF) ;
	this->toolTip.AddTool (GDI(IDC_FF_BMP),			SZ_FF) ;

	this->toolTip.AddTool (GDI(IDC_RESTRICT),		SZ_RESTRICT) ;
	this->toolTip.AddTool (GDI(IDC_RESTRICT_BMP),	SZ_RESTRICT) ;

	this->toolTip.AddTool (GDI(IDC_MAX_LIVES),		SZ_MAX_LIVES) ;
	this->toolTip.AddTool (GDI(IDC_MAX_LIVES_BMP),	SZ_MAX_LIVES) ;

	this->toolTip.AddTool (GDI(IDC_NEED_PASS),		SZ_NEED_PASS) ;
	this->toolTip.AddTool (GDI(IDC_NEED_PASS_BMP),	SZ_NEED_PASS) ;

	this->toolTip.AddTool (GDI(IDC_PB),				SZ_PB) ;
	this->toolTip.AddTool (GDI(IDC_PB_BMP),			SZ_PB) ;

	this->toolTip.AddTool (GDI(IDC_EMPTY_FULL),		SZ_EMPTY_FULL) ;
	this->toolTip.AddTool (GDI(IDC_EMPTY_FULL_BMP),	SZ_EMPTY_FULL) ;

	
	m_filters.update() ;
	m_progress.SetRange (0, 100) ;

	GetDlgItem(IDC_EDIT_FILTER)->EnableWindow(FALSE) ;


	EnableSaveRestore (_T("ServerList")) ;

	
	
	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

/********************************************************
* Initialise les statistiques							*
********************************************************/
void ServerListDlg::initStats ()
{
	
	UINT nbNonVides = 0 ;
	UINT total = 0 ;
	UINT lost = 0 ;
	
	if (this->maitre)
	{
		map<CString,Server*> * liste = this->maitre->getListeServeurs() ;
		
		FOR_MAP(CString, Server*, (*liste))
		{
			if (!i->second->estVide()) {
				nbNonVides++;
			}

			if (i->second->getNom() == NO_VARIABLE)
			{
				lost++ ;
			}
		}
		
		total = liste->size() ;
	}
	


	CString totalsz ;
	totalsz.Format (SZ_TOTAL_SERV,		total) ;
	SetDlgItemText (IDC_TOTAL_SERVERS,	totalsz) ;
	
	CString nonVide ;
	nonVide.Format (SZ_NOT_EMPTY,		nbNonVides) ;
	SetDlgItemText(IDC_NOT_EMPTY,		nonVide) ;

	CString nbLost ;
	nbLost.Format (NB_LOST,				lost, (total != 0) ? lost * 100 / total : 0) ;
	SetDlgItemText(IDC_LOST,			nbLost) ;

}

/********************************************************
* Initialise la liste de serveurs						*
********************************************************/
void ServerListDlg::initServeurs ()
{
		
	this->updateServeurs () ;
	/* tri selon le ping */
	this->m_listeServers.majTri() ;
	
}

/********************************************************
* Met a jour la liste des serveurs en fonction des		*
* filtres												*
********************************************************/
void ServerListDlg::updateServeurs ()
{
	this->m_listeServers.DeleteAllItems() ;
	if (this->maitre)
	{
		map<CString,Server*> * liste = this->maitre->getListeServeurs() ;
		
		UINT lastPos = 0 ;
		FOR_MAP(CString, Server*,(*liste))
		{
			if (this->matchFiltres (i->second))
			{
				this->m_listeServers.insertItem (lastPos, i->second) ;
				lastPos++;
			}
		}
	}
	this->initStats () ;
	this->m_listeServers.majTri() ;
}

/********************************************************
* Indique si ce serveur doit etre affich en fonction	*
* des filtres											*
********************************************************/
bool ServerListDlg::matchFiltres (Server * serveur)
{
	bool retour = true ;
	
	UINT etat ;
	CString var ;

	/****************************************
	* Si le serveur est invalide, on ne 	*
	* l'affiche pas							*
	****************************************/
/*	if (!serveur->estValide ()) {
		return (false) ;
	}*/

	
	/****************************************
	* Filtre Empty/Full						*
	****************************************/
	if ((etat = MAIN_PREF->getEtatFiltre(Preferences::EMPTY_FULL)) != Preferences::DISABLE)	
	{
		/* only show */
		retour = serveur->estVide() || serveur->estPlein() ;
		if (etat == Preferences::HIDE) {
			/* don't show */
			retour = !retour ;
		}
	}
	
	/****************************************
	* Filtre Anti-Lag						*
	****************************************/
	if (retour && (etat = MAIN_PREF->getEtatFiltre(Preferences::ANTI_LAG)) != Preferences::DISABLE)	
	{
		var = serveur->getVariable (VAR_ANTI_LAG) ;
		
		if (var == NO_VARIABLE) {
			retour = false ;
		}
		else {
			/* only show */
			retour = atoi (STR_BUFFER(var)) > 0 ;
			if (etat == Preferences::HIDE) {
				/* don't show */
				retour = !retour ;
			}
		}
	}
	
	/****************************************
	* Filtre balanced teams					*
	****************************************/
	if (retour && (etat = MAIN_PREF->getEtatFiltre(Preferences::BALANCED)) != Preferences::DISABLE)	
	{
		var = serveur->getVariable (VAR_BALANCED) ;
		
		if (var == NO_VARIABLE) {
			retour = false ;
		}
		else {
			/* only show */
			retour = atoi (STR_BUFFER(var)) > 0 ;
			if (etat == Preferences::HIDE) {
				/* don't show */
				retour = !retour ;
			}
		}
	}
	
	/****************************************
	* Filtre FF								*
	****************************************/
	if (retour && (etat = MAIN_PREF->getEtatFiltre(Preferences::FF)) != Preferences::DISABLE)	
	{
		var = serveur->getVariable (VAR_FF) ;
		
		if (var == NO_VARIABLE) {
			retour = false ;
		}
		else {
			/* only show */
			retour = atoi (STR_BUFFER(var)) > 0 ;
			if (etat == Preferences::HIDE) {
				/* don't show */
				retour = !retour ;
			}
		}
	}
	
	/****************************************
	* Filtre balanced teams					*
	****************************************/
	if (retour && (etat = MAIN_PREF->getEtatFiltre(Preferences::BALANCED)) != Preferences::DISABLE)	
	{
		var = serveur->getVariable (VAR_BALANCED) ;
		
		if (var == NO_VARIABLE) {
			retour = false ;
		}
		else {
			/* only show */
			retour = atoi (STR_BUFFER(var)) > 0 ;
			if (etat == Preferences::HIDE) {
				/* don't show */
				retour = !retour ;
			}
		}
	}
	
	/****************************************
	* Filtre weapon restrict				*
	****************************************/
	if (retour && (etat = MAIN_PREF->getEtatFiltre(Preferences::RESTRICT)) != Preferences::DISABLE)	
	{
		var = serveur->getVariable (VAR_RESTRICT) ;
		
		if (var == NO_VARIABLE) {
			retour = false ;
		}
		else {
			/* only show */
			retour = atoi (STR_BUFFER(var)) > 0 ;
			if (etat == Preferences::HIDE) {
				/* don't show */
				retour = !retour ;
			}
		}
	}
	
	/****************************************
	* Filtre max lives						*
	****************************************/
	if (retour && (etat = MAIN_PREF->getEtatFiltre(Preferences::MAX_LIVES)) != Preferences::DISABLE)	
	{
		var = serveur->getVariable (VAR_MAX_LIVES) ;
		
		if (var == NO_VARIABLE) {
			retour = false ;
		}
		else {
			/* only show */
			retour = atoi (STR_BUFFER(var)) > 0 ;
			if (etat == Preferences::HIDE) {
				/* don't show */
				retour = !retour ;
			}
		}
	}
	
	/****************************************
	* Filtre need Pass					*
	****************************************/
	if (retour && (etat = MAIN_PREF->getEtatFiltre(Preferences::NEED_PASS)) != Preferences::DISABLE)	
	{
		var = serveur->getVariable (VAR_NEED_PASS) ;
		
		if (var == NO_VARIABLE) {
			retour = false ;
		}
		else {
			/* only show */
			retour = atoi (STR_BUFFER(var)) > 0 ;
			if (etat == Preferences::HIDE) {
				/* don't show */
				retour = !retour ;
			}
		}
	}
	
	/****************************************
	* Filtre PunkBuster						*
	****************************************/
	if (retour && (etat = MAIN_PREF->getEtatFiltre(Preferences::PB)) != Preferences::DISABLE)	
	{
		var = serveur->getVariable (VAR_PB) ;
		
		if (var == NO_VARIABLE) {
			retour = false ;
		}
		else {
			/* only show */
			retour = atoi (STR_BUFFER(var)) > 0 ;
			if (etat == Preferences::HIDE) {
				/* don't show */
				retour = !retour ;
			}
		}
	}

	/****************************************
	* User-defined filters					*
	****************************************/
	ListeFiltres * filtres = m_filters.getFilters()->getAll() ;
	ListeFiltres::iterator i ;
	for (i = filtres->begin() ; i != filtres->end() ; i++) {
		if (retour)		retour = i->matchFiltre(serveur) ;
	}

	return (retour) ;
	
}

/************************************************
* Modification des filtres						*
************************************************/
void ServerListDlg::OnEmptyFull() {	
	this->modifierFiltre (Preferences::EMPTY_FULL,	m_emptyFull.GetCheck()) ;
	this->updateFiltre (IDC_EMPTY_FULL) ;
}
void ServerListDlg::OnNeedPass() {	
	this->modifierFiltre (Preferences::NEED_PASS,	m_needPass.GetCheck()) ;
	this->updateFiltre (IDC_NEED_PASS) ;
}
void ServerListDlg::OnFf() {
	this->modifierFiltre (Preferences::FF,			m_ff.GetCheck()) ;
	this->updateFiltre (IDC_FF) ;
}
void ServerListDlg::OnMaxLives() {
	this->modifierFiltre (Preferences::MAX_LIVES,	m_maxLives.GetCheck()) ;
	this->updateFiltre (IDC_MAX_LIVES) ;
}
void ServerListDlg::OnRestrict() {
	this->modifierFiltre (Preferences::RESTRICT,	m_restrict.GetCheck()) ;
	this->updateFiltre (IDC_RESTRICT) ;
}
void ServerListDlg::OnPb() {
	this->modifierFiltre (Preferences::PB,			m_pb.GetCheck()) ;
	this->updateFiltre (IDC_PB) ;
}
void ServerListDlg::OnAntiLag() {
	this->modifierFiltre (Preferences::ANTI_LAG,	m_antiLag.GetCheck()) ;
	this->updateFiltre (IDC_ANTI_LAG) ;
}
void ServerListDlg::OnBalanced() {
	this->modifierFiltre (Preferences::BALANCED,	m_balanced.GetCheck()) ;
	this->updateFiltre (IDC_BALANCED) ;
}


void ServerListDlg::modifierFiltre (UINT filtre, int etatBouton)
{
	ASSERT (etatBouton == SHOW_F || etatBouton == HIDE_F || etatBouton == DISABLE_F) ;
	switch (etatBouton)
	{
	case SHOW_F: 		MAIN_PREF->ajouterFiltre (filtre, Preferences::SHOW) ;		break ;
	case HIDE_F: 		MAIN_PREF->ajouterFiltre (filtre, Preferences::HIDE) ;		break ;
	case DISABLE_F:		MAIN_PREF->ajouterFiltre (filtre, Preferences::DISABLE) ;	break ;
	}
	this->updateServeurs () ;
}

/********************************************************
* Initialise l'etat des filtres avec les preferences	*
********************************************************/
void ServerListDlg::initFiltres ()
{
	int i = 0 ;
	while (i < NB_FILTRES)
	{
		this->updateFiltre (match_filtres[i][1]) ;
		i++;
	}
}

/********************************************************
* Met a jour le CButton correspondant a idc_filtre		*
********************************************************/
void ServerListDlg::updateFiltre (UINT idc_filtre)
{
	int i = 0 ;
	while (i < NB_FILTRES && match_filtres[i][1] != idc_filtre)	{
		i++;
	}
	
	if (i < NB_FILTRES)
	{
		
		UINT etat = MAIN_PREF->getEtatFiltre (match_filtres[i][0]) ;
		int etatBouton = DISABLE_F ;
		CString texte = "" ;
		
		/****************************************
		* Le filtre en cours est affich		*
		****************************************/
		if (etat == Preferences::SHOW) {
			etatBouton = SHOW_F ;
			texte = TEXTE_SHOW ;
		}
		/****************************************
		* Le filtre en cours est cach			*
		****************************************/
		else if (etat == Preferences::HIDE) {
			etatBouton = HIDE_F ;
			texte = TEXTE_HIDE ;
		}
		/****************************************
		* Le filtre en cours est dsactiv		*
		****************************************/
		else if (etat == Preferences::DISABLE) {
			etatBouton = DISABLE_F ;
			texte = TEXTE_DISABLE ;
		}
		else {
			ASSERT(NULL) ;
		}
		
		CButton * filtreEnCours = (CButton*)GetDlgItem(idc_filtre) ;
		ASSERT (filtreEnCours);
		
		if (filtreEnCours)	{
			filtreEnCours->SetCheck(etatBouton) ;
			filtreEnCours->SetWindowText (texte) ;
		}
	}
}

void ServerListDlg::OnSize(UINT nType, int cx, int cy) 
{
	CResizableDialog::OnSize(nType, cx, cy);
	
	// TODO: Add your message handler code here
	this->ArrangeLayout () ;
	this->m_listeServers.Invalidate() ;
}

/************************************************
* Demande d'affichage du menu					*
************************************************/
void ServerListDlg::OnRclickServers(NMHDR* pNMHDR, LRESULT* pResult) 
{
	int nbSelect = updateSelection() ;
	if (selectionne != NULL) {
		/************************************************
		* Un serveur a ete selectionne, on affiche		*
		* le menu										*
		************************************************/
		CPoint pt ;
		GetCursorPos(&pt) ;
		bool isFav = MAIN_DLG->getFavorites()->isFavorite(this->selectionne) ;
		UINT state = nbSelect < 2 && isFav ? MF_GRAYED : MF_ENABLED ;
		UINT state2 = nbSelect > 1 || isFav ? MF_ENABLED : MF_GRAYED ;

		this->context.EnableMenuItem (WM_ADD_FAV,		state|MF_BYCOMMAND);
		this->context.EnableMenuItem (WM_REMOVE_FAV,	state2|MF_BYCOMMAND);
		context.EnableMenuItem(WM_PASSWORD, nbSelect == 1 ? MF_ENABLED:MF_GRAYED) ;
		this->context.TrackPopupMenu(TPM_LEFTALIGN|TPM_LEFTBUTTON, pt.x, pt.y, this);  
		
	}
	*pResult = 0;
}

BOOL ServerListDlg::PreTranslateMessage(MSG* pMsg) 
{
	this->toolTip.RelayEvent (pMsg) ;
	return CResizableDialog::PreTranslateMessage(pMsg);
}

void ServerListDlg::OnClickServers(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	this->updateSelection() ;
	*pResult = 0;
}

/********************************************************
* Met a jour le serveur selectionn	dans la liste		*
********************************************************/
int ServerListDlg::updateSelection ()
{
	POSITION pos = this->m_listeServers.GetFirstSelectedItemPosition();
	this->selectionne = NULL ;
	int nbSelect = 0 ;

	
	if (pos != NULL) 
	{
		while (pos)
		{
			int nItem = this->m_listeServers.GetNextSelectedItem(pos);
			/*CString ip = this->m_listeServers.GetItemText (nItem, COL_IP) ;*/
			
			this->selectionne = (Server*)this->m_listeServers.GetItemData (nItem) ;/*maitre->getServer (STR_BUFFER(ip)) ;*/
			nbSelect++ ;
		}
	}

	UINT enable = this->selectionne ? MF_ENABLED : MF_GRAYED ;
	this->GetMenu()->EnableMenuItem (ID_ACTION_REFREHALLSERVERS,	MF_BYCOMMAND|(this->maitre ? MF_ENABLED : MF_GRAYED)) ;
	this->GetMenu()->EnableMenuItem (ID_SERVER_JOINTHISSERVER,		MF_BYCOMMAND|enable) ;
	this->GetMenu()->EnableMenuItem (ID_SERVER_GETINFORMATIONS,		MF_BYCOMMAND|enable) ;
	this->GetMenu()->EnableMenuItem (ID_SERVER_REFRESHTHISSERVER,	MF_BYCOMMAND|enable) ;
	this->GetMenu()->EnableMenuItem (ID_ADD_TO_FAV,					MF_BYCOMMAND|enable) ;
	

	/*GetDlgItem (IDC_JOIN)->EnableWindow (this->selectionne != NULL) ;
	GetDlgItem (IDC_INFOS)->EnableWindow (this->selectionne != NULL) ;
	GetDlgItem (IDC_REFRESH)->EnableWindow (this->selectionne != NULL) ;*/

	return (nbSelect) ;

}

void ServerListDlg::OnJoin() 
{
	updateSelection () ;
	this->notifierObs (BuddyJoueurImage::ON_CONNECT, this->selectionne) ;
}

void ServerListDlg::OnInfos() 
{
	updateSelection () ;
	MAIN_DLG->getInfosDlg()->afficher (this->selectionne) ;
}

void ServerListDlg::OnItemActivate(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	
	
	this->OnJoin() ;
	*pResult = 0;
}



void ServerListDlg::OnSort (NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	
	
	*pResult = 0;
}

LRESULT ServerListDlg::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	// TODO: Add your specialized code here and/or call the base class
	
	return CResizableDialog::WindowProc(message, wParam, lParam);
}

BOOL ServerListDlg::OnCommand(WPARAM wParam, LPARAM lParam) 
{
	// TODO: Add your specialized code here and/or call the base class
	UINT id = LOWORD(wParam) ;
	switch (id)
	{
	case WM_JOIN:
		this->OnJoin() ; 
		break ;
	case WM_INFOS:
		this->OnInfos() ;
		break;
	case WM_REFRESH:
		this->OnRefresh() ;
		break ;
	case WM_ADD_FAV:
		this->OnAddToFav() ;
		break;
	case WM_REMOVE_FAV:
		this->OnRemoveFromFav() ;
		break ;
	case WM_PASSWORD:
		OnPassword() ;
		break ;
	case WM_ADMINISTRATE:
		OnAdministrate() ;
		break ;
	}

	return CResizableDialog::OnCommand(wParam, lParam);
}

void ServerListDlg::OnColumnclickServers(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	// TODO: Add your control notification handler code here
	
	*pResult = 0;
}

void ServerListDlg::OnMove(int x, int y) 
{
	CResizableDialog::OnMove(x, y);
	this->m_listeServers.Invalidate() ;

	// TODO: Add your message handler code here
	
}

void ServerListDlg::OnRefresh() 
{
	// TODO: Add your control notification handler code here
	
	POSITION pos = this->m_listeServers.GetFirstSelectedItemPosition();
	
	if (pos != NULL) 
	{
		while (pos)
		{
			int nItem = this->m_listeServers.GetNextSelectedItem(pos);
			maitre->rafraichirServeur((Server*)this->m_listeServers.GetItemData (nItem)) ;
		}
	}
	
	//this->maitre->rafraichirServeur(this->selectionne) ;
	
}


void ServerListDlg::OnActionRefrehallservers() {
	if (this->maitre) {
		this->maitre->litInfos() ;
	}
	
}

void ServerListDlg::OnServerGetinformations() {
	this->OnInfos() ;
}

void ServerListDlg::OnServerJointhisserver() {
	this->OnJoin() ;
}

void ServerListDlg::OnServerRefreshthisserver() {
	this->OnRefresh() ;
}


/* enable or disable menus */
void ServerListDlg::OnUpdateActionRefrehallservers(CCmdUI* pCmdUI) {
	pCmdUI->Enable (this->maitre != NULL) ; 
}
void ServerListDlg::OnUpdateServerGetinformations(CCmdUI* pCmdUI) {
	pCmdUI->Enable (this->selectionne != NULL) ; 
}
void ServerListDlg::OnUpdateServerJointhisserver(CCmdUI* pCmdUI) {
	pCmdUI->Enable (this->selectionne != NULL) ; 
}
void ServerListDlg::OnUpdateServerRefreshthisserver(CCmdUI* pCmdUI) {
	pCmdUI->Enable (this->selectionne != NULL) ; 
}
void ServerListDlg::OnUpdateAddToFav(CCmdUI* pCmdUI) {	
	pCmdUI->Enable (this->selectionne != NULL) ; 
}


// appelle la fonction lorsque l'objet a ete modifie
/*virtual*/ void ServerListDlg::OnChange (Objet * obj, UINT msg, void * param1,void * param2)
{
	if (msg == ClientMaster::ON_REFRESH_COMPLETE) {
		this->initStats() ;
		this->updateServeurs() ;
		this->m_listeServers.majTri() ;
	}
}

void ServerListDlg::OnAddToFav() 
{

	POSITION pos = m_listeServers.GetFirstSelectedItemPosition();
	
	if (pos != NULL) 
	{
		while (pos)
		{
			int nItem = m_listeServers.GetNextSelectedItem(pos);
			Server * selection = (Server*)this->m_listeServers.GetItemData (nItem) ;
			MAIN_DLG->getFavorites()->addServer (selection) ;
			this->m_listeServers.redrawsItem (nItem) ;
		}
	}
}

void ServerListDlg::OnRemoveFromFav()
{
	POSITION pos = m_listeServers.GetFirstSelectedItemPosition();
	
	if (pos != NULL) 
	{
		while (pos)
		{
			int nItem = m_listeServers.GetNextSelectedItem(pos);
			Server * selection = (Server*)this->m_listeServers.GetItemData (nItem) ;
			MAIN_DLG->getFavorites()->removeServer (selection) ;
			this->m_listeServers.redrawsItem (nItem) ;
		}
	}

	
}

void ServerListDlg::afficherInfos()
{
	this->initFiltres () ;
	this->initServeurs () ;
	this->initStats () ;
	this->updateSelection() ;
}


void ServerListDlg::afficher (ClientMaster * maitre) 
{
	this->maitre = maitre ;
	if (this->maitre) {
//		this->maitre->ajouterObserver (&this->infosDlg) ;
		this->maitre->ajouterObserver (&this->m_listeServers) ;
		this->maitre->ajouterObserver (this) ;
	}

	this->ShowWindow (SW_SHOW) ;
	this->afficherInfos() ;
	this->SetFocus() ;
}

void ServerListDlg::OnUseFilters() {
	FindServersDlg dlg ;
	dlg.setMaster(maitre) ;
	if (dlg.DoModal(&m_filters) == IDOK) {
		updateServeurs() ;
	}
}

 



void ServerListDlg::OnCheckchange() {
	m_filters.OnCheckchange() ;
	updateServeurs() ;
}

void ServerListDlg::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default
	
	CResizableDialog::OnKeyUp(nChar, nRepCnt, nFlags);
}

void ServerListDlg::OnAddFilter() {
	OnUseFilters() ;
}

void ServerListDlg::OnRemoveFilter() {
	m_filters.removeSelection() ;
	updateServeurs() ;
}

void ServerListDlg::OnClear() {
	m_filters.clear() ;
	updateServeurs() ;
}

void ServerListDlg::OnEditFilter() {
	FindServersDlg dlg ;
	dlg.setMaster(maitre) ;
	Filter * ancien = m_filters.getSelection() ;
	dlg.initFiltre(*ancien) ;
	if (dlg.DoModal(&m_filters, true) == IDOK) {
		Filter f = dlg.getFilter() ;

		try {
			m_filters.getFilters()->modifyFilter(ancien->m_nom, f) ;
			
			m_filters.update() ;
			updateServeurs() ;
		}
		catch (Exception e) {
			MessageBox(e.getMessage(), "Can't edit the filter", MB_OK | MB_ICONERROR) ;
			f.m_relations.removeAll() ;
		}
	}
}

void ServerListDlg::OnOK() {
}

void ServerListDlg::OnSelchangeFilters() 
{
	GetDlgItem(IDC_EDIT_FILTER)->EnableWindow(m_filters.GetCurSel() != -1) ;
}


void ServerListDlg::OnPassword() {
	if (selectionne){
		SetPasswordDlg dlg ;
		dlg.DoModal(selectionne) ;
	}
}

void ServerListDlg::OnAdministrate() 
{
	if (selectionne) {
		RconPasswordDlg dlg ;
		dlg.DoModal(selectionne) ;
	}
}
