//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#if !defined(AFX_SERVERLISTCTRL_H__997F09DF_7F19_4CAC_98E7_04C3436E8C67__INCLUDED_)
#define AFX_SERVERLISTCTRL_H__997F09DF_7F19_4CAC_98E7_04C3436E8C67__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// ServerListCtrl.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// ServerListCtrl window

#include "ListCtrl.h"
#include "Server.h"
#include "Observer.h"


#define COL_COUNTRY		0
#define COL_NAME		1
#define COL_NB_PLAYERS	2
#define COL_MAX_PLAYERS	3
#define COL_MAP			4
#define COL_PING		5
#define COL_GAME_TYPE	6
#define COL_XP_SUM		7
#define COL_OCCUP		8
#define COL_FAV			9
#define COL_IP			10

class ServerListDlg ;

class ServerListCtrl : public ListCtrl, public Observer
{
	ServerListDlg * parent ;
	
// Construction
public:
	ServerListCtrl();

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(ServerListCtrl)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~ServerListCtrl();
	static int CALLBACK SortProc(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort) ;

	void setItemData (UINT nItem, Server * server) ;
	void insertItem (int nItem, Server * server) ;
	void setItem (int nItem, Server * server) ;
	Server * getItemData (UINT nItem) ;

	/********************************************************
	* Tri la liste selon la colonne triColonne				*
	********************************************************/
	virtual void trier (int triColonne = COL_PING) ;

	/************************************************************
	* Met a jour le tri											*
	************************************************************/
	virtual void majTri () ;

	virtual void initControl (ServerListDlg * parent, DWORD style = LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES) ;

	// appelle la fonction lorsque l'objet a ete modifie
	virtual void OnChange (Objet * obj, UINT msg, void * param1,void * param2) ;

	virtual void DrawItem(LPDRAWITEMSTRUCT) ;

	// Generated message map functions
protected:
	//{{AFX_MSG(ServerListCtrl)
	afx_msg void OnColumnclick(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SERVERLISTCTRL_H__997F09DF_7F19_4CAC_98E7_04C3436E8C67__INCLUDED_)
