//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// ServerListCtrl.cpp : implementation file
//

#include "stdafx.h"
#include "ETBuddies.h"
#include "ETBuddiesDlg.h"
#include "ServerListCtrl.h"
#include "ServerListDlg.h"
#include "ETBuddiesDlg.h"
#include "ServerListDlg.h"
#include "Degrade.h"

#define LARGEUR_COUNTRY		30
#define LARGEUR_IP			150
#define LARGEUR_NAME		200
#define LARGEUR_NB_PLAY		50
#define LARGEUR_MAX_PLAY	55
#define LARGEUR_MAP			70
#define LARGEUR_PING		40
#define LARGEUR_GAME_TYPE	55
#define LARGEUR_XP			40
#define LARGEUR_FAV			25
#define LARGEUR_OCCUP		110

#define GAME_TYPE			"gamename"

#define DEFAULT_TRI_SERVER	COL_PING
#define DEFAULT_SORT_ASC	true


#define BACK_COLOR			RGB(198,198,198)


#define GRADIANT1			MAIN_PREF->getGradiant1()
#define GRADIANT2			MAIN_PREF->getGradiant2()
#define AFFICHE_POURCENT	true


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// ServerListCtrl

ServerListCtrl::ServerListCtrl()
{
	m_backColor = BACK_COLOR ;
	this->parent = NULL ;
	this->m_CurrentSortItem = DEFAULT_TRI_SERVER ;
	this->m_SortAscending	= DEFAULT_SORT_ASC ;
}

ServerListCtrl::~ServerListCtrl()
{
}


BEGIN_MESSAGE_MAP(ServerListCtrl, ListCtrl)
	//{{AFX_MSG_MAP(ServerListCtrl)
		ON_NOTIFY_REFLECT(LVN_COLUMNCLICK, OnColumnclick)
	ON_WM_DRAWITEM()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// ServerListCtrl message handlers
int ServerListCtrl::SortProc(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort)
{
	Server * serv1 = (Server*)lParam1 ;
	Server * serv2 = (Server*)lParam2 ;

	UINT paramSort = (UINT)lParamSort ;
	int sortMod = 1 ;
	int comp = 0 ;
	if (paramSort >= SORT_DESC) {
		sortMod = -1 ;
		paramSort -= SORT_DESC ;
	}

	switch (paramSort) {
	case COL_COUNTRY:
		if (serv1->getCountry() != NULL && serv2->getCountry() != NULL) {
			comp = serv1->getCountry()->cntry.CompareNoCase(serv2->getCountry()->cntry);
		}
		else if (serv1->getCountry() != NULL || serv2->getCountry() != NULL) {
			comp = serv2->getCountry() == NULL ? serv1->getCountry()->cntry.Compare("ZZ") : -serv2->getCountry()->cntry.Compare("ZZ") ;
		}
		else {
			comp = 0 ;
		}
		break ;
	case COL_IP: 
		comp = serv1->getIp()->getIpTotal().Compare (serv2->getIp()->getIpTotal()) ;
		break ;
	case COL_NAME:
		comp = serv1->getNom().CompareNoCase(serv2->getNom()) ;
		break ;
	case COL_NB_PLAYERS:
		comp = serv1->getNbJoueurs() - serv2->getNbJoueurs() ;
		break;
	case COL_MAX_PLAYERS:
		comp = serv1->getMaxPublicJoueurs() - serv2->getMaxPublicJoueurs() ;
		break;
	case COL_MAP:
		comp = serv1->getNomMap().CompareNoCase (serv2->getNomMap()) ;
		break ;
	case COL_PING:
		comp = serv1->getPing() - serv2->getPing() ;
		break ;
	case COL_GAME_TYPE:
		comp = serv1->getVariable(GAME_TYPE).CompareNoCase (serv2->getVariable(GAME_TYPE)) ;
		break;
	case COL_XP_SUM:
		comp = serv1->getXpSum() - serv2->getXpSum() ;
		break;
	case COL_OCCUP:
		comp = serv1->getOccup() - serv2->getOccup() ;
		break;
	case COL_FAV:
		comp = ((int)MAIN_DLG->getFavorites()->isFavorite(serv2)) - ((int)MAIN_DLG->getFavorites()->isFavorite(serv1)) ;
		break;
	default:
		ASSERT(NULL);
		break;
	}

	return (sortMod * comp) ;
}

void ServerListCtrl::OnColumnclick(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	// TODO: Add your control notification handler code here
	this->trier (pNMListView->iSubItem) ;
	
	*pResult = 0;
}

void ServerListCtrl::setItemData (UINT nItem, Server * server)
{
	this->SetItemData (nItem, (DWORD)server) ;
}


void ServerListCtrl::insertItem (int nItem, Server * server)
{

					
	nItem = this->InsertItem (nItem,					"") ;
	this->setItemData (nItem, server) ;
	this->setItem(nItem, server) ;
	
}

void ServerListCtrl::setItem (int nItem, Server * server) 
{
	if (nItem != -1)
	{
		CString texte ;
		/* Insertion de l'ip */
		this->SetItemText (nItem, COL_IP,			server->getIp()->getIpTotal()) ;
		
		/* Insertion du nom */
		this->SetItemText (nItem, COL_NAME,			server->getNomColore()) ;

	/*	if (server->getCountry() != NULL) {
			this->SetItemText(nItem, COL_COUNTRY, server->getCountry()->cntry) ;
		}
		else {
			this->SetItemText(nItem, COL_COUNTRY, "?") ;
		}*/
		
		/* Insertion du nombre de joueurs */
		UINT nbJoueurs = server->getNbJoueurs() ;
		texte.Format ("%d", nbJoueurs) ;
		this->SetItemText (nItem, COL_NB_PLAYERS,	texte) ;
		
		/* Insertion du nombre max de joueurs */
		UINT priv = server->getPrivateClients() ;
		if (priv > 0) {
			texte.Format ("%d (+%d)", server->getMaxPublicJoueurs(), priv) ;
		}
		else {
			texte.Format ("%d", server->getMaxPublicJoueurs()) ;
		}
		this->SetItemText (nItem, COL_MAX_PLAYERS,	texte) ;
		
		/* Insertion du nom de la map */
		this->SetItemText (nItem, COL_MAP,			server->getNomMap()) ;
		
		/* Insertion du ping */
		this->SetItemText (nItem, COL_PING,			MAIN_PREF->getPing(server->getPing())) ;

		/* Insertion du type de jeu */
		this->SetItemText (nItem, COL_GAME_TYPE,	server->getVariable(GAME_TYPE)) ;

		/* Insertion des xp */
		texte.Format ("%d", server->getXpSum()) ;
		this->SetItemText (nItem, COL_XP_SUM,			texte) ;	

	/*	texte.Format ("%d", server->getOccup()) ;
		this->SetItemText (nItem, COL_OCCUP,		texte) ;*/

	}
}



Server * ServerListCtrl::getItemData (UINT nItem) {
	return ((Server*)this->GetItemData(nItem)) ;
}


/********************************************************
* Tri la liste selon la colonne triColonne				*
********************************************************/
/*virtual*/ void ServerListCtrl::trier (int triColonne /*= COL_NAME*/)
{
	ListCtrl::trier(triColonne, SortProc) ;
}

/*virtual*/ void ServerListCtrl::initControl (ServerListDlg * parent, DWORD style /*= LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES*/)
{
	ListCtrl::initControl(style) ;
	
	this->InsertColumn (COL_COUNTRY,		"Country",			LVCFMT_LEFT,	LARGEUR_COUNTRY) ;
	this->InsertColumn (COL_NAME,			"Name",				LVCFMT_LEFT,	LARGEUR_NAME) ;
	this->InsertColumn (COL_NB_PLAYERS,		"# of players ",	LVCFMT_RIGHT,	LARGEUR_NB_PLAY) ;
	this->InsertColumn (COL_MAX_PLAYERS,	"Max players",		LVCFMT_RIGHT,	LARGEUR_MAX_PLAY) ;
	this->InsertColumn (COL_MAP,			"Map name",			LVCFMT_LEFT,	LARGEUR_MAP) ;
	this->InsertColumn (COL_PING,			"Ping",				LVCFMT_LEFT,	LARGEUR_PING) ;
	this->InsertColumn (COL_GAME_TYPE,		"Mod",				LVCFMT_LEFT,	LARGEUR_GAME_TYPE) ;
	this->InsertColumn (COL_XP_SUM,			"Xp sum",			LVCFMT_LEFT,	LARGEUR_XP) ;
	this->InsertColumn (COL_OCCUP,			"% occupation",		LVCFMT_LEFT,	LARGEUR_OCCUP) ;
	this->InsertColumn (COL_FAV,			"Favorite",			LVCFMT_LEFT,	LARGEUR_FAV) ;
	this->InsertColumn (COL_IP,				"Ip",				LVCFMT_LEFT,	LARGEUR_IP) ;
	this->parent = parent ;
}

// appelle la fonction lorsque l'objet a ete modifie
/*virtual*/ void ServerListCtrl::OnChange (Objet * obj, UINT msg, void * param1,void * param2)
{
	if (msg == ClientMaster::ON_REFRESH_UN_SERVER && param1 != NULL) {

		int id = this->getItem(param1) ;
	
		/* Mise a jour des infos de la ligne */
		Server * serv = (Server*)param1 ;
		if (id != -1) {
			this->setItem(id, serv) ;
			this->redrawsItem(id) ;
		}
		else if (this->parent && this->parent->matchFiltres (serv)){
			this->insertItem (this->GetItemCount(), serv);
		}
	}
	else if (msg == ClientMaster::ON_SERVER_DELETE) {
		this->DeleteAllItems() ;
	}
}

/************************************************************
* Met a jour le tri											*
************************************************************/
/*virtual*/ void ServerListCtrl::majTri ()
{
	ListCtrl::majTri(SortProc) ;
}

void ServerListCtrl::OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
	// TODO: Add your message handler code here and/or call default
	
	ListCtrl::OnDrawItem(nIDCtl, lpDrawItemStruct);
}


void ServerListCtrl::DrawItem(LPDRAWITEMSTRUCT item)
{
	ListCtrl::DrawItem(item) ;


	
	HDC hDC = item->hDC ;
	CDC * dc = CDC::FromHandle (hDC) ;
	CRect rcItem = item->rcItem ;
	Server * server = (Server*)this->GetItemData(item->itemID) ;
	

	
	rcItem.left += 4 ;
	CRect rect(rcItem) ;

	for (int i = 0 ; i < this->nbColonnes ; i++)
	{
		int taille = this->GetColumnWidth (i) ;
		if (rect.left + taille < rcItem.right) {
			rect.right = rect.left + taille - 10 ;
		}
		else {
			rect.right = item->rcItem.right ;
		}
		
		/* draws occupation bar */
		if (i == COL_OCCUP) {
			/* cette colonne est celle de l'occupation, on affiche la barre */
			CRect contour(rect) ;
			contour.DeflateRect (0,0,0,2) ;

			/* draws gradiant */
			Degrade::dessiner(dc, contour, GRADIANT1, GRADIANT2, server->getOccup(), AFFICHE_POURCENT) ;
		}
		/* Indicate if this server is favorite */
		else if (i == COL_FAV && MAIN_DLG->getFavorites()->isFavorite(server)) 
		{
			CPen pen(PS_SOLID, 2, RGB(0,0,0)) ;
			CPen * old = dc->SelectObject(&pen) ;

		/*	CRgn rgn ;
			rgn.CreateRectRgn (rect.left, rect.top, rect.right, rect.bottom) ;
			dc->SelectClipRgn (&rgn, RGN_AND) ;*/

			dc->MoveTo (rect.left, rect.top + rect.Height() / 2) ;
			dc->LineTo (rect.left + 5, rect.bottom - 3) ;
			dc->LineTo (rect.left + 14, rect.top + 2) ;

			dc->SelectObject(old) ;

		}
		else if (i == COL_COUNTRY) {
			//HBITMAP bmp = LoadBitmap(MAIN_DLG->getIp2Country()->getImage(server->getCountry())) ;
			CBitmap bmp ;
			UINT idBmp = MAIN_DLG->getIp2Country()->getImage(server->getCountry()) ;
			if (idBmp == 0) {
				idBmp = IDB_UNKNOW ;
			}

			bmp.LoadBitmap(idBmp) ;
			//dc->BitBlt(rect.left, rect.top, bmp.GetBitmapDimension().cx, bmp.GetBitmapDimension().cy
			
			BITMAP bmpInfo;
			bmp.GetBitmap(&bmpInfo);
			
			// Create an in-memory DC compatible with the
			// display DC we're using to paint
			CDC dcMemory;
			dcMemory.CreateCompatibleDC(dc);
			
			// Select the bitmap into the in-memory DC
			CBitmap* pOldBitmap = dcMemory.SelectObject(&bmp);
			
			// Find a centerpoint for the bitmap in the client area
			
			int nX = rect.left + ((taille - 5 - bmpInfo.bmWidth) / 2);
			int nY = rect.top ;
			
			// Copy the bits from the in-memory DC into the on-
			// screen DC to actually do the painting. Use the centerpoint
			// we computed for the target offset.
			dc->BitBlt(nX, nY, bmpInfo.bmWidth, bmpInfo.bmHeight, &dcMemory, 
				0, 0, SRCCOPY);
			
			dcMemory.SelectObject(pOldBitmap);
			
   
   
		}
			
		/* passe a la colonne suivante */
		rect.left += taille ;
		
		
	}
	
}

