//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// Server.h: interface for the Server class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SERVER_H__5ACAB9C2_49C6_4D00_AC9E_D5965D3B99BE__INCLUDED_)
#define AFX_SERVER_H__5ACAB9C2_49C6_4D00_AC9E_D5965D3B99BE__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Joueur.h"
#include "defines.h"
#include "Ip.h"
#include "Exception.h"
#include <vector>
#include <map>
#include "Ip2Country.h"

using namespace std ;

#define NO_VARIABLE		""

class ClientMaster ;

class Server
{
private:
//	CString nom ;
	Ip * ip ;
//	UINT maxJoueurs ;
//	CString nomMap ;
	ClientMaster * client ;
	UINT ping ;

	Country * country ;

	// liste des joueurs du serveur
	vector<Joueur*> listeJoueurs ;
	// liste des variables du serveur
	map<CString, CString> variables ;	
public:
	Server (Ip * ip, ClientMaster * client, UINT ping = 0) throw (Exception) ;
	~Server () ;


	Ip *	getIp()			{return (this->ip);}
	CString getNom () ;
	CString getNomColore () ;
	UINT	getNbJoueurs ()	;
	UINT	getMaxJoueurs()	;
	UINT	getMaxPublicJoueurs () ;
	UINT	getPrivateClients () ;
	UINT	getPing () ;
	CString getNomMap () ;
	UINT	getXpSum () ;
	BYTE	getOccup () ;


	void setPing (UINT ping) ;

	void effacerJoueurs ()	{EFFACER_LISTE(Joueur,this->listeJoueurs);}

	/************************************************************
	* Associe ce joueur a ce serveur							*
	************************************************************/
	void ajouterJoueur (Joueur * j)	;

	/************************************************************
	* Retourne la liste de joueurs jouant sur ce serveur		*
	************************************************************/
	vector<Joueur*> * getListeJoueurs () {return (&this->listeJoueurs);}

	/************************************************************
	* Indique si le serveur est vide/plein						*
	************************************************************/
	bool estVide () {return (getNbJoueurs() == 0);}
	bool estPlein () {return (getNbJoueurs() >= getMaxPublicJoueurs());}


	/************************************************************
	* Renvoie une liste de joueurs jouant sur ce server ayant   *
	* ce nom													*
	************************************************************/
	vector<Joueur*> estSurCeServeur (CString joueur) ;

	/************************************************************
	* Modifie la valeur de cette variable						*
	* Ajoute la variable si elle n'existe pas					*
	************************************************************/
	void modifierVariable (CString nom, CString valeur) ;

	/************************************************************
	* Retourne la valeur de cette variable						*
	* Retourne NO_VARIABLE si elle n'existe pas					*
	************************************************************/
	CString getVariable (CString nom) ;

	/************************************************************
	* Retourne la valeur entiere de cette variable				*
	* Retourne 0 si elle n'existe pas							*
	************************************************************/
	int getIntVariable (CString nom) ;

	/************************************************************
	* Indique si le serveur a ete mis a jour					*
	************************************************************/
	bool estValide () ;

	/************************************************************
	* Retourne la liste des variables de ce serveur				*
	************************************************************/
	map<CString,CString> * getVariables () {return (&this->variables);}


	/************************************************************
	* Prepare le serveur au rafraichissement					*
	************************************************************/
	void raz () ;

	/************************************************************
	* Rafraichit les donnes du server							*
	************************************************************/
	void rafraichir () ;


	Country * getCountry() {return (country);}

	bool operator==(Server & autre) ;

} ;

#endif // !defined(AFX_SERVER_H__5ACAB9C2_49C6_4D00_AC9E_D5965D3B99BE__INCLUDED_)
