//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// Server.cpp: implementation of the Server class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ETBuddies.h"
#include "ETBuddiesDlg.h"
#include "Server.h"
#include "TexteColore.h"
#include "ClientMaster.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

#define SERVER_NAME		"sv_hostname"
#define SERVER_PING		"serverload"
#define MAP_NAME		"mapname"
#define MAX_CLIENTS		"sv_maxclients"
#define PRIVATE_CLIENTS	"sv_privateClients"



//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Server::Server (Ip * ip, ClientMaster * client, UINT ping) throw (Exception)
{
	if (!ip)			THROW_E ("Server::Server() : Ip incorrecte (NULL)");
	if (!client)		THROW_E ("Server::Server() : Client incorrect (NULL)");
	this->ip = ip ;
	this->ping = 999 ;
	this->client = client ;
	country = MAIN_DLG->getIp2Country()->getCountry(ip) ;
}

Server::~Server ()
{
	if (ip)			delete (ip) ;
	effacerJoueurs () ;
}

/************************************************************
* Renvoie une liste de joueurs jouant sur ce server ayant   *
* ce nom													*
************************************************************/
vector<Joueur*> Server::estSurCeServeur (CString joueur)
{
	vector<Joueur*> retour  ;
	CString nom ;

	joueur.MakeLower () ;

	
	FOR_VECTOR(Joueur*,this->listeJoueurs)
	{
		nom = (*i)->getNom() ;
		nom.MakeLower () ;
		if (nom.Find(joueur) != -1)	{
			retour.push_back(*i) ;
		}
	}
	
	return (retour) ;
}

UINT Server::getNbJoueurs ()
{
	return (this->listeJoueurs.size()) ;
}


/************************************************************
* Modifie la valeur de cette variable						*
* Ajoute la variable si elle n'existe pas					*
************************************************************/
void Server::modifierVariable (CString nom, CString valeur)
{
	this->variables.insert(map<CString,CString>::value_type(nom, valeur)) ;
}

void Server::ajouterJoueur (Joueur * j)
{
	this->listeJoueurs.push_back(j);
	j->setServeur (this) ;
}

/************************************************************
* Indique si le serveur a ete mis a jour					*
************************************************************/
bool Server::estValide () {
	return (!this->variables.empty()) ;
}

/************************************************************
* Les methodes suivantes renvoient differents parametres	*
* du serveur												*
************************************************************/
CString Server::getNom () {
	return (TexteColore::Couleur2Inco(this->getVariable (SERVER_NAME))) ;
}
CString Server::getNomColore () {
	return (this->getVariable (SERVER_NAME)) ;
}
CString Server::getNomMap () {
	return (this->getVariable (MAP_NAME)) ;
}
UINT Server::getMaxJoueurs() {
	return (this->getIntVariable (MAX_CLIENTS)) ;
}
UINT Server::getMaxPublicJoueurs () {
	return (this->getMaxJoueurs() - this->getPrivateClients()) ;
}
UINT Server::getPrivateClients () {
	return (this->getIntVariable (PRIVATE_CLIENTS)) ;
}
UINT Server::getPing () {
	return (this->ping) ;
}
void Server::setPing (UINT ping) {
	this->ping = ping;
}
UINT Server::getXpSum () 
{
	UINT retour = 0 ;
	FOR_VECTOR(Joueur*,listeJoueurs) {
		retour += (*i)->getXp() ;
	}
	return (retour) ;
}
BYTE Server::getOccup () {
	UINT nbJoueurs = this->getMaxPublicJoueurs() ;
	return (nbJoueurs > 0 ? this->getNbJoueurs() * 100 / this->getMaxPublicJoueurs() : 100) ;
}

bool Server::operator==(Server & autre)
{
	return (strcmp (
		STR_BUFFER(this->getIp()->getIpTotal()),
		STR_BUFFER(autre.getIp()->getIpTotal())) == 0) ;
}


/************************************************************
* Retourne la valeur de cette variable						*
* Retourne NO_VARIABLE si elle n'existe pas					*
************************************************************/
CString Server::getVariable (CString nom)
{
	CString retour = NO_VARIABLE ;

	map<CString, CString>::iterator v = this->variables.find (nom) ;
	if (v != this->variables.end())	{
		retour = v->second ;
	}

	return (retour) ;
}

/************************************************************
* Retourne la valeur entiere de cette variable				*
* Retourne 0 si elle n'existe pas							*
************************************************************/
int Server::getIntVariable (CString nom)
{
	int retour = 0 ;
	CString val = this->getVariable (nom) ;
	if (val != NO_VARIABLE)	{
		retour = atoi (STR_BUFFER(val)) ;
	}

	return (retour) ;

}

/************************************************************
* Prepare le serveur au rafraichissement					*
************************************************************/
void Server::raz ()
{
	this->effacerJoueurs() ;
	this->variables.clear() ;
}

/************************************************************
* Rafraichit les donnes du server							*
************************************************************/
void Server::rafraichir ()
{
	this->raz() ;
	if (this->client) {
		this->client->rafraichirServeur(this) ;
	}
}