// SelectionCountry.cpp : implementation file
//

#include "stdafx.h"
#include "ETBuddies.h"
#include "SelectionCountry.h"
#include "ETBuddiesDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define SEL_INT			RGB(194,200,218)
#define SEL_EXT			RGB(10,36,106)
#define BACK_COLOR		RGB(255,255,255)

/////////////////////////////////////////////////////////////////////////////
// SelectionCountry

SelectionCountry::SelectionCountry()
{
}

SelectionCountry::~SelectionCountry()
{
}


BEGIN_MESSAGE_MAP(SelectionCountry, MyComboBox)
	//{{AFX_MSG_MAP(SelectionCountry)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// SelectionCountry message handlers
void SelectionCountry::init() {
	Clear() ;
	CountryList * list = MAIN_DLG->getIp2Country()->getCountryList() ;


	FOR_VECTOR(Country, (*list->getList())) {
		SetItemData(AddString(i->fullCountry + " [" + i->cntry + "]"), (unsigned long)i) ;
	}
}

Country * SelectionCountry::getSel(){
	return (GetCurSel() != -1 ? (Country*)GetItemData(GetCurSel()) : NULL) ;
}

void SelectionCountry::setSel(CString cnt) {
	bool trouve = false ;
	for (int i = 0  ; i < GetCount() && !trouve ; i++) 
	{
		if (((Country*)GetItemData(i))->cntry == cnt) {
			trouve = true ;
			SetCurSel(i) ;
		}
	}

	if (!trouve) {
		SetCurSel(-1) ;
	}
}

void SelectionCountry::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
	HDC hDC = lpDrawItemStruct->hDC ;
	CDC * dc = CDC::FromHandle (hDC) ;
	CRect rcItem = lpDrawItemStruct->rcItem ;

	int itemId =lpDrawItemStruct->itemID ; 

	

	MyComboBox::Dessiner(lpDrawItemStruct, false) ;
	
	if (itemId == -1) {
		return ;
	}
	Country * c = (Country*)GetItemData(lpDrawItemStruct->itemID) ;
	
	
	
	rcItem.left += 2 ;
	rcItem.top += 1 ;
	
	/********************************************************
	* Affichage du drapeau									*
	********************************************************/
	CBitmap bmp ;
	UINT idBmp = MAIN_DLG->getIp2Country()->getImage(c) ;
	if (idBmp == 0) {
		idBmp = IDB_UNKNOW ;
	}

	bmp.LoadBitmap(idBmp) ;
	//dc->BitBlt(rect.left, rect.top, bmp.GetBitmapDimension().cx, bmp.GetBitmapDimension().cy
			
	BITMAP bmpInfo;
	bmp.GetBitmap(&bmpInfo);
			
	// Create an in-memory DC compatible with the
	// display DC we're using to paint
	CDC dcMemory;
	dcMemory.CreateCompatibleDC(dc);
			
	// Select the bitmap into the in-memory DC
	CBitmap* pOldBitmap = dcMemory.SelectObject(&bmp);
			
			
	
	// Copy the bits from the in-memory DC into the on-
	// screen DC to actually do the painting. Use the centerpoint
	// we computed for the target offset.
	dc->BitBlt(rcItem.left, rcItem.top, bmpInfo.bmWidth, bmpInfo.bmHeight, &dcMemory, 
		0, 0, SRCCOPY);
	
	dcMemory.SelectObject(pOldBitmap);
	rcItem.left += bmpInfo.bmWidth + 1 ;
	
	
	/********************************************************
	* Affichage du texte de chaque colonne					*
	********************************************************/


		

		
	/* initialisations texte et position */
	CString texte ;
	GetLBText(itemId, texte) ;


	UINT align = DT_LEFT ;	
//	dc->SetBkColor(bHighlight && bCtrlFocused ? SEL_INT : BACK_COLOR) ;
	dc->SetBkMode(TRANSPARENT) ;
	dc->SetTextColor(RGB(0,0,0)) ;
	dc->DrawText(texte, &rcItem, align);
	
}
