//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// ScrollImage.h: interface for the ScrollImage class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SCROLLIMAGE_H__27FD78BE_AFA0_4C23_8AFA_EF226F2153A5__INCLUDED_)
#define AFX_SCROLLIMAGE_H__27FD78BE_AFA0_4C23_8AFA_EF226F2153A5__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "BoutonImage.h"

class ScrollImage : public BoutonImage  
{
private:
	int maxPos ;
	int pos ;

	/* Positions des boutons haut et bas */
	CRect boutonHaut ;
	CRect boutonBas ;
public:
	ScrollImage(CString nomImage);
	virtual ~ScrollImage();

	// indique a l'image que l'utilisateur a clique a cette position
	virtual BOOL OnLButtonDown (CPoint pSouris) ;

	// indique a l'image que l'utilisateur a clique a cette position
	virtual BOOL OnLButtonUp (CPoint pSouris) ;

	// affiche le scroll a la position (x,y)
	// et au dimensions cx, cy
	// leve une Exception en cas d'erreur d'affichage
	virtual void afficher (CDC * dc, int x, int y, int cx, int cy) throw (Exception) ;

	// indique le nombre de positions differentes que peux prendre le scroll
	// Mettre 0 si le scroll est desactiv
	void setMaxPosition (int max) ;

	// positionne le scroll a cette position. Doit etre < a maxPos
	void setPosition (int pos) ;

	// indique la position courante de la barre de scroll
	int getPosition ()			{return (this->pos);}

	// indique la position max de la barre de scroll
	int getMaxPosition ()		{return (this->maxPos);}

	// descends la barre d'une position
	void descendsBarre () ;

	// monte la barre d'une position
	void monteBarre () ;

};

#endif // !defined(AFX_SCROLLIMAGE_H__27FD78BE_AFA0_4C23_8AFA_EF226F2153A5__INCLUDED_)
