//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// ScrollImage.cpp: implementation of the ScrollImage class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ETBuddies.h"
#include "ScrollImage.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

enum	{SCROLL_TOP, SCROLL_CENTRE, SCROLL_BOTTOM, SCROLL_BAR_TOP, SCROLL_BAR_CENTRE, SCROLL_BAR_BOTTOM, BOUTON_HAUT, BOUTON_BAS, FIN} ;

static Partie listeParties[] = {	Partie (SCROLL_TOP,			CRect(0,	0,	9,	79)),
									Partie (SCROLL_CENTRE,		CRect(0,	80,	9,	81)),
									Partie (SCROLL_BOTTOM,		CRect(0,	82,	9,	158)),
									Partie (SCROLL_BAR_TOP,		CRect(10,	0,	19,	2)),
									Partie (SCROLL_BAR_CENTRE,	CRect(10,	3,	19,	4)),
									Partie (SCROLL_BAR_BOTTOM,	CRect(10,	5,	19,	7)),
									Partie (BOUTON_HAUT,		CRect(10,	8,	19,	21)),
									Partie (BOUTON_BAS,			CRect(10,	22,	19,	36)),
									Partie (FIN,				NULL)
} ;



//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

ScrollImage::ScrollImage(CString nomImage) : BoutonImage (nomImage, nomImage)
{
	this->pos = 0 ;
	this->maxPos = 0 ;
	this->boutonBas = CRect (0,0,0,0) ;
	this->boutonBas = CRect (0,0,0,0) ;
}

ScrollImage::~ScrollImage()
{

}


// indique a l'image que l'utilisateur a clique a cette position
/*virtual*/ BOOL ScrollImage::OnLButtonDown (CPoint pSouris)
{
	//return (BoutonImage::OnLButtonDown(pSouris)) ;
	BOOL retour = Image::OnLButtonDown (pSouris) ;
	if (this->boutonHaut != CRect (0,0,0,0) && this->boutonBas != CRect (0,0,0,0))
	{
		if (INP(pSouris, boutonHaut)) 
		{
			this->monteBarre() ;
		}
		else if (INP(pSouris, boutonBas))
		{
			this->descendsBarre() ;
		}
	}
	return (retour) ;
}

// indique a l'image que l'utilisateur a clique a cette position
/*virtual*/ BOOL ScrollImage::OnLButtonUp (CPoint pSouris)
{
	return (BoutonImage::OnLButtonUp(pSouris)) ;
}


// indique le nombre de positions differentes que peux prendre le scroll
// Mettre 0 si le scroll est desactiv
void ScrollImage::setMaxPosition (int max)
{
	if (/*max == 1 ||*/ max < 0)				max = 0 ;
	this->maxPos = max ;
	if (this->pos >= max) {
		this->setPosition (max - 1) ;
	}

	/* la position a chang, on notifie les obs qu'il faut redessiner */
	this->notifierObs (Image::ON_REDRAW) ;
}

// positionne le scroll a cette position. Doit etre < a maxPos
void ScrollImage::setPosition (int pos)
{
	this->pos = pos ;
	if (this->pos >= maxPos) {
		this->pos = maxPos - 1 ;
	}

	if (this->pos < 0)	this->pos = 0 ;
	/* la position a chang, on notifie les obs qu'il faut redessiner */
	this->notifierObs (Image::ON_REDRAW) ;
}



// affiche le scroll a la position (x,y)
// et au dimensions cx, cy
// leve une Exception en cas d'erreur d'affichage
/*virtual*/ void ScrollImage::afficher (CDC * dc, int x, int y, int cx, int cy) throw (Exception)
{
	CRect * pos = new CRect [TAILLE_LISTE(listeParties)] ;
	for (int i = 0 ; i < TAILLE_LISTE(listeParties) ; i++)
	{
		pos[i] = getCoord(i, listeParties, FIN) ;
	}

	// hauteur totale de la barre sans les boutons



	UINT hauteurCentre = cy - pos[SCROLL_TOP].Height() - pos[SCROLL_BOTTOM].Height() - pos[BOUTON_HAUT].Height() -  pos[BOUTON_BAS].Height();
	UINT debutTop =  y + pos[BOUTON_HAUT].Height() ;

	/* Hauteur de la barre en pixels */
	UINT hauteurBarre = hauteurCentre + pos[SCROLL_TOP].Height() + pos[SCROLL_BOTTOM].Height() ;

	// affichage du bouton du haut
	this->boutonHaut = CRect (x, y, pos[BOUTON_HAUT].Width() + x, pos[BOUTON_HAUT].Height() + y) ;
	Image::afficher (dc, pos[BOUTON_HAUT],boutonHaut.left, boutonHaut.top) ;


	Image::afficher (dc, pos[SCROLL_TOP], x, debutTop) ;
	Image::afficher (dc,
		pos[SCROLL_CENTRE],
		x,
		debutTop + pos[SCROLL_TOP].Height(),
		cx,
		hauteurCentre
		) ;
	Image::afficher (dc, pos[SCROLL_BOTTOM], x, debutTop + pos[SCROLL_TOP].Height() + hauteurCentre) ;
	
	UINT depY = debutTop + pos[SCROLL_TOP].Height() + hauteurCentre + pos[SCROLL_BOTTOM].Height() ;
	this->boutonBas = CRect (x, depY, pos[BOUTON_BAS].Width() + x, pos[BOUTON_BAS].Height() + depY) ;
	Image::afficher (dc, pos[BOUTON_BAS], this->boutonBas.left, this->boutonBas.top) ;


	/************************************************************
	* Affichage de la barre de scroll si maxPos est > 1			*
	************************************************************/
	if (this->maxPos > 1)
	{
		UINT debutPourcent = (this->pos * 100) / this->maxPos ;
		UINT finPourcent = ((this->pos + 1) * 100) / this->maxPos ;

		UINT taille = (finPourcent - debutPourcent) * hauteurBarre / 100 - 6 ;

		UINT debut = debutTop + (debutPourcent * hauteurBarre) / 100 + 2;


		Image::afficher (dc, pos[SCROLL_BAR_TOP], x, debut) ;
		Image::afficher (dc, pos[SCROLL_BAR_CENTRE], x, debut + pos[SCROLL_BAR_TOP].Height(), pos[SCROLL_BAR_CENTRE].Width(), taille) ;
		Image::afficher (dc, pos[SCROLL_BAR_BOTTOM], x, debut + pos[SCROLL_BAR_TOP].Height() + taille) ;
	}

	delete [] pos ;

}

// descends la barre d'une position
void ScrollImage::descendsBarre ()
{
	this->setPosition (this->pos + 1) ;
}


// monte la barre d'une position
void ScrollImage::monteBarre ()
{
	if (this->pos > 0)
	{
		this->setPosition (this->pos - 1) ;
	}
}