#if !defined(AFX_RCONDLG_H__2746725C_6C47_4D35_87E5_80631E799886__INCLUDED_)
#define AFX_RCONDLG_H__2746725C_6C47_4D35_87E5_80631E799886__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// RconDlg.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// RconDlg dialog

#include "Socket.h"
#include "Server.h"
#include "PlayerListCtrl.h"
#include "MyComboBox.h"
#include "Observer.h"
#include <vector>
#include "SelectionGameType.h"

using namespace std ;

class RconDlg ;

class RconConnection : public Socket
{
private:
	Server * m_pServeur ;
	CString m_password ;
	RconDlg * m_pParent ;
public:
	RconConnection(Server * s, CString pass, RconDlg * parent) {
		ASSERT(s) ;
		m_pServeur = s ;
		m_password = pass ;
		m_pParent = parent ;
		create(0, SOCK_DGRAM) ;
	}

	~RconConnection() {
		close() ;
	}

	Server * getServer() {return m_pServeur;}

	void connect() throw (Exception) ;
	virtual void traiterPacket (Packet * packet) throw (Exception)  ;
	void sendCommand(CString command) ;
} ;


class RconDlg : public CDialog, Observer
{
	RconConnection * m_pConnection ;
	CMenu m_context ;
	vector<CString>		m_selectedPlayers ;
// Construction
public:
	RconDlg(CWnd* pParent = NULL);   // standard constructor
	~RconDlg() ;

	virtual void OnChange (Objet * obj, UINT msg, void * param1,void * param2) ;
	void ProcessAnswer(CString answer) ;

	void initControl() ;
// Dialog Data
	//{{AFX_DATA(RconDlg)
	enum { IDD = IDD_RCON };
	CEdit	m_say;
	CButton	m_friendlyFire;
	CEdit	m_query;
	PlayerListCtrl	m_players;
	CEdit	m_password;
	CButton	m_needPass;
	CEdit	m_map;
	SelectionGameType	m_gameType;
	CEdit	m_anwsers;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(RconDlg)
	public:
	virtual int DoModal(Server * s, CString pass);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(RconDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnRclickPlayers(NMHDR* pNMHDR, LRESULT* pResult);
	virtual void OnOK();
	afx_msg void OnUpdatePass();
	afx_msg void OnUpdateGt();
	afx_msg void OnUpdateMap();
	afx_msg void OnSayButton();
	afx_msg void OnStartMatch();
	afx_msg void OnNextMap();
	afx_msg void OnRestartMatch();
	afx_msg void OnNextCampaign();
	afx_msg void OnRestartMap();
	afx_msg void OnSwapTeams();
	afx_msg void OnNeedPass();
	afx_msg void OnFriendlyFire();
	//}}AFX_MSG
	afx_msg void OnKick();
	afx_msg void OnRefresh();
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_RCONDLG_H__2746725C_6C47_4D35_87E5_80631E799886__INCLUDED_)
