// RconDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ETBuddies.h"
#include "RconDlg.h"
#include "Joueur.h"
#include "ETBuddiesDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


enum {
	WM_REFRESH = WM_USER + 1,
	WM_KICK
};

/*virtual*/ void RconConnection::traiterPacket (Packet * packet) throw (Exception) 
{
	char * p = new char [packet->getLength() + 1] ;
	strncpy(p, (char*)packet->getPacket(), packet->getLength()) ;
	p[packet->getLength()] = '\0' ;
	CString reponse = CString (p) ;
	delete [] p ;
	Socket::traiterPacket(packet) ;
	m_pParent->ProcessAnswer(reponse) ;
}

void RconConnection::connect() throw (Exception) 
{
	
	Socket::connect(m_pServeur->getIp()->getIp(), m_pServeur->getIp()->getPort()) ;
	
}

void RconConnection::sendCommand(CString command) 
{
	CString requete = "rcon " ;
	requete += m_password ;
	requete += " " + command ;
	send(STR_BUFFER(requete), requete.GetLength()) ;
}
/////////////////////////////////////////////////////////////////////////////
// RconDlg dialog


RconDlg::RconDlg(CWnd* pParent /*=NULL*/)
	: CDialog(RconDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(RconDlg)
	//}}AFX_DATA_INIT
}

RconDlg::~RconDlg() {
	MAIN_DLG->getListeBud()->getClientMaitre()->enleverObserver(this) ;
}


void RconDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(RconDlg)
	DDX_Control(pDX, IDC_SAY, m_say);
	DDX_Control(pDX, IDC_FRIENDLY_FIRE, m_friendlyFire);
	DDX_Control(pDX, IDC_QUERY, m_query);
	DDX_Control(pDX, IDC_PLAYERS, m_players);
	DDX_Control(pDX, IDC_PASSWORD, m_password);
	DDX_Control(pDX, IDC_NEED_PASS, m_needPass);
	DDX_Control(pDX, IDC_MAP, m_map);
	DDX_Control(pDX, IDC_GAME_TYPE, m_gameType);
	DDX_Control(pDX, IDC_ANSWERS, m_anwsers);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(RconDlg, CDialog)
	//{{AFX_MSG_MAP(RconDlg)
	ON_NOTIFY(NM_RCLICK, IDC_PLAYERS, OnRclickPlayers)
	ON_BN_CLICKED(IDC_UPDATE_PASS, OnUpdatePass)
	ON_BN_CLICKED(IDC_UPDATE_GT, OnUpdateGt)
	ON_BN_CLICKED(IDC_UPDATE_MAP, OnUpdateMap)
	ON_BN_CLICKED(IDC_SAY_BUTTON, OnSayButton)
	ON_BN_CLICKED(IDC_START_MATCH, OnStartMatch)
	ON_BN_CLICKED(IDC_NEXT_MAP, OnNextMap)
	ON_BN_CLICKED(IDC_RESTART_MATCH, OnRestartMatch)
	ON_BN_CLICKED(IDC_NEXT_CAMPAIGN, OnNextCampaign)
	ON_BN_CLICKED(IDC_RESTART_MAP, OnRestartMap)
	ON_BN_CLICKED(IDC_SWAP_TEAMS, OnSwapTeams)
	ON_BN_CLICKED(IDC_NEED_PASS, OnNeedPass)
	ON_BN_CLICKED(IDC_FRIENDLY_FIRE, OnFriendlyFire)
	//}}AFX_MSG_MAP
	ON_COMMAND(WM_REFRESH, OnRefresh)
	ON_COMMAND(WM_KICK, OnKick)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// RconDlg message handlers

int RconDlg::DoModal(Server * s, CString pass) 
{
	// TODO: Add your specialized code here and/or call the base class
	m_pConnection = new RconConnection(s, pass, this) ;
	return CDialog::DoModal();
}

void RconDlg::initControl() 
{
	m_map.SetWindowText(m_pConnection->getServer()->getNomMap()) ;
	m_gameType.setType(m_pConnection->getServer()->getIntVariable("g_gametype"));
	m_players.afficheServeur(m_pConnection->getServer()) ;
	m_needPass.SetCheck(m_pConnection->getServer()->getIntVariable("g_needpass")) ;
	m_friendlyFire.SetCheck(m_pConnection->getServer()->getIntVariable("g_friendlyFire")) ;
}

BOOL RconDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	m_players.initControl() ;
	
	MAIN_DLG->getListeBud()->getClientMaitre()->ajouterObserver(this) ;

	m_context.CreatePopupMenu() ;
	m_context.InsertMenu(0, MF_BYPOSITION|MF_STRING, WM_REFRESH,	"Refresh") ; 
	m_context.InsertMenu(1, MF_BYPOSITION|MF_STRING, WM_KICK,		"Kick") ; 
	m_context.SetDefaultItem (WM_REFRESH) ;

	try {
		m_pConnection->connect() ;
	}
	catch (Exception e) {
		CString text ;
		/*m_anwsers.GetWindowText(text) ;
		text += "Error: " + e.getMessage() + "\n" ;
		m_anwsers.SetWindowText(text) ;*/
		MessageBox("Can't connect to the server:\n" + e.getMessage(),"Error while connecting to "+m_pConnection->getServer()->getIp()->getIpTotal(), MB_ICONERROR) ;
		OnCancel() ;
		return TRUE ;
		
	}

	
	m_gameType.init() ;
	initControl() ;
	m_query.SetFocus() ;
	m_pConnection->sendCommand("g_password") ;

	return FALSE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


/*virtual*/ void RconDlg::OnChange (Objet * obj, UINT msg, void * param1,void * param2) 
{
	if (msg == ClientMaster::ON_REFRESH_UN_SERVER && param1 == m_pConnection->getServer()) {
		initControl() ;
	}
}

void RconDlg::OnRclickPlayers(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	m_selectedPlayers.clear() ;
	POSITION pos = m_players.GetFirstSelectedItemPosition();
	while (pos)
	{
		int nItem = m_players.GetNextSelectedItem(pos);
		Joueur * selection = (Joueur*)m_players.GetItemData (nItem) ;
		m_selectedPlayers.push_back(selection->getNom()) ;
	}


	CPoint pt ;
	GetCursorPos(&pt) ;
	UINT kick = m_selectedPlayers.size() > 0 ? MF_ENABLED: MF_GRAYED ;
	
	m_context.EnableMenuItem (WM_KICK,		kick|MF_BYCOMMAND);
	m_context.TrackPopupMenu(TPM_LEFTALIGN|TPM_LEFTBUTTON, pt.x, pt.y, this);  
	

	*pResult = 0;
}


void RconDlg::OnKick()
{
	FOR_VECTOR(CString, m_selectedPlayers) {
		m_pConnection->sendCommand("kick " + *i) ;
	}
	m_selectedPlayers.clear() ;
}

void RconDlg::OnRefresh()
{
	m_pConnection->getServer()->rafraichir() ;
}

void RconDlg::OnOK() 
{
	CString requete ;
	m_query.GetWindowText(requete) ;
	m_pConnection->sendCommand(requete) ;
	m_query.SetWindowText("") ;
}



void RconDlg::ProcessAnswer(CString answer) 
{
	CString text ;
	m_anwsers.GetWindowText(text) ;
	answer.Replace("\n", "\x0d\x0a") ;
	char * reponse = STR_BUFFER(answer) ;
	

	if (strncmp(reponse, "print", 9) == 0) {
		reponse += 11 ;
		 ;
		CString command ;
		char * debutCommande = reponse ;
		while (*reponse != '\0' && *reponse != ' ') 
		{
			command += *reponse ;
			reponse++ ;
		}

		

		if (command == "\"g_needpass\"") 
		{
			ASSERT(strncmp(reponse, " is:\"", 5) == 0) ;
			reponse += 5 ;
			BOOL needPass = *reponse == '0' ? 0 : 1 ;
			m_needPass.SetCheck(needPass) ;
			m_password.EnableWindow(needPass) ;
		}
		else if (command == "\"g_password\"") 
		{
			ASSERT(strncmp(reponse, " is:\"", 5) == 0) ;
			reponse += 5 ;
			CString pass ;
			while (*reponse != '\0' && *reponse != '^') {
				pass += *reponse ;
				reponse++ ;
			}
			m_password.SetWindowText(pass) ;
		}


		if (command != "")
		{
			text += CString(debutCommande) ;
			m_anwsers.SetWindowText(text) ;
		}
	
	}

	
}

void RconDlg::OnUpdatePass() {	
	CString text ;
	m_password.GetWindowText(text) ;
	m_pConnection->sendCommand("seta g_password " + text) ;
}

void RconDlg::OnUpdateGt() {
	m_pConnection->sendCommand("seta g_gametype " + m_gameType.getType()) ;
}

void RconDlg::OnUpdateMap() {
	CString text ;
	m_map.GetWindowText(text) ;
	m_pConnection->sendCommand("map " + text) ;
}

void RconDlg::OnSayButton() {
	CString text ;
	m_say.GetWindowText(text) ;
	m_pConnection->sendCommand("say " + text) ;
}

void RconDlg::OnStartMatch() {
	m_pConnection->sendCommand("start_match") ;
}

void RconDlg::OnNextMap() {
	m_pConnection->sendCommand("vstr nextmap") ;
}

void RconDlg::OnRestartMatch() {
	m_pConnection->sendCommand("reset_match") ;
}

void RconDlg::OnNextCampaign() {
	m_pConnection->sendCommand("vstr nextcampaign") ;
}

void RconDlg::OnRestartMap() {
	m_pConnection->sendCommand("map_restart") ;
}

void RconDlg::OnSwapTeams() {
	m_pConnection->sendCommand("swap_teams") ;
}

void RconDlg::OnNeedPass() {	
	m_pConnection->sendCommand(CString("seta g_needpass ") + (m_needPass.GetCheck() ? "1" : "0")) ;
}

void RconDlg::OnFriendlyFire() {	
	m_pConnection->sendCommand(CString("seta g_friendlyfire ") + (m_friendlyFire.GetCheck() ? "1" : "0")) ;
}
