//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// ProgressImage.cpp: implementation of the ProgressImage class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ETBuddies.h"
#include "ProgressImage.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

enum {PROGRESS_LEFT, PROGRESS_CENTRE, PROGRESS_RIGHT, PROGRESS_L_FULL, PROGRESS_C_FULL, PROGRESS_R_FULL} ;

static CRect posr[] = {	CRect(0,	0,	164,	13),
						CRect(165,	0,	166,	13),
						CRect(167,	0,	187,	13),
						CRect(0,	14,	164,	27),
						CRect(165,	14,	166,	27),
						CRect(167,	14,	187,	27)	} ;

ProgressImage::ProgressImage(CString nom) : Image (nom)
{
	this->setRange (0,100) ;
	this->setPos (0) ;
}

ProgressImage::~ProgressImage()
{

}

void ProgressImage::setRange (UINT min, UINT max)
{
	if (max <= min)		max = min + 1 ;
	this->max = max ;
	this->min = min ;
}

void ProgressImage::setPos (UINT pos)
{
	if (pos > max)		pos = max ;
	this->pos = pos ;
	this->notifierObs (Image::ON_REDRAW, (void*)this->rect) ;
}

// affiche le buddy a la position (x,y)
// et au dimensions cx, cy
// leve une Exception en cas d'erreur d'affichage
/*virtual*/ void ProgressImage::afficher (CDC * dc, int x, int y, int cx, int cy)
{
	CRect left = posr[PROGRESS_LEFT] ;
	CRect leftFull = posr[PROGRESS_L_FULL] ;

	CRect right = posr[PROGRESS_RIGHT] ;
	CRect rightFull = posr[PROGRESS_R_FULL] ;

	
	int rapportL = left.Width() * 100 / cx ;
	int rapportR = posr[PROGRESS_RIGHT].Width() * 100 / cx ;
	int rapportC = 100 - rapportR - rapportL ;

	int prct = this->pos * 100 / (max - min) ;

	if (prct > rapportL)
	{
		left = CRect(0,0,0,0) ;
	}
	else
	{
		leftFull.right = leftFull.right * prct / rapportL ;
		left.left = leftFull.right ;
	}


	// affichage de la barre de gauche
	if (leftFull.Width() > 0)	Image::afficher (dc, leftFull, x, y) ;
	if (left.Width() > 0)		Image::afficher (dc, left, x + leftFull.right, y) ;


	// affichage du centre
	UINT largeur = cx - posr[PROGRESS_RIGHT].Width() - posr[PROGRESS_LEFT].Width() ;
	UINT finCentre ;
	if (prct > rapportL)
	{
		finCentre = (prct < rapportL + rapportC) ?  largeur * (prct - rapportL) / rapportC : largeur ;
		Image::afficher (dc, posr[PROGRESS_C_FULL], x + posr[PROGRESS_LEFT].Width(), y, finCentre, posr[PROGRESS_CENTRE].Height()) ;
	}
	else
		finCentre = 0 ;

	if (prct < rapportL + rapportC)
	{
		Image::afficher (dc, posr[PROGRESS_CENTRE], x + posr[PROGRESS_LEFT].Width() + finCentre, y, largeur - finCentre , posr[PROGRESS_CENTRE].Height()) ;
	}


	// affichage du reste
	if (prct == 100)
	{
		right = CRect (0,0,0,0) ;
	}
	else if (prct > rapportL + rapportC)
	{
		rightFull.right = rightFull.right * (prct - rapportL - rapportC) / rapportR ;
		right.left = rightFull.right ;
	}
	else
	{
		rightFull = CRect (0,0,0,0) ;
	}

	if (rightFull.Width() > 0)		Image::afficher (dc, rightFull, x + cx - posr[PROGRESS_RIGHT].Width(), y) ;
	if (right.Width() > 0)			Image::afficher (dc, right, x + cx - posr[PROGRESS_RIGHT].Width() + rightFull.right, y) ;



	if (!this->rect)	this->rect = new CRect() ;
	this->rect->SetRect(x, y, x + cx, y + cy) ;
}
