//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

///////////////////////////////////////////////////////////////////////////////
//	Fichier	|	Preferences.h												 //
///////////////////////////////////////////////////////////////////////////////
//	Role	|	Cette classe contient les preferences du programme			 //
//			|	(modifiable dans les options)								 //
///////////////////////////////////////////////////////////////////////////////


#ifndef _PREFERENCES_H
#define _PREFERENCES_H

#include "ini.h"
#include <vector>
using namespace std ;


#define VAR_ANTI_LAG	"g_antilag"
#define VAR_BALANCED	"g_balancedteams"
#define VAR_FF			"g_friendlyFire"
#define VAR_RESTRICT	"g_heavyWeaponRestriction"
#define VAR_MAX_LIVES	"g_maxlives"
#define VAR_NEED_PASS	"g_needpass"
#define VAR_PB			"sv_punkbuster"


class Preferences
{
private:
	// repertoire d'installation du programme
	CString repInstall ;

	// nom du dernier skin charg
	CString skin ;

	// niveau de transparence
	BYTE transparence ;

	// temps d'attente avant d'indiquer un time out
	int timeOutMaitre ;
	int timeOutSlave ;

	// nombre de recherches simultanes sur les serveurs
	int nbRecherchesSimul ;

	// temps d'attente avant un rafraichissement partiel de la liste des serveurs
	int tempsAttenteRefresh ;

	// serveur maitre d'ET (etmaster.idsoftware.com)
	CString serveurMaitre ;
	// numero de version du protocole
	int protocole ;

	// nom du fichier contenant les buddies
	CString nomFicBud ;

	// indique si il y a un refresh lorsque ETBuddies est lanc
	bool refreshStart ;

	// indique si la fenetre est minimise lorsque l'user clique sur la croix close
	bool minClose ;
	

	// fichier ini contenant les preferences
	Ini * ini ;

	// etats des filtres
	UINT filtres ;

	/* connection of the user */
	UINT connection ;

	// charge les preferences a partir du fichier ini
	void LoadPref () ;

	// sauvegarde les preferences dans le fichier ini
	void SavePref () throw (Exception) ;

	// nombres de passes pour la connection
	int nbPasses ;

	/* indicate if info server is refreshing automatically */
	bool refreshInfos ;

	/* indicate time before refreshing server infos */
	int tempsRefreshServer ;

	/* gradiant colors in server list */
	COLORREF gradiant1, gradiant2 ;

	/* ET.exe location */
	CString etDirectory ;

	bool m_etkey ;

	bool stayOnTop ;
	CString m_etArgs ;
	bool m_startMinimized ;

	void setFiltre (UINT filtre) ;

	UINT pingBon() ;
	UINT pingMoyen() ;
	UINT pingMauvais() ;
	
public:

	/* Filtres de la liste des serveurs */
	static UINT EMPTY_FULL ;
	static UINT NEED_PASS ;
	static UINT FF ;
	static UINT MAX_LIVES ;
	static UINT RESTRICT ;
	static UINT PB ;
	static UINT ANTI_LAG ;
	static UINT BALANCED ;

	/* Etat des differents filtres */
	static UINT SHOW ;
	static UINT HIDE ;
	static UINT DISABLE ;

	/* Type of connections */
	static UINT CON_56K ;
	static UINT CON_128K ;
	static UINT CON_512K ;
	static UINT CON_1M ;
	static UINT CON_2M ;

	// constructeur
	// nomPref : nom du fichier ini a charger
	Preferences (CString nomPref) throw (Exception) ;
	~Preferences () ;

	
	CString getRepInstall () {return (this->repInstall);}
	void setRepInstall (CString rep) ;

	BYTE getTransparence () {return (this->transparence);}
	void setTransparence (BYTE trans) ;

	CString getSkin () {return (this->skin);}
	void setSkin (CString skin) {this->skin = skin;}

	/************************************************************
	* parametres time out maitre et slave						*
	************************************************************/
	int getTimeOutMaitre ()	{return (this->timeOutMaitre);}
	void setTimeOutMaitre (int timeOut) ;
	void setDefaultTimeOutMaitre() ;

	int getTimeOutSlave ()		{return (this->timeOutSlave);}
	void setTimeOutSlave (int timeOut) throw (Exception) ;
	void setDefaultTimeOutSlave () ;

	
	/************************************************************
	* parametres nombre de recherches simultanees				*
	************************************************************/
	int getNbSearchSimul () ;/*	{return (this->nbRecherchesSimul);}*/
	void setNbSearchSimul (int nbSearch) ;
	void setDefaultSearchSimul () ;

	/************************************************************
	* parametres temps d'attente avant refresh					*
	************************************************************/
	int getTempsAttenteRefresh ()	{return (this->tempsAttenteRefresh);}
	void setTempsAttenteRefresh (int attente) ;
	void setDefaultAtttenteRefresh () ;

	/************************************************************
	* parametres adresse du serveur maitre ET					*
	************************************************************/
	CString getServeurMaitre ()	{return (this->serveurMaitre);}
	void setServeurMaitre (CString serveur)	throw (Exception) ;
	void setDefaultServeurMaitre () ;

	int getProtocole ()			{return (this->protocole);}
	void setProtocole (int proto) throw (Exception) ;
	void setDefaultProto ()	;
	


	/************************************************************
	* Retourne le path de l'executable							*
	************************************************************/
	CString getPathExe () {return (this->getRepInstall() + AfxGetApp()->m_pszExeName + ".exe");}



	/************************************************************
	* parametres actualisation au demarrage						*
	************************************************************/
	bool getRefreshAtStart () {return (this->refreshStart);}
	void setRefreshAtStart (bool refresh) {this->refreshStart = refresh;}
	void setDefaultRefreshAtStart () ;

	
	/************************************************************
	* parametres minimise instead of close						*
	************************************************************/
	bool getMinInsteadClose () {return (this->minClose);}
	void setMinInsteadClose (bool min) {this->minClose = min;}
	void setDefaultMinClose () ;

	/************************************************************
	* Indique l'etat de ce filtre								*
	************************************************************/
	UINT getEtatFiltre (UINT filtre) ;
	/********************************
	* Ajoute ce filtre				*
	* show = SHOW, HIDE, DISABLE	*
	********************************/
	void ajouterFiltre (UINT filtre, UINT show) ;
	void setDefaultFiltres () ;


	/************************************************************
	* parametres nombre de passes								*
	************************************************************/
	int getNbPasses () {return (this->nbPasses);}
	void setNbPasses (int nbPasses) throw (Exception);
	void setDefaultNbPasses () ;

	/************************************************************
	* Retourne une chaine de caracteres colore representant le *
	* ping. Colorise en fonction du temps de reponses			*
	************************************************************/
	CString getPing (UINT ping) ;


	/************************************************************
	* parametres auto refresh									*
	************************************************************/
	bool getAutoRefresh () {return (this->refreshInfos);}
	void setAutoRefresh (bool autoRefresh) {this->refreshInfos = autoRefresh ;}
	int getTempsRefreshServer () {return (this->tempsRefreshServer);}
	void setTempsRefreshServer (int temps) ;
	

	/************************************************************
	* Couleur des degrads sur le server list					*
	************************************************************/
	COLORREF	getGradiant1 () {return (this->gradiant1);}
	COLORREF	getGradiant2 () {return (this->gradiant2);}
	void		setGradiant1 (COLORREF couleur) ;
	void		setGradiant2 (COLORREF couleur) ;
	void		setDefaultGradiant1 () ;
	void		setDefaultGradiant2 () ;

	/************************************************************
	* Type de connection de l'utilisateur						*
	************************************************************/
	UINT	getConnection () {return (this->connection);}
	void	setConnection (UINT connection) throw (Exception) ;
	void	setDefaultConnection() ;

	/************************************************************
	* Emplacement de l'executable ET							*
	************************************************************/
	CString getETDirectory() {return (this->etDirectory);}
	void setETDirectory (CString dir) throw (Exception) ;
	void setDefaultETDirectory () ;
	CString getDefaultETDirectory() ;


	/************************************************************
	* Stay always on top										*
	************************************************************/
	bool getStayOnTop () {return (stayOnTop);}
	void setStayOnTop (bool top) {this->stayOnTop = top;}
	void setDefaultStayOnTop() ;


	bool getDelETkey() {return (m_etkey) ;}
	void setDelETkey(bool del) {m_etkey = del ;}
	void setDefaultDelETkey() ;
	vector<CString> getETArgsList() ;
	CString getETArgs() {return (m_etArgs);}
	void setETArgs(CString args) {m_etArgs = args;}
	void setDefaultETArgs() ;
	bool getStartMinimized() {return m_startMinimized;}
	void setStartMinimized(bool start) {m_startMinimized = start;}
	void setDefaultStartMinimized() ;


	void initPref () ;
	
	

} ;

#endif