//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.tk )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "stdafx.h"
#include "preferences.h"
#include "defines.h"
#include "Fichier.h"
#include "Atlbase.h"


#define ET_EXE					"ET.exe"
#define ET_KEY					"SOFTWARE\\Activision\\Wolfenstein - Enemy Territory"
#define MAX_INSTALL_PATH		1024


#define DEFAULT_TIME_OUT_MAITRE			7
#define DEFAULT_TIME_OUT_SLAVE			1
#define DEFAULT_SEARCH_SIMUL			50
#define DEFAULT_ATTENTE_REFRESH			0
#define DEFAULT_MASTER_SERVER			"etmaster.idsoftware.com"
#define DEFAULT_PROTO					84
#define DEFAULT_REFRESH_AT_START		false
#define DEFAULT_MIN_CLOSE				true
#define DEFAULT_FILTRES					HIDE(EMPTY_FULL)|HIDE(NEED_PASS)
#define DEFAULT_NB_PASSES				2
#define DEFAULT_AUTO_REFRESH			true
#define DEFAULT_TEMPS_REFRESH_SERVER	5
//#define DEFAULT_GRADIANT1				RGB(0,194,250)
#define DEFAULT_GRADIANT1				RGB(128,255,255)
#define DEFAULT_GRADIANT2				RGB(23,15,187)
#define DEFAULT_CONNECTION				Preferences::CON_1M
#define DEFAULT_ET_DIR					this->getDefaultETDirectory()
#define DEFAULT_STAY_TOP				false
#define DEFAULT_ETKEY					false
#define DEFAULT_ET_ARGS					""
#define DEFAULT_START_MINIMIZED			false

/* Filtres de la liste des serveurs */
/*static*/ UINT Preferences::EMPTY_FULL	= 0x01 ;
/*static*/ UINT Preferences::NEED_PASS	= 0x02 ;
/*static*/ UINT Preferences::FF			= 0x04 ;
/*static*/ UINT Preferences::MAX_LIVES	= 0x08 ;
/*static*/ UINT Preferences::RESTRICT	= 0x10 ;
/*static*/ UINT Preferences::PB			= 0x20 ;
/*static*/ UINT Preferences::ANTI_LAG	= 0x40 ;
/*static*/ UINT Preferences::BALANCED	= 0x80 ;

/* Etat des differents filtres */
/*static*/ UINT Preferences::SHOW		= 1 ;
/*static*/ UINT Preferences::HIDE		= 2 ;
/*static*/ UINT Preferences::DISABLE	= 3 ;

/* Type of connections */
/*static*/ UINT Preferences::CON_56K	= 0 ;
/*static*/ UINT Preferences::CON_128K	= 1 ;
/*static*/ UINT Preferences::CON_512K	= 2 ;
/*static*/ UINT Preferences::CON_1M		= 3 ;
/*static*/ UINT Preferences::CON_2M		= 4 ;


#define SHOW(filtre)		(filtre)
#define HIDE(filtre)		(filtre << 8)

#define PING_BON				pingBon()
#define PING_MOYEN				pingMoyen()
#define PING_MAUVAIS			pingMauvais()
#define MAX_PING				999


#define PING_BON_C				"^2"
#define PING_MOYEN_C			"^s"
#define PING_MAUVAIS_C			"^8"
#define PING_ELEVE_C			"^1"



Preferences::Preferences (CString nomPref)
{
	this->initPref() ;
	this->ini = new Ini (this->repInstall + nomPref) ;
	this->LoadPref() ;

}

Preferences::~Preferences ()
{
	try
	{
		this->SavePref () ;
	}
	CATCH_EXCEPTION_NO_MSG ;
	delete (this->ini) ;
	
}

void Preferences::initPref ()
{

	char buffer[1024] ;
	GetCurrentDirectory (sizeof(buffer), buffer) ;
	CString dir = buffer ;
	dir += "\\" ;

	this->repInstall = dir ;
}

// charge les preferences a partir du fichier ini
void Preferences::LoadPref ()
{
/*	char buffer[1024] ;
	GetCurrentDirectory (sizeof(buffer), buffer) ;
	CString dir = buffer ;
	dir += "\\" ;*/

	try
	{
		setTransparence			(ini->readInt		("Transparence"			, 0)) ;
		setSkin					(ini->readString	("Skin"					, "")) ;
		setNbSearchSimul		(ini->readInt		("SearchSimul"			, DEFAULT_SEARCH_SIMUL)) ;
		setTempsAttenteRefresh	(ini->readInt		("AttenteRefresh"		, DEFAULT_ATTENTE_REFRESH)) ;
		setTimeOutMaitre		(ini->readInt		("MasterTimeOut"		, DEFAULT_TIME_OUT_MAITRE)) ;
		setTimeOutSlave			(ini->readInt		("SlaveTimeOut"			, DEFAULT_TIME_OUT_SLAVE)) ;
		setServeurMaitre		(ini->readString	("ETServer"				, DEFAULT_MASTER_SERVER)) ;
		setProtocole			(ini->readInt		("ETProtocole"			, DEFAULT_PROTO)) ;
		setRefreshAtStart		(ini->readBool		("RefreshAtStart"		, DEFAULT_REFRESH_AT_START)) ;
		setMinInsteadClose		(ini->readBool		("MinInsteadClose"		, DEFAULT_MIN_CLOSE)) ;
		setFiltre				(ini->readInt		("Filtres"				, DEFAULT_FILTRES)) ;
		setNbPasses				(ini->readInt		("NbPasses"				, DEFAULT_NB_PASSES)) ;
		setAutoRefresh			(ini->readBool		("AutoRefreshInfos"		, DEFAULT_AUTO_REFRESH)) ;
		setTempsRefreshServer	(ini->readInt		("TempsRefreshServer"	, DEFAULT_TEMPS_REFRESH_SERVER)) ;
		setGradiant1			(ini->readColor		("Gradiant1"			, DEFAULT_GRADIANT1)) ;
		setGradiant2			(ini->readColor		("Gradiant2"			, DEFAULT_GRADIANT2)) ;
		setConnection			(ini->readInt		("Connection"			, DEFAULT_CONNECTION)) ;
		setETDirectory			(ini->readString	("ETDirectory"			, DEFAULT_ET_DIR)) ;
		setStayOnTop			(ini->readBool		("StayOnTop"			, DEFAULT_STAY_TOP)) ;
		setDelETkey				(ini->readBool		("DelETkey"				, DEFAULT_ETKEY)) ;
		setETArgs				(ini->readString	("ETArgs"				, DEFAULT_ET_ARGS)) ;
		setStartMinimized		(ini->readBool		("StartMinimized"		, DEFAULT_START_MINIMIZED)) ;
		
	}
	catch (Exception e)
	{
		setDefaultAtttenteRefresh() ;
		setDefaultProto() ;
		setDefaultSearchSimul() ;
		setDefaultServeurMaitre() ;
		setDefaultTimeOutMaitre() ;
		setDefaultTimeOutSlave() ;
		setDefaultRefreshAtStart() ;
		setDefaultMinClose() ;
		setDefaultFiltres() ;
		setDefaultNbPasses() ;
		refreshInfos = DEFAULT_AUTO_REFRESH ;
		tempsRefreshServer = DEFAULT_TEMPS_REFRESH_SERVER ;
		setDefaultGradiant1() ;
		setDefaultGradiant2() ;
		setDefaultConnection() ;
		setDefaultETDirectory() ;
		setDefaultStayOnTop() ;
		setDefaultDelETkey() ;
		setDefaultETArgs() ;
		setDefaultStartMinimized() ;
	}
}

// sauvegarde les preferences dans le fichier ini
void Preferences::SavePref ()
{
	ini->SetWrite() ;
	ini->write ("install",				repInstall) ;
	ini->write ("Transparence",			getTransparence()) ;
	ini->write ("Skin",					getSkin()) ;
	ini->write ("MasterTimeOut",		getTimeOutMaitre());
	ini->write ("SlaveTimeOut",			getTimeOutSlave());
	ini->write ("SearchSimul",			getNbSearchSimul());
	ini->write ("AttenteRefresh",		getTempsAttenteRefresh()) ;
	ini->write ("ETServer",				getServeurMaitre()) ;
	ini->write ("ETProtocole",			getProtocole()) ;
	ini->write ("RefreshAtStart",		getRefreshAtStart()) ;
	ini->write ("MinInsteadClose",		getMinInsteadClose()) ;
	ini->write ("Filtres",				(int)filtres) ;
	ini->write ("NbPasses",				nbPasses) ;
	ini->write ("AutoRefreshInfos",		refreshInfos) ;
	ini->write ("TempsRefreshServer",	tempsRefreshServer) ;
	ini->write ("Gradiant1" ,			gradiant1) ;
	ini->write ("Gradiant2" ,			gradiant2) ;
	ini->write ("Connection",			(int)connection) ;
	ini->write ("ETDirectory",			etDirectory) ;
	ini->write ("StayOnTop",			stayOnTop) ;
	ini->write ("DelETkey",				m_etkey) ;
	ini->write ("ETArgs",				m_etArgs) ;
	ini->write ("StartMinimized",		m_startMinimized) ;

}


void Preferences::setRepInstall (CString rep)
{
	repInstall = rep ;
}


void Preferences::setTransparence (BYTE trans)
{
	if (trans > 10 || trans == 0)		trans = 10 ;
	transparence = trans ;
}


/************************************************************
* parametres time out maitre et slave						*
************************************************************/
void Preferences::setTimeOutMaitre (int timeOut)
{
	if (timeOut <= 0)
	{
		throw (Exception ("Time out must be a positive value"));
	}
	timeOutMaitre = timeOut ;
}


void Preferences::setDefaultTimeOutMaitre()
{
	setTimeOutMaitre (DEFAULT_TIME_OUT_MAITRE);
}


void Preferences::setTimeOutSlave (int timeOut) 
{
	if (timeOut <= 0) {
		throw (Exception ("Time out must be a positive value"));
	}
	timeOutSlave = timeOut ;
}

void Preferences::setDefaultTimeOutSlave ()
{
	setTimeOutSlave (DEFAULT_TIME_OUT_SLAVE);
}

/************************************************************
* parametres nombre de recherches simultanees				*
************************************************************/
void Preferences::setNbSearchSimul (int nbSearch)
{
	if (nbSearch <= 0)
	{
		throw (Exception ("Number of simultaneous connection must be a positive value"));
	}
	nbRecherchesSimul = nbSearch ;
}

void Preferences::setDefaultSearchSimul ()
{
	setNbSearchSimul (DEFAULT_SEARCH_SIMUL) ;
}


/************************************************************
* parametres temps d'attente avant refresh					*
************************************************************/
void Preferences::setTempsAttenteRefresh (int attente)
{
	if (attente < 0) {
		throw (Exception ("Refresh delay must be positive or null"));
	}
	tempsAttenteRefresh = attente ;
}

void Preferences::setDefaultAtttenteRefresh ()
{
	setTempsAttenteRefresh (DEFAULT_ATTENTE_REFRESH) ;
}

/************************************************************
* parametres adresse du serveur maitre ET					*
************************************************************/
void Preferences::setServeurMaitre (CString serveur)	throw (Exception)
{
	if (serveur == "")
	{
		throw (Exception ("Master server host is required")) ;
	}
	serveurMaitre = serveur ;
}

void Preferences::setDefaultServeurMaitre ()
{
	setServeurMaitre (DEFAULT_MASTER_SERVER) ;
}

void Preferences::setProtocole (int proto) throw (Exception)
{
	if (proto <= 0)
	{
		THROW_E ("Protocole number must be positive");
	}
	protocole = proto ;
}

void Preferences::setDefaultProto ()
{
	setProtocole (DEFAULT_PROTO) ;
}



/************************************************************
* parametres actualisation au demarrage						*
************************************************************/
void Preferences::setDefaultRefreshAtStart ()
{
	setRefreshAtStart (DEFAULT_REFRESH_AT_START) ;
}

/************************************************************
* parametres minimise instead of close						*
************************************************************/
void Preferences::setDefaultMinClose ()
{
	setMinInsteadClose (DEFAULT_MIN_CLOSE) ;
}

/************************************************************
* Indique l'etat de ce filtre								*
************************************************************/
UINT Preferences::getEtatFiltre (UINT filtre)
{
	if (filtres & SHOW(filtre)) {
		return (Preferences::SHOW) ;
	}
	else if (filtres & HIDE(filtre)) {
		return (Preferences::HIDE) ;
	}
	else {
		return (Preferences::DISABLE) ;
	}
}

/********************************
* Ajoute ce filtre				*
* show = SHOW, HIDE, DISABLE	*
********************************/
void Preferences::ajouterFiltre (UINT filtre, UINT show)
{
	ASSERT (show == Preferences::SHOW || show == Preferences::HIDE || show == Preferences::DISABLE);
	
	/* Filtre affich */
	if (show == Preferences::SHOW) {
		filtres = filtres | SHOW(filtre) ;
		filtres = filtres & (~HIDE(filtre)) ;
	}
	/* Filtre cach */
	else if (show == Preferences::HIDE) {
		filtres = filtres | HIDE(filtre) ;
		filtres = filtres & (~SHOW(filtre)) ;
	}
	/* Filtre desactiv */
	else if (show == Preferences::DISABLE) {
		filtres = filtres & (~HIDE(filtre)) ;
		filtres = filtres & (~SHOW(filtre)) ;
	}



}

void Preferences::setDefaultFiltres ()
{
/*	ajouterFiltre (Preferences::ANTI_LAG,		Preferences::DISABLE) ;
	ajouterFiltre (Preferences::EMPTY_FULL,	Preferences::DISABLE) ;
	ajouterFiltre (Preferences::NEED_PASS,	Preferences::DISABLE) ;
	ajouterFiltre (Preferences::FF,			Preferences::DISABLE) ;
	ajouterFiltre (Preferences::MAX_LIVES,	Preferences::DISABLE) ;
	ajouterFiltre (Preferences::RESTRICT,		Preferences::DISABLE) ;
	ajouterFiltre (Preferences::PB,			Preferences::DISABLE) ;*/
	filtres = DEFAULT_FILTRES ;
}

void Preferences::setFiltre (UINT filtre)
{
	filtres = filtre ;
}


/************************************************************
* parametres nombre de passes								*
************************************************************/
void Preferences::setNbPasses (int nbPasses) throw (Exception)
{
	if (nbPasses <= 0) {
		THROW_E("Number of retry must be >= 0");
	}
	this->nbPasses = nbPasses ;
}

void Preferences::setDefaultNbPasses ()
{
	setNbPasses (DEFAULT_NB_PASSES) ;
}


/************************************************************
* Retourne une chaine de caracteres colore representant le *
* ping. Colorise en fonction du temps de reponses			*
************************************************************/
CString Preferences::getPing (UINT ping)
{
	CString couleur ;
	CString retour ;


	if (ping < PING_BON) {
		couleur = PING_BON_C ;
	}
	else if (ping < PING_MOYEN) {
		couleur = PING_MOYEN_C ;
	}
	else if (ping < PING_MAUVAIS) {
		couleur = PING_MAUVAIS_C ;
	}
	else {
		couleur = PING_ELEVE_C ;
	}

	if (ping > MAX_PING)	ping = MAX_PING ;

	retour.Format ("%s%d", couleur, ping) ;
	return (retour) ;
}

/************************************************************
* parametres auto refresh									*
************************************************************/
void Preferences::setTempsRefreshServer (int temps)
{
	if (temps <= 0) {
		THROW_E("Time must be a positive value") ;
	}
	tempsRefreshServer = temps ;
}


/************************************************************
* Couleur des degrads sur le server list					*
************************************************************/
void Preferences::setGradiant1 (COLORREF couleur) {
	gradiant1 = couleur ;
}
void Preferences::setGradiant2 (COLORREF couleur) {
	gradiant2 = couleur ;
}
void Preferences::setDefaultGradiant1 () {
	setGradiant1 (DEFAULT_GRADIANT1) ;
}
void Preferences::setDefaultGradiant2 () {
	setGradiant2 (DEFAULT_GRADIANT2) ;
}

/************************************************************
* Type de connection de l'utilisateur						*
************************************************************/
void Preferences::setConnection (UINT connection) throw (Exception)
{
	if (connection != Preferences::CON_56K &&
		connection != Preferences::CON_128K &&
		connection != Preferences::CON_512K &&
		connection != Preferences::CON_1M &&
		connection != Preferences::CON_2M) {
		THROW_E("Incorrect connection type") ;
	}
	this->connection = connection ;
}

void Preferences::setDefaultConnection()
{
	setConnection (DEFAULT_CONNECTION) ;
}

UINT Preferences::pingBon()
{
	UINT retour = 0 ;

	if (connection == CON_56K)			retour = 300 ;
	else if (connection == CON_128K)	retour = 200 ;
	else if (connection == CON_512K)	retour = 200 ;
	else if (connection == CON_1M)		retour = 150 ;
	else								retour = 100 ;

	return (retour) ;
}

UINT Preferences::pingMoyen()
{
	UINT retour = 0 ;

	if (connection == CON_56K)			retour = 400 ;
	else if (connection == CON_128K)	retour = 300 ;
	else if (connection == CON_512K)	retour = 250 ;
	else if (connection == CON_1M)		retour = 200 ;
	else								retour = 150 ;

	return (retour) ;
}

UINT Preferences::pingMauvais()
{
	
	UINT retour = 0 ;

	if (connection == CON_56K)			retour = 500 ;
	else if (connection == CON_128K)	retour = 350 ;
	else if (connection == CON_512K)	retour = 300 ;
	else if (connection == CON_1M)		retour = 300 ;
	else								retour = 200 ;

	return (retour) ;
}

/************************************************************
* Emplacement de l'executable ET							*
************************************************************/
void Preferences::setETDirectory (CString dir) throw (Exception)
{
	if (dir != "") 
	{
		try
		{
			Fichier f(dir, Fichier::MODE_READ|Fichier::TYPE_BINARY) ;
			f.Close() ;
		}
		catch (Exception e) {
			CString erreur ;
			erreur.Format ("%s is not a valid file", dir) ;
			THROW_E(erreur) ;
		}
	}

	etDirectory = dir ;
}

void Preferences::setDefaultETDirectory ()
{
	try{
		setETDirectory (getDefaultETDirectory()) ;
	}
	catch (Exception e) {
		setETDirectory ("") ;
	}
}

CString Preferences::getDefaultETDirectory()
{
	//********************************************************************
	// initialisation du repertoire d'installation de ET
	//********************************************************************
	CString retour = "" ;

	char install [MAX_INSTALL_PATH] ; 
	install[0] = '\0' ;
	CRegKey reg ;
	DWORD taille = MAX_INSTALL_PATH ;
	if (reg.Open (HKEY_LOCAL_MACHINE, ET_KEY, KEY_READ) == ERROR_SUCCESS)
	{
		if (reg.QueryValue (install, "InstallPath", &taille) == ERROR_SUCCESS)
		{
			retour = install ;
			retour += CString ("\\") + ET_EXE ;
		}
		reg.Close() ;
	}

	return (retour) ;
}


/************************************************************
* Stay always on top										*
************************************************************/
void Preferences::setDefaultStayOnTop() {
	setStayOnTop (DEFAULT_STAY_TOP) ;
}


void Preferences::setDefaultDelETkey() 
{
	setDelETkey(DEFAULT_ETKEY) ;
}

int Preferences::getNbSearchSimul () {
	int retour ;

	if (connection == CON_56K)			retour = 5 ;
	else if (connection == CON_128K)	retour = 10 ;
	else if (connection == CON_512K)	retour = 20 ;
	else if (connection == CON_1M)		retour = 50 ;
	else								retour = 50 ;

	return (retour) ;
}

void Preferences::setDefaultETArgs()
{
	setETArgs(DEFAULT_ET_ARGS);
}

vector<CString> Preferences::getETArgsList() {
	vector<CString> retour ;
	CString arg ;

	for (int i = 0 ; i < m_etArgs.GetLength() ; i++) {
		if (m_etArgs.GetAt(i) != ' ') {
			arg += m_etArgs.GetAt(i) ;
		}
		else {
			retour.push_back(arg);
			arg = "" ;
		}
	}

	if (arg != "") {
		retour.push_back(arg) ;
	}

	return (retour) ;

}


void Preferences::setDefaultStartMinimized() {
	setStartMinimized(DEFAULT_START_MINIMIZED);
}