//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#if !defined(AFX_PLAYERLISTCTRL_H__3387A6C3_CDDB_44E3_8223_A1FC7D39E6F6__INCLUDED_)
#define AFX_PLAYERLISTCTRL_H__3387A6C3_CDDB_44E3_8223_A1FC7D39E6F6__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// PlayerListCtrl.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// PlayerListCtrl window

#include "ListCtrl.h"
#include "Joueur.h"

class PlayerListCtrl : public ListCtrl
{
// Construction
public:
	PlayerListCtrl();

// Attributes
public:

// Operations
public:
	/* Parametre de selection du tri a fournir a la methode trier() */
	static UINT TRI_NOM_JOUEUR ;
	static UINT TRI_XP ;
	static UINT TRI_PING ;

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(PlayerListCtrl)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~PlayerListCtrl();
	static int CALLBACK SortProc(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort) ;
	void setItem (UINT nItem, Joueur * joueur) ;
	void afficheServeur(Server * s) ;

	/********************************************************
	* Tri la liste selon la colonne triColonne				*
	* Valeurs possibles pour triColonne :					*
	*		- TRI_NOM_JOUEUR								*
	*		- TRI_XP										*
	*		- TRI_PING										*
	********************************************************/
	virtual void trier (int triColonne = TRI_XP) ;
	virtual void initControl (DWORD style = LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES) ;

	/************************************************************
	* Met a jour le tri											*
	************************************************************/
	virtual void majTri () ;



	// Generated message map functions
protected:
	//{{AFX_MSG(PlayerListCtrl)
		// NOTE - the ClassWizard will add and remove member functions here.
	afx_msg void OnColumnclick(NMHDR* pNMHDR, LRESULT* pResult);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_PLAYERLISTCTRL_H__3387A6C3_CDDB_44E3_8223_A1FC7D39E6F6__INCLUDED_)
