//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// PlayerListCtrl.cpp : implementation file
//

#include "stdafx.h"
#include "ETBuddies.h"
#include "PlayerListCtrl.h"
#include "ETBuddiesDlg.h"
#include <vector>

using namespace std ;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#define COL_NOM_J		0
#define COL_XP			1
#define COL_PG			2

#define HEADER_NOM_JOUEUR		"Name of player"
#define HEADER_XP_JOUEUR		"XP"
#define HEADER_PING_JOUEUR		"Ping (ms)"



/* Parametre de selection du tri a fournir a la methode trier() */
/*static*/ UINT PlayerListCtrl::TRI_NOM_JOUEUR = 0 ;
/*static*/ UINT PlayerListCtrl::TRI_XP = 1 ;
/*static*/ UINT PlayerListCtrl::TRI_PING = 2 ;



/////////////////////////////////////////////////////////////////////////////
// PlayerListCtrl

PlayerListCtrl::PlayerListCtrl()
{
	this->m_CurrentSortItem = COL_XP ;
	this->m_SortAscending = false ;
}

PlayerListCtrl::~PlayerListCtrl()
{
}


BEGIN_MESSAGE_MAP(PlayerListCtrl, ListCtrl)
	//{{AFX_MSG_MAP(PlayerListCtrl)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		ON_NOTIFY_REFLECT(LVN_COLUMNCLICK, OnColumnclick)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// PlayerListCtrl message handlers
void PlayerListCtrl::setItem (UINT nItem, Joueur * joueur)
{
	CString xp, ping ;
	xp.Format ("%d",	joueur->getXp()) ;
	ping.Format ("%d",	joueur->getPing()) ;

	nItem = this->InsertItem  (nItem,	"") ;
	if (nItem != -1) {
		this->SetItemText (nItem, COL_NOM_J,	joueur->getNomColore()) ;
		this->SetItemText (nItem, COL_XP,		xp) ;
		this->SetItemText (nItem, COL_PG,	ping) ;
		this->SetItemData (nItem, (DWORD)joueur) ;
	}
}

int PlayerListCtrl::SortProc(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort)
{
	Joueur * j1 = (Joueur*)lParam1 ;
	Joueur * j2 = (Joueur*)lParam2 ;

	UINT paramSort = (UINT)lParamSort ;
	int sortMod = 1 ;
	int comp = 0 ;
	if (paramSort >= SORT_DESC) {
		sortMod = -1 ;
		paramSort -= SORT_DESC ;
	}

	switch (paramSort) {
	case COL_NOM_J: 
		comp = j1->getNom().CompareNoCase(j2->getNom()) ;
		break ;
	case COL_XP:
		comp = j1->getXp() - j2->getXp() ;
		break ;
	case COL_PG:
		comp = j1->getPing() - j2->getPing() ;
		break;
	}

	return (sortMod * comp) ;
}

void PlayerListCtrl::OnColumnclick(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	// TODO: Add your control notification handler code here
	
	switch (pNMListView->iSubItem)
	{
	case COL_NOM_J: trier(TRI_NOM_JOUEUR) ; break ;
	case COL_XP:	trier(TRI_XP) ;			break ;
	case COL_PG:	trier(TRI_PING) ;		break ;
	}

	*pResult = 0;
}

/********************************************************
* Tri la liste selon la colonne triColonne				*
* Valeurs possibles pour triColonne :					*
*		- TRI_NOM_JOUEUR								*
*		- TRI_XP										*
*		- TRI_PING										*
********************************************************/
/*virtual*/ void PlayerListCtrl::trier (int triColonne /*= TRI_XP*/)
{
	int sortItem ;
	if (triColonne == TRI_NOM_JOUEUR) {
		sortItem = COL_NOM_J ;
	}
	else if (triColonne == TRI_XP) {
		sortItem = COL_XP ;
	}
	else if (triColonne == TRI_PING) {
		sortItem = COL_PG ;
	}
	else {
		CString erreur ;
		erreur.Format ("PlayerListCtrl::trier () : Numero de colonne invalide(%d)", triColonne) ;
		DEBUG_LOG(erreur) ;
		return ;
	}

	ListCtrl::trier (sortItem, SortProc) ;
}


/*virtual*/ void PlayerListCtrl::initControl (DWORD style /*= LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES*/)
{
	ListCtrl::initControl(style) ;
	this->InsertColumn (COL_NOM_J,	HEADER_NOM_JOUEUR,	LVCFMT_LEFT, 200) ;
	this->InsertColumn (COL_XP,		HEADER_XP_JOUEUR,	LVCFMT_LEFT, 70) ;
	this->InsertColumn (COL_PG,		HEADER_PING_JOUEUR, LVCFMT_LEFT, 70) ;
}

/************************************************************
* Met a jour le tri											*
************************************************************/
/*virtual*/ void PlayerListCtrl::majTri () {
	ListCtrl::majTri (SortProc) ;
}

void PlayerListCtrl::afficheServeur(Server * serveur) 
{
	
	UINT id = 0 ;
	DeleteAllItems () ;
	if (!serveur)		return ;
	/****************************************************
	* Affichage de tous les joueurs						*
	****************************************************/
	CString temp ;
	vector<Joueur *> * listeJoueurs = serveur->getListeJoueurs() ;
	FOR_VECTOR(Joueur*,(*listeJoueurs))
	{
		setItem(id, *i) ;
		id++;
	}
	/* Tri selon XP decroissant */
	majTri() ;
}