// PasswordFile.h: interface for the PasswordFile class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PASSWORDFILE_H__31253A5E_75C1_4F97_816E_1F781F54B85C__INCLUDED_)
#define AFX_PASSWORDFILE_H__31253A5E_75C1_4F97_816E_1F781F54B85C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Objet.h"
#include <map>
#include "server.h"

using namespace std ;

typedef map<CString,CString>		Ip2Pass ;

class PasswordFile : public Objet  
{
	Ip2Pass m_passwords ;
public:
	static CString NOM_CLASSE ;

	PasswordFile();
	virtual ~PasswordFile();

	/* add a server to the list */
	void addServer (Server * server, CString password) ;
	void addServer (CString ipServer, CString password) ;

	
	CString getPassword(Server * server) ;
	CString getPassword(CString ipServer) ;

	/* remove this server from list if exist */
	void removeServer (Server * server) ;
	void removeServer (CString ipServer) ;

	
	virtual void serialize (Fichier * f) throw (Exception) ;
	static Objet * getFromFile (Fichier * f) throw (Exception) ;

	void savePasswords() throw (Exception) ;
	static PasswordFile * loadPasswords() throw (Exception) ;


};

#endif // !defined(AFX_PASSWORDFILE_H__31253A5E_75C1_4F97_816E_1F781F54B85C__INCLUDED_)
