// PasswordFile.cpp: implementation of the PasswordFile class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ETBuddies.h"
#include "PasswordFile.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

#define FICHIER_PASSWORDS		"Serveurs.dat"

/*static*/ CString PasswordFile::NOM_CLASSE = "Passwords" ;


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

PasswordFile::PasswordFile() : Objet(NOM_CLASSE) 
{

}

PasswordFile::~PasswordFile()
{

}


/* add a server to the list */
void PasswordFile::addServer (Server * server, CString password) {
	addServer(server->getIp()->getIpTotal(), password) ;
}
void PasswordFile::addServer (CString ipServer, CString password) {
	removeServer(ipServer) ;
	if (password != "") {
		m_passwords.insert (Ip2Pass::value_type(ipServer, password)) ;
	}
	try {
		savePasswords() ;
	}
	catch (Exception e) {}
}

	
CString PasswordFile::getPassword(Server * server) {
	return (getPassword(server->getIp()->getIpTotal())) ;
}
CString PasswordFile::getPassword(CString ipServer) {
	Ip2Pass::iterator i ;
	bool trouve = false ;
	CString retour = "" ;


	for (i = m_passwords.begin() ; i != m_passwords.end() && !trouve; i++) {
		if (i->first == ipServer) {
			trouve = true ;
			retour = i->second ;
		}
	}

	return (retour) ;
}

/* remove this server from list if exist */
void PasswordFile::removeServer (Server * server) {
	removeServer(server->getIp()->getIpTotal()) ;
}
void PasswordFile::removeServer (CString ipServer) {
	Ip2Pass::iterator i ;
	bool trouve = false ;

	for (i = m_passwords.begin() ; !trouve && i != m_passwords.end() ; i++) {
		if (i->first == ipServer) {
			trouve = true ;
			m_passwords.erase(i) ;
			try {
				savePasswords() ;
			}
			catch (Exception e) {}
			break;
		}
	}
}


/*virtual*/ void PasswordFile::serialize (Fichier * f) throw (Exception) 
{
	Objet::serialize(f) ;

	int nbElem = m_passwords.size() ;
	/* write number of passwords */
	f->Write (&nbElem, 1, sizeof (int)) ;

	Ip2Pass::iterator i ;
	for (i = m_passwords.begin() ; i != m_passwords.end(); i++) 
	{
		f->WriteString(i->first) ;
		f->WriteString(i->second) ;
	}

}
/*static*/ Objet * PasswordFile::getFromFile (Fichier * f) throw (Exception) {
	// verification de la validite du fichier
	delete (Objet::getFromFile(f, NOM_CLASSE)) ;

	PasswordFile * retour = new PasswordFile() ;

	int nbElem = 0 ;
	/* read number of passwords */
	f->Read (&nbElem, 1, sizeof (int)) ;
	if (nbElem < 0)		FICHIER_CORROMPU(f) ;

	CString ip ;
	CString pass ;
	

	/* reads ip adress of every favorite */
	for (int i = 0 ; i < nbElem ; i++) 
	{
		ip = f->ReadString() ;
		pass = f->ReadString() ;
		retour->addServer (ip, pass) ;
	}

	return (retour) ;

}


void PasswordFile::savePasswords() throw (Exception) 
{
	Fichier f (FICHIER_PASSWORDS, Fichier::MODE_WRITE) ;
	serialize (&f) ;
}

/*static*/ PasswordFile * PasswordFile::loadPasswords() throw (Exception) 
{
	Fichier f (FICHIER_PASSWORDS, Fichier::MODE_READ) ;
	return (PasswordFile*)PasswordFile::getFromFile(&f) ;
}