//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// Packet.h: interface for the Packet class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PACKET_H__E5F8095D_C861_431F_9761_12844F637A89__INCLUDED_)
#define AFX_PACKET_H__E5F8095D_C861_431F_9761_12844F637A89__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Exception.h"
#include "Server.h"

class Packet  
{
	BYTE * packet ;
	UINT length ; 
	CString szServeur ;
	/* serveur correspondant au paquet */
	Server * server ;
public:
	// cree un packet
	// serveurFrom = nom du serveur ayant emis ce packet
	Packet(BYTE * packet, int pcktLength, CString serveurFrom, Server * server = NULL) throw (Exception) ;
	virtual ~Packet();


	BYTE * getPacket () ;
	// retourne le nombre d'octets du paquet
	UINT getLength () ;

	CString getServeurIp () ;

	// indique si cette adresse est dans la trame
	bool estDansTrame (BYTE * adr) ;

	// retourne l'adresse de fin de trame
	// cette adresse n'appartient donc pas a la trame
	BYTE * getFinTrame () ;

	void setServer (Server * server) ;
	Server * getServer () {return (this->server);}

};

#endif // !defined(AFX_PACKET_H__E5F8095D_C861_431F_9761_12844F637A89__INCLUDED_)
