//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// Packet.cpp: implementation of the Packet class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ETBuddies.h"
#include "Packet.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Packet::Packet(BYTE * packet, int pcktLength, CString serverFrom, Server * server /*= NULL*/)
{
	if (pcktLength <= 0)							THROW_E("Packet::Packet() : la taille du packet est negative ou nulle!");
#ifdef _DEBUG
	if (strcmp(STR_BUFFER(serverFrom), "") == 0)	THROW_E("Packet::Packet() : le serveur fourni n'est pas valide!");
#endif

	this->szServeur = serverFrom ;
	this->length = pcktLength ;
	this->packet = new BYTE [length] ;
	this->server = server ;
	memcpy (this->packet, packet, length) ;
}

Packet::~Packet()
{
	delete [] this->packet ;
}


BYTE * Packet::getPacket ()
{
	return (this->packet) ;
}

// retourne le nombre d'octets du packet
UINT Packet::getLength ()
{
	return (this->length) ;
}


CString Packet::getServeurIp ()
{
	return (this->szServeur) ;
}

// indique si cette adresse est dans la trame
bool Packet::estDansTrame (BYTE * adr)
{
	return (adr >= this->packet && adr < this->getFinTrame()) ;
}

// retourne l'adresse de fin de trame
// cette adresse n'appartient donc pas a la trame
BYTE * Packet::getFinTrame ()
{
	return (this->packet + this->length) ;
}

void Packet::setServer (Server * server)
{
	this->server = server ;
}