// OptionsET.cpp : implementation file
//

#include "stdafx.h"
#include "ETBuddies.h"
#include "OptionsET.h"
#include "Options.h"
#include "ChargerSauverDlg.h"
#include "ETBuddiesDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// OptionsET property page

IMPLEMENT_DYNCREATE(OptionsET, PageOption)

OptionsET::OptionsET(Options * parent /*= NULL*/) : PageOption(OptionsET::IDD)
{
	//{{AFX_DATA_INIT(OptionsET)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_pParent = parent ;
}

OptionsET::~OptionsET()
{
}

void OptionsET::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(OptionsET)
	DDX_Control(pDX, IDC_ET_ARGS, m_etArgs);
	DDX_Control(pDX, IDC_ET_DIR, m_etDir);
	DDX_Control(pDX, IDC_ETKEY, m_etkey);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(OptionsET, PageOption)
	//{{AFX_MSG_MAP(OptionsET)
	ON_BN_CLICKED(IDC_ETKEY, OnEtkey)
	ON_BN_CLICKED(IDC_BROWSE, OnBrowse)
	ON_EN_CHANGE(IDC_ET_DIR, OnChangeEtDir)
	ON_BN_CLICKED(IDC_DEFAULT_GEN, OnDefaultGen)
	ON_EN_CHANGE(IDC_ET_ARGS, OnChangeEtArgs)
	ON_BN_CLICKED(IDC_ADD, OnAdd)
	ON_BN_CLICKED(IDC_REMOVE, OnRemove)
	ON_BN_CLICKED(IDC_EDIT, OnEdit)
	ON_BN_CLICKED(IDC_CLEAR, OnClear)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// OptionsET message handlers
void OptionsET::initValeurs() {
	m_etkey.SetCheck(m_pParent->getPref()->getDelETkey()) ;
	m_etDir.SetWindowText (MAIN_PREF->getETDirectory()) ;
	m_etArgs.SetWindowText(MAIN_PREF->getETArgs()) ;


}



BOOL OptionsET::OnApply() 
{
	Preferences * pref = m_pParent->getPref() ;
	ASSERT(pref);
	
	CString serveur ;

	try
	{
		pref->setDelETkey(m_etkey.GetCheck()) ;
		CString dir;
		m_etDir.GetWindowText(dir) ;
		pref->setETDirectory (dir) ;
		
		m_etArgs.GetWindowText(dir) ;
		pref->setETArgs(dir) ;

		this->SetModified (false) ;
		return PageOption::OnApply();

	}
	CATCH_EXCEPTION;

	return (FALSE) ;
	
}

void OptionsET::OnEtkey() 
{
	SetModified() ;
	
}

BOOL OptionsET::OnInitDialog() 
{
	PageOption::OnInitDialog();

	
	
	// TODO: Add extra initialization here
	initValeurs() ;



	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void OptionsET::OnBrowse() 
{
	ChargerSauverDlg dlg ;
	CString dir ;
	CString initDir = ".\\" ;

	CString etPath = MAIN_PREF->getETDirectory() ;
	if (etPath != "") 
	{
		int i = etPath.GetLength() - 1 ;
		while (etPath[i] != '\\')		i--;
		
		initDir = etPath.Mid (0, i) ;
	}

	if (dlg.getLoadFile (&dir, initDir, "Executable files (*.exe)\0*.exe\0All files (*.*)\0*.*\0\0")) {
		m_etDir.SetWindowText (dir) ;
	}	
}

void OptionsET::OnChangeEtDir() {
	SetModified () ;
}
void OptionsET::OnChangeEtArgs() {
	SetModified () ;
}


void OptionsET::OnDefaultGen() 
{
	Preferences * pref = m_pParent->getPref() ;
	pref->setDefaultDelETkey() ;
	pref->setDefaultETDirectory() ;
	pref->setDefaultETArgs() ;
	initValeurs() ;
	SetModified(FALSE) ;
}


void OptionsET::OnAdd() 
{
	// TODO: Add your control notification handler code here
	
}

void OptionsET::OnRemove() 
{
	// TODO: Add your control notification handler code here
	
}

void OptionsET::OnEdit() 
{
	// TODO: Add your control notification handler code here
	
}

void OptionsET::OnClear() 
{
	// TODO: Add your control notification handler code here
	
}
