//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#if !defined(AFX_OPTGENERALDLG_H__A4A8BE3E_858C_4869_B9DC_D3BB92D26395__INCLUDED_)
#define AFX_OPTGENERALDLG_H__A4A8BE3E_858C_4869_B9DC_D3BB92D26395__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// OptGeneralDlg.h : header file
//

class Options ;

#include "PageOption.h"
#include "ColorPreview.h"
#include "TypeConnection.h"
#include "Edit.h"

/////////////////////////////////////////////////////////////////////////////
// OptGeneralDlg dialog

class OptGeneralDlg : public PageOption
{
	DECLARE_DYNCREATE(OptGeneralDlg);

	Options * parent ;

	ColorPreview m_gradiant1 ;
	ColorPreview m_gradiant2 ;


// Construction
public:
	OptGeneralDlg(Options * parent = NULL);
	~OptGeneralDlg();

	// initialise les valeurs des case en utilisant les valeurs des preferences
	void initValeurs () ;

	/************************************************************
	* Remet par defaut le AutoStart								*
	************************************************************/
	void setDefaultAutoStart () ;

	/************************************************************
	* Met a jour les preferences concerant l'AutoStart			*
	************************************************************/
	void updateAutoStart () ;

	


// Dialog Data
	//{{AFX_DATA(OptGeneralDlg)
	enum { IDD = IDD_OP_GENERAL };
	CButton	m_startMinimized;
	CButton	m_stayTop;
	TypeConnection	m_connection;
	CButton	m_minClose;
	CButton	m_refreshStart;
	CButton	m_autoStart;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(OptGeneralDlg)
	public:
	virtual BOOL OnApply();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(OptGeneralDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnDefaultGen();
	afx_msg void OnAutostart();
	afx_msg void OnRefreshStart();
	afx_msg void OnMinClose();
	afx_msg void OnGradiant1();
	afx_msg void OnGradiant2();
	afx_msg void OnPaint();
	afx_msg void OnSelchangeConnection();
	afx_msg void OnStayTop();
	afx_msg void OnStartMinimized();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_OPTGENERALDLG_H__A4A8BE3E_858C_4869_B9DC_D3BB92D26395__INCLUDED_)
