//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// OptGeneralDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ETBuddies.h"
#include "ETBuddiesDlg.h"
#include "OptGeneralDlg.h"
#include "Options.h"
#include "Preferences.h"
#include "defines.h"
#include "Atlbase.h"
#include "ChargerSauverDlg.h"


#define MAX_PATH_ET			4096
#define RUN_KEY				"SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run"
#define KEY_NAME			"ETBuddies"
#define PREF				this->parent->getPref()
#define ET_PATH				PREF->getPathExe()



#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// OptGeneralDlg property page

IMPLEMENT_DYNCREATE(OptGeneralDlg, PageOption)

OptGeneralDlg::OptGeneralDlg(Options * parent /*= NULL*/) : PageOption(OptGeneralDlg::IDD)
{
	this->parent = parent ;
	//{{AFX_DATA_INIT(OptGeneralDlg)
	//}}AFX_DATA_INIT
}

OptGeneralDlg::~OptGeneralDlg()
{
}

void OptGeneralDlg::DoDataExchange(CDataExchange* pDX)
{
	PageOption::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(OptGeneralDlg)
	DDX_Control(pDX, IDC_START_MINIMIZED, m_startMinimized);
	DDX_Control(pDX, IDC_STAY_TOP, m_stayTop);
	DDX_Control(pDX, IDC_CONNECTION, m_connection);
	DDX_Control(pDX, IDC_MIN_CLOSE, m_minClose);
	DDX_Control(pDX, IDC_REFRESH_START, m_refreshStart);
	DDX_Control(pDX, IDC_AUTOSTART, m_autoStart);
	DDX_Control(pDX, IDC_GRAD1, m_gradiant1);
	DDX_Control(pDX, IDC_GRAD2, m_gradiant2);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(OptGeneralDlg, PageOption)
	//{{AFX_MSG_MAP(OptGeneralDlg)
	ON_BN_CLICKED(IDC_DEFAULT_GEN, OnDefaultGen)
	ON_BN_CLICKED(IDC_AUTOSTART, OnAutostart)
	ON_BN_CLICKED(IDC_REFRESH_START, OnRefreshStart)
	ON_BN_CLICKED(IDC_MIN_CLOSE, OnMinClose)
	ON_BN_CLICKED(IDC_GRADIANT1, OnGradiant1)
	ON_BN_CLICKED(IDC_GRADIANT2, OnGradiant2)
	ON_WM_PAINT()
	ON_CBN_SELCHANGE(IDC_CONNECTION, OnSelchangeConnection)
	ON_BN_CLICKED(IDC_STAY_TOP, OnStayTop)
	ON_BN_CLICKED(IDC_START_MINIMIZED, OnStartMinimized)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// OptGeneralDlg message handlers

BOOL OptGeneralDlg::OnInitDialog() 
{
	PageOption::OnInitDialog();
	this->initValeurs () ;

	this->toolTip->AddTool(GetDlgItem(IDC_DEFAULT_GEN),		OPT_DEFAULT) ;
	this->m_connection.OnInitDialog() ;


	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void OptGeneralDlg::initValeurs ()
{
	Preferences * pref = MAIN_PREF ;
	ASSERT(pref) ;

	char path[MAX_PATH_ET] ;
	DWORD taille = MAX_PATH_ET ;

	/************************************************************
	* Teste si ETBuddies se lance avec windows					*
	************************************************************/
	CRegKey key ;
	if (key.Open (HKEY_LOCAL_MACHINE,RUN_KEY, KEY_READ) == ERROR_SUCCESS)
	{
		CButton * check = &this->m_autoStart ;
		if (key.QueryValue (path, KEY_NAME, &taille) != ERROR_SUCCESS) {
			check->SetCheck (FALSE) ;
		}
		else {
			check->SetCheck (TRUE) ;
		}
		key.Close() ;
	}
	else {
		this->m_autoStart.EnableWindow (FALSE) ;
	}

	this->m_refreshStart.SetCheck	(PREF->getRefreshAtStart()) ;
	this->m_minClose.SetCheck		(PREF->getMinInsteadClose()) ;
	this->m_gradiant1.SetColor (MAIN_PREF->getGradiant1()) ;
	this->m_gradiant2.SetColor (MAIN_PREF->getGradiant2()) ;
	this->m_connection.SetSelection (MAIN_PREF->getConnection()) ;
	this->m_stayTop.SetCheck (MAIN_PREF->getStayOnTop()) ;
	m_startMinimized.SetCheck(MAIN_PREF->getStartMinimized()) ;

	// TODO: Add extra initialization here
	
}
/*
void OptGeneralDlg::OnChangeRefresh() {
	this->SetModified () ;
}
void OptGeneralDlg::OnChangeBuddiesFic() {
	this->SetModified () ;
}*/

void OptGeneralDlg::OnDefaultGen() 
{
	Preferences * pref = this->parent->getPref() ;
	ASSERT(pref) ;

	pref->setDefaultAtttenteRefresh() ;
	pref->setDefaultGradiant1() ;
	pref->setDefaultGradiant2() ;
	pref->setDefaultConnection() ;
	pref->setDefaultStayOnTop() ;
	pref->setDefaultStartMinimized() ;
	this->initValeurs() ;
	this->SetModified (FALSE) ;
}

BOOL OptGeneralDlg::OnApply() 
{
	// TODO: Add your specialized code here and/or call the base class
	Preferences * pref = this->parent->getPref() ;
	ASSERT(pref);
	
	try
	{
	/*	CString fic ;
		GetDlgItemText (IDC_BUDDIES_FIC, fic) ;
		pref->setFicBuddies (fic) ;
		pref->setTempsAttenteRefresh (GetDlgItemInt (IDC_REFRESH)) ;

		this->SetModified (FALSE) ;
		this->initValeurs () ;*/
		this->updateAutoStart () ;
		pref->setRefreshAtStart (this->m_refreshStart.GetCheck() > 0) ;
		pref->setMinInsteadClose (this->m_minClose.GetCheck() > 0) ;
		pref->setGradiant1 (this->m_gradiant1.GetColor()) ;
		pref->setGradiant2 (this->m_gradiant2.GetColor()) ;
		pref->setStayOnTop (this->m_stayTop.GetCheck() > 0) ;
		pref->setStartMinimized(m_startMinimized.GetCheck() > 0) ;


		UINT con = this->m_connection.GetSelection() ;
		if (con != CB_ERR) {
			pref->setConnection (con) ;
		}

		MAIN_DLG->updateStayOnTop() ;

		return PageOption::OnApply();
	}
	CATCH_EXCEPTION;


	return (FALSE) ;
}


void OptGeneralDlg::OnAutostart() {
	SetModified() ;
}
void OptGeneralDlg::OnRefreshStart() {
	SetModified() ;
}
void OptGeneralDlg::OnMinClose() {
	SetModified() ;
}
void OptGeneralDlg::OnSelchangeConnection() {
	SetModified() ;	
}
void OptGeneralDlg::OnStayTop() {
	SetModified() ;
}
void OptGeneralDlg::OnStartMinimized() {
	SetModified() ;	
}



/************************************************************
* Remet par defaut le AutoStart								*
************************************************************/
void OptGeneralDlg::setDefaultAutoStart ()
{
	CRegKey key ;
	if (key.Open (HKEY_LOCAL_MACHINE,RUN_KEY) == ERROR_SUCCESS)
	{
		key.DeleteValue (KEY_NAME) ;
		key.Close() ;
	}
	else {
		this->m_autoStart.EnableWindow (FALSE) ;
	}
}


/************************************************************
* Met a jour les preferences concerant l'AutoStart			*
************************************************************/
void OptGeneralDlg::updateAutoStart ()
{
	CRegKey key ;
	if (key.Open (HKEY_LOCAL_MACHINE,RUN_KEY) == ERROR_SUCCESS)
	{
		if (this->m_autoStart.GetCheck()) {
			key.SetValue (ET_PATH, KEY_NAME) ;
		}
		else {
			key.DeleteValue (KEY_NAME) ;

		}
		key.Close () ;
	}
	else {
		this->m_autoStart.EnableWindow (FALSE) ;
	}
}

void OptGeneralDlg::OnGradiant1() 
{
	CColorDialog dlg ;
	if (dlg.DoModal() == IDOK) {
		this->m_gradiant1.SetColor (dlg.GetColor()) ;
		this->SetModified () ;
	}
	
}

void OptGeneralDlg::OnGradiant2() 
{
	CColorDialog dlg ;
	if (dlg.DoModal() == IDOK) {
		this->m_gradiant2.SetColor (dlg.GetColor()) ;
		this->SetModified () ;
	}
}




void OptGeneralDlg::OnPaint() {
	CPaintDC dc(this); // device context for painting
}



