//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// OptAdvDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ETBuddies.h"
#include "OptAdvDlg.h"
#include "Preferences.h"
#include "Options.h"
#include "defines.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define OPT_MASTER		_T("The main server for Enemy Territory\r\n")\
						_T("Give all slaves servers")

#define OPT_PROTO		_T("Version of network protocol for Enemy Territory\r\n")\
						_T("Updated with every versions of Enemy Territory")

#define OPT_TO_SLAVE	_T("Time before a slave server will be considered as Timed out")

#define OPT_RETRY		_T("Number of retries on servers lost\n")\
						_T("If you increase this value, you will have better\r\n")\
						_T("results (less lost servers), but it will take much\r\n")\
						_T("time to refresh")

#define OPT_MAX_CONNEC	_T("Maximum number of simultaenous connections to slave servers")
/////////////////////////////////////////////////////////////////////////////
// OptAdvDlg property page

IMPLEMENT_DYNCREATE(OptAdvDlg, PageOption)

OptAdvDlg::OptAdvDlg(Options * parent /*= NULL*/) : PageOption(OptAdvDlg::IDD)
{
	this->parent = parent ;
	//{{AFX_DATA_INIT(OptAdvDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

OptAdvDlg::~OptAdvDlg()
{
}

void OptAdvDlg::DoDataExchange(CDataExchange* pDX)
{
	PageOption::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(OptAdvDlg)
	DDX_Control(pDX, IDC_RETRY, m_NbPasses);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(OptAdvDlg, PageOption)
	//{{AFX_MSG_MAP(OptAdvDlg)
//	ON_EN_CHANGE(IDC_MASTER, OnChangeMaster)
	ON_EN_CHANGE(IDC_MAX_CONNEC, OnChangeMaxConnec)
	ON_EN_CHANGE(IDC_PROTOCOL, OnChangeProtocol)
	ON_EN_CHANGE(IDC_TIMEOUT_SLAVE, OnChangeTimeoutSlave)
	ON_BN_CLICKED(IDC_DEFAULT_ADV, OnDefaultAdv)
	ON_EN_CHANGE(IDC_RETRY, OnChangeRetry)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// OptAdvDlg message handlers

BOOL OptAdvDlg::OnInitDialog() 
{
	PageOption::OnInitDialog();
	
	this->initValeurs () ;
	// TODO: Add extra initialization here
	


	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

/********************************************************
* Initialise les valeurs des case en utilisant les		*
* valeurs des preferences								*
********************************************************/
void OptAdvDlg::initValeurs ()
{
	Preferences * pref = this->parent->getPref() ;
	ASSERT(pref);

	/* initialisation des champs */
//	SetDlgItemText (IDC_MASTER,			pref->getServeurMaitre()) ;
	SetDlgItemInt (IDC_PROTOCOL,		pref->getProtocole()) ;
	SetDlgItemInt (IDC_MAX_CONNEC,		pref->getNbSearchSimul()) ;
	SetDlgItemInt (IDC_TIMEOUT_SLAVE,	pref->getTimeOutSlave()) ;
	SetDlgItemInt (IDC_RETRY,			pref->getNbPasses() - 1) ;

	/* initialisation des tooltips */
//	this->toolTip->AddTool(GetDlgItem(IDC_MASTER),			OPT_MASTER) ;
	this->toolTip->AddTool(GetDlgItem(IDC_PROTOCOL),		OPT_PROTO) ;
	this->toolTip->AddTool(GetDlgItem(IDC_MAX_CONNEC),		OPT_MAX_CONNEC) ;
	this->toolTip->AddTool(GetDlgItem(IDC_TIMEOUT_SLAVE),	OPT_TO_SLAVE) ;
	this->toolTip->AddTool(GetDlgItem(IDC_RETRY),			OPT_RETRY) ;
	this->toolTip->AddTool(GetDlgItem(IDC_DEFAULT_ADV),		OPT_DEFAULT) ;

}
/*
void OptAdvDlg::OnChangeMaster() {	
	this->SetModified() ;
}*/
void OptAdvDlg::OnChangeMaxConnec() {
	this->SetModified() ;
}
void OptAdvDlg::OnChangeProtocol() {
	this->SetModified() ;
}
void OptAdvDlg::OnChangeTimeoutSlave() {
	this->SetModified() ;
}
void OptAdvDlg::OnChangeRetry() {
	this->SetModified() ;
}


void OptAdvDlg::OnDefaultAdv() 
{
	Preferences * pref = this->parent->getPref() ;
	ASSERT(pref);

	pref->setDefaultProto () ;
	pref->setDefaultSearchSimul() ;
	pref->setDefaultServeurMaitre() ;
	pref->setDefaultTimeOutSlave() ;
	pref->setDefaultNbPasses() ;

	this->initValeurs () ;
	this->SetModified (FALSE) ;

}

BOOL OptAdvDlg::OnApply() 
{
	Preferences * pref = this->parent->getPref() ;
	ASSERT(pref);
	
	CString serveur ;

	try
	{
	//	GetDlgItemText (IDC_MASTER, serveur) ;
	//	pref->setServeurMaitre	(serveur) ;
		pref->setNbSearchSimul	(GetDlgItemInt (IDC_MAX_CONNEC)) ;
		pref->setProtocole		(GetDlgItemInt (IDC_PROTOCOL)) ;
		pref->setTimeOutSlave	(GetDlgItemInt (IDC_TIMEOUT_SLAVE)) ;
		pref->setNbPasses		(GetDlgItemInt (IDC_RETRY) + 1) ;

		this->initValeurs () ;
		this->SetModified (false) ;
		return PageOption::OnApply();

	}
	CATCH_EXCEPTION;

	return (FALSE) ;
	
}


BOOL OptAdvDlg::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class
	
	return PageOption::PreTranslateMessage(pMsg);
}
