//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// Objet.h: interface for the Objet class.
//
//////////////////////////////////////////////////////////////////////
#include "fichier.h"
#include "exception.h"
#include <vector>
#include "observer.h"

using namespace std ;

// prochain id du msg : 109

#define FICHIER_CORROMPU(f)		\
	{\
		CString e = "";\
		e.Format ("Fichier corrompu : %s !", f->getNom ()) ;\
		throw (Exception ((CString)e)) ;\
	}

#if !defined(AFX_OBJET_H__B6E7EDE5_6D65_4340_9C2B_32D90E47EFBA__INCLUDED_)
#define AFX_OBJET_H__B6E7EDE5_6D65_4340_9C2B_32D90E47EFBA__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class Objet  
{
private:
	CString nomClasse ;
	// liste des observer de cet objet
	vector<Observer*> observeurs ;

	

public:

	//message delivre par notifier_obs par defaut
	static UINT ON_CHANGE ;

	Objet(CString nomClasse);
	virtual ~Objet();


	virtual void serialize (Fichier * f) throw (Exception) ;
	static Objet * getFromFile (Fichier * f, CString nomClasse) throw (Exception) ;

	CString getNomClasse ()		{return (this->nomClasse);}

	// rajoute un observer a la liste
	virtual void ajouterObserver (Observer * e) ;

	// enleve cet observer de la liste
	void enleverObserver (Observer * e) ;

	// enleve tous les observers
	void enleverObservers () ;

	// notifie a tous les observeurs que l'objet a ete modifi
	void notifierObs (UINT msg = ON_CHANGE, void * param1 = NULL, void * param2 = NULL) ;

	vector<Observer*> * getListeObserver () {return (&this->observeurs);}

};

#endif // !defined(AFX_OBJET_H__B6E7EDE5_6D65_4340_9C2B_32D90E47EFBA__INCLUDED_)
