//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// Objet.cpp: implementation of the Objet class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ETBuddies.h"
#include "Objet.h"
#include "defines.h"
#include <algorithm>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

/*static*/ UINT Objet::ON_CHANGE = 0 ;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Objet::Objet(CString nomClasse)
{
	this->nomClasse = nomClasse ;
}

Objet::~Objet()
{

}

/*virtual*/ void Objet::serialize (Fichier * f) throw (Exception)
{
	int taille = this->nomClasse.GetLength() + 1 ;
	f->Write (&taille, 1, sizeof(int)) ;

	f->Write (this->nomClasse.GetBuffer(taille), taille, sizeof(char)) ;
	this->nomClasse.ReleaseBuffer() ;
}

/*static*/ Objet * Objet::getFromFile (Fichier * f, CString nomClasse) throw (Exception)
{	
	CString nomC ;
	char * nomLu ;
	int taille ;

	// lecture de la taille du nom du buddie
	f->Read (&taille, 1, sizeof(int)) ;
	if (taille <= 0)
	{
		FICHIER_CORROMPU(f) ;
	}

	// lecture du nom
	nomLu = new char [taille] ;
	f->Read (nomLu, taille, sizeof (char)) ;
	nomC = CString (nomLu) ;
	delete (nomLu) ;

	if (nomC.Compare (nomClasse) != 0)
	{
		FICHIER_CORROMPU(f) ;
	}

	return (new Objet(nomC)) ;
}


// rajoute un observer a la liste
void Objet::ajouterObserver (Observer * e)
{
	ASSERT(e);
	this->enleverObserver(e) ;
	this->observeurs.push_back (e) ;
	e->OnChange (this, ON_CHANGE, NULL, NULL) ;
}

// notifie a tous les observeurs que l'objet a ete modifi
void Objet::notifierObs (UINT msg /*= ON_CHANGE*/, void * param1 /*= NULL*/, void * param2 /*= NULL*/)
{
	FOR_VECTOR(Observer*, this->observeurs)
	{
		(*i)->OnChange(this, msg, param1, param2) ;
	}
}

// enleve cet observer de la liste
void Objet::enleverObserver (Observer * e)
{
	VEC_ITER(Observer*,i) ;
	i = find(this->observeurs.begin(), this->observeurs.end(), e) ;
	if (i != this->observeurs.end()) {
		this->observeurs.erase (i) ;
	}
}

// enleve tous les observers
void Objet::enleverObservers ()
{
	this->observeurs.clear() ;
}