// MyComboBox.cpp : implementation file
//

#include "stdafx.h"
#include "ETBuddies.h"
#include "MyComboBox.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define SEL_INT			RGB(194,200,218)
#define SEL_EXT			RGB(10,36,106)
#define BACK_COLOR		RGB(255,255,255)

/////////////////////////////////////////////////////////////////////////////
// MyComboBox

MyComboBox::MyComboBox()
{
}

MyComboBox::~MyComboBox()
{
}


BEGIN_MESSAGE_MAP(MyComboBox, CComboBox)
	//{{AFX_MSG_MAP(MyComboBox)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// MyComboBox message handlers

void MyComboBox::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct) {
	Dessiner(lpDrawItemStruct) ;
}


void MyComboBox::Dessiner (LPDRAWITEMSTRUCT item, bool afficheTexte /*= true*/) 
{
	HDC hDC = item->hDC ;
	CDC * dc = CDC::FromHandle (hDC) ;
	CRect rcItem = item->rcItem ;

	int itemId =item->itemID ; 

	

	
	BOOL bCtrlFocused = ((GetFocus() == this) || (GetStyle() & LVS_SHOWSELALWAYS));
	BOOL bHighlight = item->itemState & ODS_SELECTED ;


	CRect rectC ;
	this->GetClientRect(&rectC) ;
	rectC.left		= rcItem.left ;
	rectC.top		= rcItem.top ;
	rectC.bottom	= rcItem.bottom ;
	dc->FillRect (&rectC, &CBrush(BACK_COLOR)) ;



	LOGFONT f; 
	dc->GetCurrentFont()->GetLogFont (&f) ;

	if (itemId == -1) {
		return ;
	}
	
	
	
	/********************************************************
	* Affichage de l'eventuelle selection					*
	********************************************************/
	if (bHighlight && bCtrlFocused)
	{
		CRect sel(rcItem) ;
		sel.bottom -= 2;
		sel.right -= 2 ;
		
		/* L'item est selectionn */
		CPen pen (PS_SOLID, 1, SEL_EXT) ;
		CPen * old = dc->SelectObject (&pen) ;
		dc->MoveTo (sel.left,	sel.top) ;
		dc->LineTo (sel.right,	sel.top) ;
		dc->LineTo (sel.right,	sel.bottom) ;
		dc->LineTo (sel.left,	sel.bottom) ;
		dc->LineTo (sel.left,	sel.top) ;
		dc->SelectObject (old) ;
		
		sel.DeflateRect (1, 1, 0, 0) ;
		dc->FillRect (&sel, &CBrush(SEL_INT)) ;
		
	}
	
	rcItem.left += 2 ;
	rcItem.top += 1 ;
	

	
	
	/********************************************************
	* Affichage du texte									*
	********************************************************/
	if (afficheTexte) {		
		/* initialisations texte et position */
		CString texte ;
		GetLBText(itemId, texte) ;


		UINT align = DT_LEFT ;	
		dc->SetBkColor(bHighlight && bCtrlFocused ? SEL_INT : BACK_COLOR) ;
		dc->SetTextColor(RGB(0,0,0)) ;
		dc->DrawText(texte, &rcItem, align);
	}

}
