#if !defined(AFX_MAINTREECTRL_H__005BE0B4_6191_4A97_93D5_10A06BE167B4__INCLUDED_)
#define AFX_MAINTREECTRL_H__005BE0B4_6191_4A97_93D5_10A06BE167B4__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// MainTreeCtrl.h : header file
//

#include "Lang.h"
#include "Joueur.h"
#include "Buddie.h"
#include "ListeBuddies.h"
#include "Objet.h"
#include <map>
#include <vector>

using namespace std ;

/////////////////////////////////////////////////////////////////////////////
// MainTreeCtrl window

class NodeBud
{
public:
	/* associated item with this node */
	HTREEITEM m_item ;
	/* true if the node is expanded */
	bool m_isExpanded ;
	/* number of online players that match with this buddy */
	UINT m_nbPlayers ;
	/* constructor */
	NodeBud (HTREEITEM item)	{this->m_item = item; this->m_isExpanded = false; this->m_nbPlayers = 0;}
	/* indicate if this buddy must appear online */
	bool isOnline ()			{return (this->m_nbPlayers > 0);}
} ;

class NodeJoueur
{
public:
	/* associated item with this node */
	HTREEITEM m_item ;
	Joueur * m_pJoueur ;
	NodeJoueur (HTREEITEM item, Joueur * joueur) {this->m_item = item; this->m_pJoueur = joueur;}
} ;


//typedef map<HTREEITEM,Joueur*>		ITEM2JOUEUR ;
typedef map<Buddie*,NodeBud*>		BUDDY2NODE ;


class MainTreeCtrl : public CTreeCtrl, public Observer, public Objet
{
private:
	/* list of images of the tree (on/offline, players) */
	CImageList * m_imageList ;

	/* Online/Offline's items in tree */
	HTREEITEM m_online ;
	HTREEITEM m_offline ;

	/* index des images offline et online */
	int m_imOffline, m_imOnline, m_imTete ;

	/* number of online players */
	int m_nbOnline ;

	/* association between Tree Item and Buddies/Players */
	BUDDY2NODE m_nodes ;
	vector<NodeJoueur*> m_joueurs ;

	/* add a player to the tree */
	HTREEITEM ajouterJoueur (Joueur * j, Buddie * buddy) ;

	/* remove all players from tree */
	void enleverJoueurs () ;

	/* remove this buddy's players */
	void enleverJoueurs (Buddie * bud) ;

	

	/* inverse Online/Offline state of this buddy */
	HTREEITEM swapState (Buddie * bud) ;



// Construction
public:
	/* main constructor */
	MainTreeCtrl();

	/* add a buddy to the tree */
	NodeBud * ajouterBuddy (Buddie * bud) ;

	/* remove this buddy from tree */
	void retirerBuddy (Buddie * bud) ;

	/* initialise tree with this list of buddies */
	void initTree (ListeBuddies * liste) ;

	/* initialise tree aspect */
	void OnInitDialog (ListeBuddies * liste) ;

	/* refresh online/offline players */
	void refreshTree () ;

	virtual void OnChange (Objet * obj, UINT msg, void * param1, void * param2) ;

	/* return item currently under mouse */
	HTREEITEM GetItemUnderMouse () ;

	/* return selected player
	   return NULL if no players are selected */
	Joueur * getJoueurSel () ;

	/* retourne le joueur correspondant a cet item
	   retourne NULL sinon */
	Joueur * getJoueur (HTREEITEM item) ;

	/* return node associated with this item */
	/* return NULL if this item is not a buddy item */
	NodeBud * getNode (HTREEITEM item) ;

	/* return item asociated with this buddy */
	Buddie * getBuddy (HTREEITEM item) ;
	NodeBud * getItem (Buddie * bud) ;

	/* return selected buddy or NULL if no buddies is selected */
	Buddie * getBuddySel () ;

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(MainTreeCtrl)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~MainTreeCtrl();

	// Generated message map functions
protected:
	//{{AFX_MSG(MainTreeCtrl)
	afx_msg void OnItemexpanded(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MAINTREECTRL_H__005BE0B4_6191_4A97_93D5_10A06BE167B4__INCLUDED_)
