//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// MainTreeCtrl.cpp : implementation file
//

#include "stdafx.h"
#include "ETBuddies.h"
#include "ETBuddiesDlg.h"
#include "MainTreeCtrl.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// dimensions des images de la liste
#define IMAGEX			12
#define IMAGEY			12

#define ONLINE			Lang::GetResString(IDS_ONLINE_PLAYERS)
#define OFFLINE			Lang::GetResString(IDS_OFFLINE_PLAYERS)

#define IMAGE_ON_OFF(parent)	((parent) == this->m_offline ? m_imOffline : m_imOnline)
#define UPDATE_TEXT_ON			\
	{\
		CString on = "" ;\
		on.Format (ONLINE, this->m_nbOnline, this->m_nodes.size()) ;\
		this->SetItemText (this->m_online, on) ;\
	}

/////////////////////////////////////////////////////////////////////////////
// MainTreeCtrl

MainTreeCtrl::MainTreeCtrl() : Objet("MainTreeCtrl")
{
	this->m_imageList = new CImageList () ;
	this->m_imageList->Create (IMAGEX, IMAGEY, ILC_COLOR8, 2, 5) ;
	
	CBitmap bonline ;
	CBitmap boffline ;
	CBitmap tete ;
	CBitmap rien  ;

	rien.LoadBitmap		(IDB_RIEN) ;
	bonline.LoadBitmap	(IDB_ONLINE) ;
	boffline.LoadBitmap (IDB_OFFLINE) ;
	tete.LoadBitmap		(IDB_TETE) ;
	
	this->m_imageList->Add (&rien, RGB(0,0,0)) ;
	this->m_imOnline =	this->m_imageList->Add (&bonline, RGB(0,0,0)) ;
	this->m_imOffline = this->m_imageList->Add (&boffline, RGB(0,0,0)) ;
	this->m_imTete =	this->m_imageList->Add (&tete, RGB(0,0,0)) ;

	this->m_nbOnline = 0 ;
}

MainTreeCtrl::~MainTreeCtrl()
{
	EFFACER_LISTE(NodeJoueur,this->m_joueurs);

	/* delete all nodes */
	MAP_ITER(Buddie*,NodeBud*,i);
	NodeBud * aEffacer ;
	i = this->m_nodes.begin() ;
	while (i != this->m_nodes.end())
	{
		aEffacer = i->second ;
		this->m_nodes.erase(i) ;
		delete (aEffacer) ;
		i = this->m_nodes.begin() ;
	}

	delete (this->m_imageList) ;
}


BEGIN_MESSAGE_MAP(MainTreeCtrl, CTreeCtrl)
	//{{AFX_MSG_MAP(MainTreeCtrl)
	ON_NOTIFY_REFLECT(TVN_ITEMEXPANDED, OnItemexpanded)
	ON_WM_KEYUP()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// MainTreeCtrl message handlers
/* initialise tree aspect */
void MainTreeCtrl::OnInitDialog (ListeBuddies * liste)
{
	this->SetImageList (this->m_imageList, TVSIL_STATE) ;
	this->SetItemHeight (16) ;
	this->SetTextColor (RGB(24,46,140)) ;

	liste->ajouterObserver (this) ;
	
	this->DeleteAllItems () ;

	CString on = "" ;
	on.Format (ONLINE, 0, liste->getSize()) ;
	this->m_online = this->InsertItem (on) ;
	this->m_offline = this->InsertItem (OFFLINE) ;


	this->SetItemState (this->m_online, TVIS_BOLD, TVIS_BOLD) ;
	this->SetItemState (this->m_offline, TVIS_BOLD, TVIS_BOLD) ;
	this->initTree (liste) ;
}


/* add a player to the tree */
HTREEITEM MainTreeCtrl::ajouterJoueur (Joueur * j, Buddie * buddy)
{
	HTREEITEM retour = NULL ;

	bool existe = false ;
	NodeBud * node = this->getItem(buddy) ;

	if (node) 
	{
		HTREEITEM parent = node->m_item ;
		
		/* search if this player is already added */
		FOR_VECTOR(NodeJoueur*,this->m_joueurs)
		{
			if ((*i)->m_pJoueur == j && this->GetParentItem((*i)->m_item) == parent) {
				existe = true ;
			}
		}
		/* if not, add this player to the tree */
		if (!existe) 
		{
			if (!node->isOnline()) {
				parent = this->swapState (buddy) ;
			}
			
			retour = this->InsertItem (j->getNom(), m_imTete, m_imTete, parent) ;
			/* change image of this item */
			this->SetItemState (retour, INDEXTOSTATEIMAGEMASK(m_imTete), TVIS_STATEIMAGEMASK ) ;
			/* associate this player with this item */
			this->m_joueurs.push_back (new NodeJoueur (retour, j)) ;
			/* increase number of players */
			node->m_nbPlayers++;
			
			
		}
	}

	return (retour) ;
}

/* remove all players from tree */
void MainTreeCtrl::enleverJoueurs ()
{
	FOR_MAP(Buddie*, NodeBud*, m_nodes) {
		this->enleverJoueurs (i->first) ;
	}
}

/* remove this buddy's players */
void MainTreeCtrl::enleverJoueurs (Buddie * bud)
{
	NodeBud * node = this->getItem (bud) ;
	if (node) 
	{
		/* delete all child item of this buddy */
		FOR_VECTOR(NodeJoueur*,this->m_joueurs) 
		{
			if (this->GetParentItem((*i)->m_item) == node->m_item) {
				node->m_nbPlayers--;
				NodeJoueur * aEffacer = *i ;
				this->DeleteItem ((*i)->m_item) ;
				this->m_joueurs.erase (i) ;
				i--;

				delete (aEffacer) ;
				if (!node->isOnline()) {
					this->swapState (bud) ;
				}
			}
		}
	}
}

/* add a buddy to the tree */
NodeBud * MainTreeCtrl::ajouterBuddy (Buddie * bud)
{
	NodeBud * retour = NULL ;
	/* search if this buddy is already added */
	MAP_ITER(Buddie*, NodeBud*, ancien) ;
	ancien = this->m_nodes.find(bud) ;
	/* if not, add it to tree */
	if (ancien == this->m_nodes.end())
	{
		HTREEITEM itemBud = this->InsertItem (
			bud->getNom(),
			this->m_imOffline,
			this->m_imOffline,
			this->m_offline
			) ;
		/* change image of this item */
		this->SetItemState (itemBud, INDEXTOSTATEIMAGEMASK(m_imOffline), TVIS_STATEIMAGEMASK ) ;

		retour = new NodeBud (itemBud) ;
		this->m_nodes.insert (BUDDY2NODE::value_type(bud, retour)) ;
	}
	else {
		retour = ancien->second ;
	}

	return (retour) ;
}

/* remove this buddy from tree */
void MainTreeCtrl::retirerBuddy (Buddie * bud) 
{
	/* search if this buddy exist on the tree */
	NodeBud * node = this->getItem(bud) ;
	/* if yes, delete it from tree */
	if (node != NULL) {
		this->enleverJoueurs (bud) ;
		this->DeleteItem (node->m_item) ;
		/* remove this buddy from node list */
		this->m_nodes.erase (bud) ;
		delete (node) ;
	//	this->m_nbOnline--;
		UPDATE_TEXT_ON;
	}
}

/* initialise tree with this list of buddies */
void MainTreeCtrl::initTree (ListeBuddies * liste)
{
	for (int i = 0 ; i < liste->getSize() ; i++) {
		this->ajouterBuddy (liste->getBuddie(i)) ;
	}
	this->refreshTree () ;
}


/* refresh online/offline players */
void MainTreeCtrl::refreshTree ()
{
	this->enleverJoueurs() ;
	/* parcours de la liste des buddies */
	FOR_MAP(Buddie*,NodeBud*,this->m_nodes) 
	{
		/* add all players matching this buddy */
		bool connecte = false ;
		vector<Joueur*> listeJoueurs = i->first->getJoueurs () ;
		FOR_VECTOR_IND(Joueur*, listeJoueurs, j)
		{
			connecte = true ;
			this->ajouterJoueur (*j, i->first) ;
		}
		/* expand tree if it was expanded before erasing */
		if (connecte && i->second->m_isExpanded) {
			this->Expand(i->second->m_item, TVE_EXPAND) ;
		}
		
	}
}

/*virtual*/ void MainTreeCtrl::OnChange (Objet * obj, UINT msg, void * param1, void * param2)
{

	if (msg == ListeBuddies::ON_ADD_BUD && param1 != NULL) {
			this->ajouterBuddy ((Buddie*)param1) ;
			this->refreshTree() ;
			UPDATE_TEXT_ON;
	}
	else if (msg == ListeBuddies::ON_DEL_BUD && param1 != NULL) {
		this->retirerBuddy ((Buddie*)param1) ;
		UPDATE_TEXT_ON;
	}
	else if (msg == ClientMaster::ON_REFRESH_UN_SERVER) {
		this->refreshTree() ;
	}
}


/* returns buddy asociated with this item */
Buddie * MainTreeCtrl::getBuddy (HTREEITEM item)
{
	Buddie * retour = NULL ;
	FOR_MAP(Buddie*, NodeBud*, this->m_nodes)
	{
		if (i->second->m_item == item) {
			retour = i->first ;
		}
	}
	return (retour) ;
}

/* return item associated with this buddy */
NodeBud * MainTreeCtrl::getItem (Buddie * bud)
{
	NodeBud * retour = NULL ;

	MAP_ITER(Buddie*, NodeBud*, i) ;
	i = this->m_nodes.find(bud) ;
	if (i != this->m_nodes.end()) {
		retour = i->second ;
	}

	return (retour) ;
}

/* inverse Online/Offline state of this buddy */
HTREEITEM MainTreeCtrl::swapState (Buddie * bud) 
{
	HTREEITEM retour = NULL ;

	NodeBud * node = this->getItem (bud) ;
	ASSERT(node && !node->isOnline()) ;
	if (node) 
	{
		HTREEITEM parent = this->GetParentItem(node->m_item) ;
		/* remove from tree */
		this->DeleteItem (node->m_item) ;
		/* add it under online or offline */
		parent = (parent == this->m_offline ? this->m_online : this->m_offline) ;
		node->m_item = this->InsertItem (
			bud->getNom(),
			IMAGE_ON_OFF(parent),
			IMAGE_ON_OFF(parent),
			parent
			) ;
		/* change image of this item */
		this->SetItemState (node->m_item, INDEXTOSTATEIMAGEMASK(IMAGE_ON_OFF(parent)), TVIS_STATEIMAGEMASK ) ;

		/* update number of online players */
		if (parent == this->m_online) {
			this->m_nbOnline++ ;
		}
		else {
			this->m_nbOnline-- ;
		}

		UPDATE_TEXT_ON;

		retour = node->m_item ;

	}

	return (retour) ;
}

void MainTreeCtrl::OnItemexpanded(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;
	// TODO: Add your control notification handler code here
	
	NodeBud * node = this->getNode (pNMTreeView->itemNew.hItem) ;
	if (node) {
		node->m_isExpanded = (pNMTreeView->itemNew.state & TVIS_EXPANDED) > 0  ;
	}
	
	*pResult = 0;
}


/* return item currently under mouse */
HTREEITEM MainTreeCtrl::GetItemUnderMouse ()
{
	HTREEITEM retour = NULL ;

	/* get mouse coordinates */
	CPoint pt;
	::GetCursorPos(&pt);
	this->ScreenToClient(&pt);
	TVHITTESTINFO hit, subhit;
	hit.pt = pt;
	subhit.pt = pt;

	/* check if there is an item under it */
	HTREEITEM sel = this->HitTest(&hit);
	if (sel != NULL && (hit.flags & TVHT_ONITEM)) {
		retour = sel;
	}

	return (retour) ;
}

/* return selected player
   return NULL if no players are selected */
Joueur * MainTreeCtrl::getJoueurSel () {
	return (this->getJoueur(this->GetSelectedItem())) ;
}

/* retourne le joueur correspondant a cet item
   retourne NULL sinon */
Joueur * MainTreeCtrl::getJoueur (HTREEITEM item)
{
	Joueur * retour = NULL ;

	FOR_VECTOR_COND(NodeJoueur*,this->m_joueurs,!retour) 
	{
		if ((*i)->m_item == item) {
			retour = (*i)->m_pJoueur ;
		}
	}

	return (retour) ;
}

/* return node associated with this item */
/* return NULL if this item is not a buddy item */
NodeBud * MainTreeCtrl::getNode (HTREEITEM item)
{
	NodeBud * retour = NULL ;

	Buddie * bud = this->getBuddy (item) ;
	if (bud) {
		retour = this->getItem(bud) ;
	}

	return (retour) ;
}

/* return selected buddy or NULL if no buddies is selected */
Buddie * MainTreeCtrl::getBuddySel () {
	return (this->getBuddy(this->GetSelectedItem())) ;
}

void MainTreeCtrl::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default
	if (nChar == VK_DELETE)	{
		MAIN_DLG->Suppr() ;
	}
	CTreeCtrl::OnKeyUp(nChar, nRepCnt, nFlags);
}
