//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// MainImage.cpp: implementation of the MainImage class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ETBuddies.h"
#include "MainImage.h"
#include "defines.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


static Partie listeParties[] = {	Partie (MAIN_NO,	CRect(0,	0,		174,	150)),
									Partie (MAIN_N,		CRect(175,	0,		176,	150)),
									Partie (MAIN_NE,	CRect(177,	0,		207,	150)),
									Partie (MAIN_O,		CRect(0,	151,	174,	152)),
									Partie (MAIN_C,		CRect(175,	151,	176,	152)),
									Partie (MAIN_E,		CRect(177,	151,	207,	152)),
									Partie (MAIN_SO,	CRect(0,	153,	174,	303)),
									Partie (MAIN_S,		CRect(175,	153,	176,	303)),
									Partie (MAIN_SE,	CRect(177,	153,	207,	303)),
									Partie (FIN,		NULL)
} ;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

MainImage::MainImage(CString nom) : Image(nom) 
{

}

MainImage::~MainImage()
{
}

// affiche la fenetre main a la position (x,y)
// et au dimensions cx, cy
// leve une Exception en cas d'erreur d'affichage
/*virtual*/ void MainImage::afficher (CDC * dc, int x, int y, int cx, int cy) throw (Exception)
{
	CRect * positions = new CRect [TAILLE_LISTE(listeParties)] ;
	for (int i = 0 ; i < TAILLE_LISTE(listeParties) ; i++)
	{
		positions[i] = getCoord(i) ;
	}

	// largeur des images N, C et S
	UINT deformX = cx - positions[MAIN_NO].Width() - positions[MAIN_NE].Width() ;
	// hauteur des image O, C et E
	UINT deformY = cy - positions[MAIN_NO].Height() - positions[MAIN_SO].Height() ;

	// debut x des images NE, E et SE
	UINT debutX = x + cx - positions[MAIN_NE].Width() ;
	// debut y des images SO, S et SE
	UINT debutY = y + cy - positions[MAIN_SO].Height() ;

	/************************************************************************
	* partie superieure du skin												*
	************************************************************************/
	Image::afficher (dc,
		positions[MAIN_NO],
		x,
		y) ;

	Image::afficher (dc,
		positions[MAIN_N],
		x + positions[MAIN_NO].Width(),
		y,
		deformX,
		positions[MAIN_N].Height()) ;

	Image::afficher (dc,
		positions[MAIN_NE],
		debutX,
		y) ;


	/************************************************************************
	* partie mediane du skin												*
	************************************************************************/
	Image::afficher  (dc,
		positions[MAIN_O],
		x,
		y + positions[MAIN_NO].Height(),
		positions[MAIN_O].Width(),
		deformY) ;

	Image::afficher  (dc,
		positions[MAIN_C],
		x + positions[MAIN_NO].Width(),
		y + positions[MAIN_NO].Height(),
		deformX,
		deformY) ;

	Image::afficher  (dc,
		positions[MAIN_E],
		debutX,
		y + positions[MAIN_NO].Height(),
		positions[MAIN_E].Width(), 
		deformY) ;


	/************************************************************************
	* partie basse du skin													*
	************************************************************************/
	Image::afficher  (dc,
		positions[MAIN_SO],
		x,
		debutY) ;

	Image::afficher  (dc,
		positions[MAIN_S],
		x + positions[MAIN_SO].Width(),
		debutY,
		deformX,
		positions[MAIN_S].Height()) ;

	Image::afficher  (dc,
		positions[MAIN_SE],
		debutX,
		debutY) ;


	delete [] positions ;
}


CRect MainImage::getCoord (UINT pos)
{
	CRect retour ;
	int i = 0 ;
	while (listeParties[i].pos != FIN && listeParties[i].pos != pos)	i++;

	if (listeParties[i].pos != FIN)
	{
		retour = listeParties[i].coordonnees ;
	}

	return (retour) ;

}