//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "stdafx.h"
#include "log.h"

// cree un log de nom nom
Log::Log (CString nom)
{
	this->estOuvert = false ;
	this->f = fopen (nom, "at") ;
	if (this->f != NULL)
	{
		this->estOuvert = true ;
	}
}

Log::~Log()
{
	if (this->estOuvert) fclose (f) ;
}

// ajoute une ligne au log
void Log::ajouterLigne (CString ligne)
{
	SYSTEMTIME st ;
	GetLocalTime (&st) ;
	if (this->estOuvert)
	{
		fprintf (f, "%02d/%02d/%04d - %02d:%02d - %s\n",st.wDay, st.wMonth, st.wYear, st.wHour, st.wMinute, ligne.GetBuffer(ligne.GetLength())) ;
		ligne.ReleaseBuffer () ;
		fflush (f) ;
	}
}
