// ListeSeverDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ETBuddies.h"
#include "ListeSeverDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// ListeSeverDlg dialog


ListeSeverDlg::ListeSeverDlg(CWnd* pParent /*=NULL*/)
	: CDialog(ListeSeverDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(ListeSeverDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	this->listeCtrl = new CListCtrl () ;
}

ListeSeverDlg::~ListeSeverDlg ()
{
	delete (this->listeCtrl) ;
}


void ListeSeverDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(ListeSeverDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_SERVERS, *this->listeCtrl);
}


BEGIN_MESSAGE_MAP(ListeSeverDlg, CDialog)
	//{{AFX_MSG_MAP(ListeSeverDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// ListeSeverDlg message handlers

int ListeSeverDlg::DoModal(ClientMaster * maitre) 
{
	// TODO: Add your specialized code here and/or call the base class
	this->maitre = maitre ;
	return CDialog::DoModal();
}

BOOL ListeSeverDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	

	this->listeCtrl->InsertColumn (0, "Ip", LVCFMT_LEFT, 100) ;
	this->listeCtrl->InsertColumn (1, "Name", LVCFMT_LEFT, 200) ;
	this->listeCtrl->InsertColumn (2, "Number of players ", LVCFMT_LEFT, 50) ;
	this->listeCtrl->InsertColumn (3, "Max players", LVCFMT_LEFT, 50) ;
	this->listeCtrl->InsertColumn (4, "Map name", LVCFMT_LEFT, 100) ;

	if (this->maitre)
	{
		map<CString, Server*> * liste = this->maitre->getListeServeurs() ;
		
		
		UINT lastPos = 0 ;
		UINT nbNonVides = 0 ;
		UINT nbPertes = 0 ;

		MAP_ITER(CString,Server*, i) ;
		for (i = liste->begin() ; i != liste->end() ; i++)
		{
			CString texte ;
			
			this->listeCtrl->InsertItem (lastPos, i->second->getIp()->getIpTotal()) ;
			this->listeCtrl->SetItemText (lastPos, 1, i->second->getNom()) ;
			
			if (i->second->getNom() == "")	nbPertes++ ;
			
			UINT nbJoueurs = i->second->getNbJoueurs() ;
			texte.Format ("%d", nbJoueurs) ;
			this->listeCtrl->SetItemText (lastPos, 2, texte) ;
			
			texte.Format ("%d", i->second->getMaxJoueurs()) ;
			this->listeCtrl->SetItemText (lastPos, 3, texte) ;
			
			this->listeCtrl->SetItemText (lastPos, 4, i->second->getNomMap()) ;
			lastPos++;
			
			if (nbJoueurs != 0)		nbNonVides++;
		}
		
		CString total ;
		total.Format ("Total : %d servers", liste->size()) ;
		SetDlgItemText (IDC_TOTAL, total) ;
		
		CString nonVide ;
		nonVide.Format ("Servers not empty : %d", nbNonVides) ;
		SetDlgItemText(IDC_NONVIDES, nonVide) ;
		
		CString perte ;
		perte.Format ("Servers not refreshed : %d", nbPertes) ;
		SetDlgItemText(IDC_PERTES, perte) ;
	}
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
