// ListeBuddiesCtrl.cpp: implementation of the ListeBuddiesCtrl class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ETBuddies.h"
#include "ListeBuddiesCtrl.h"
//#include "ETBuddiesDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

ListeBuddiesCtrl::ListeBuddiesCtrl(CListCtrl * liste/*, CETBuddiesDlg * parent*/)
{
	this->liste = liste ;
	this->liste->InsertColumn (0, "Nom", LVCFMT_LEFT, 100) ;
	this->liste->InsertColumn (1, "Serveur", LVCFMT_LEFT, 200) ;
	this->recherche = new RechercheIp () ;
}

ListeBuddiesCtrl::~ListeBuddiesCtrl()
{
	delete (this->recherche) ;
}

// met a jour la liste
void ListeBuddiesCtrl::refresh (ListeBuddies * listeBud)
{
	this->liste->DeleteAllItems () ;
	for (int i = 0 ; i < listeBud->getSize() ; i++)
	{
		
		this->liste->InsertItem (i, listeBud->getBuddie(i)->getNom()) ;
		this->liste->SetItemText (i, 1, "") ;
	}
}

// renvoie le nom selectionn
// renvoie "" si aucun nom n'est selectionn
CString ListeBuddiesCtrl::getSel ()
{
	CString retour = "" ;
	int sel = this->liste->GetSelectionMark () ;
	if (sel != -1)
	{
		retour = this->liste->GetItemText (sel, 0) ;
	}

	return (retour) ;
}

// retourne l'ip du joueur selectionn
// retourne NULL s'il n'y a pas d'IP
Ip * ListeBuddiesCtrl::getIpSel ()
{
	Ip * retour = NULL ;
	int sel = this->liste->GetSelectionMark () ;
	if (sel != -1)
	{
		CString ip = this->liste->GetItemText (sel, 1) ;
		if (ip.Compare ("-") != 0 && ip.Compare ("") != 0)
		{
			retour = new Ip (ip) ;
		}
	}

	return (retour) ;
}

// actualise la liste en se connectant au server
void ListeBuddiesCtrl::actualiser ()
{
	int nbItem = this->liste->GetItemCount() ;
	for (int i = 0 ; i < nbItem ; i++)
	{
		this->liste->SetItemText (i, 1, "Attente...") ;
	}
	
	try
	{
		for (i = 0 ; i < nbItem ; i++)
		{
			
			Ip * ip = this->recherche->rechercherIp (this->liste->GetItemText (i, 0)) ;
			if (ip)
			{
				this->liste->SetItemText (i, 1, ip->getIp()) ;
				delete (ip) ;
			}
			else
			{
				this->liste->SetItemText (i, 1, "-") ;
			}
		}
		
	}
	catch (Exception e)
	{
		MessageBox (AfxGetMainWnd()->m_hWnd, e.getMessage(), "Erreur recherche", MB_ICONERROR) ;
	}
}

