//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// ListeBuddies.h: interface for the ListeBuddies class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_LISTEBUDDIES_H__8FB24C92_F449_4481_8077_2B7AEAB6BC57__INCLUDED_)
#define AFX_LISTEBUDDIES_H__8FB24C92_F449_4481_8077_2B7AEAB6BC57__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Objet.h"
#include <vector>
#include "Buddie.h"
#include "Observer.h"
#include "ClientMaster.h"

using namespace std ;

class ListeBuddies : public Objet, Observer  
{
private:
	vector<Buddie*> liste ;
	bool erase ;

	ClientMaster * masterET ;

//	RechercheIp * recherche ;
	//QStatUtil * qs ;

	// nombre de buddies actualiss par la fonction actualiserJoueurs
	// utilis par notifierObs (ON_PROGRESS_RECHERCHE, &progression)
	int progression ;

	// efface la liste
	void effacerListe () ;

	// actualise a partir des donnes en cache ds le QStatUtil
	void actualiserFromCache () ;
public:
	
	// messages delivres par notifierObs
	static UINT ON_ADD_BUD ;
	static UINT ON_DEL_BUD ;
	static UINT ON_PROGRESS_RECHERCHE ;
	static UINT ON_CACHE_REFRESH ;


	// nom de cette classe (ListeBuddies)
	static CString NOM_CLASSE ;

	// cree une liste de buddies
	// autoErase indique si la liste doit effacer tous les buddies lors de l'appel du destructeur
	ListeBuddies(bool autoErase = true);
	virtual ~ListeBuddies();

	// ajoute un buddie a la liste
	// leve une exception si le buddie est deja present
	void ajouterBuddie (Buddie * bud) throw (Exception) ;


	// sauvegarde la liste dans un fichier
	virtual void serialize (Fichier * f) throw (Exception) ;

	// cree une nouvelle liste a partir du fichier
	static Objet * getFromFile (Fichier * f) throw (Exception) ;

	// retourne le nombre de buddies de la liste
	int getSize ()		{return (this->liste.size());}

	// retourne le nieme Buddie de la liste
	// leve une exception si n < 0 ou n >= getSize ()
	Buddie * getBuddie (int n) ;

	// enleve le buddie de nom 'nom'
	// leve une exception s'il n'est pas present dans la liste
	void enleverBuddie (CString nom) throw (Exception) ;

	// enleve le buddie de nom 'nom'
	// leve une exception s'il n'est pas present dans la liste
	void enleverBuddie (Buddie * bud) throw (Exception) ;

	// retourne le buddie ayant ce nom
	// retourne NULL s'il n'est pas present dans la liste
	Buddie * getBuddie (CString nom) ;

	// actualise la liste des joueurs Online/Offline
	void actualiserJoueurs () throw (Exception) ;
	// stop l'actualisation des joueurs
	void stopperActualisation () ;

	// actualise partiellement
	void actualiserPartiellement () ;

	virtual void OnChange (Objet * obj, UINT msg, void * param1, void * param2) ;

	void OnProgress (UINT nbServeurs, UINT nbTotalServeurs) ;

	// renvoie le server maitre
	ClientMaster * getClientMaitre () {return (this->masterET);}

	void saveList() throw (Exception) ;
	static ListeBuddies * loadList() throw (Exception) ;


};

#endif // !defined(AFX_LISTEBUDDIES_H__8FB24C92_F449_4481_8077_2B7AEAB6BC57__INCLUDED_)
