//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// ListeBuddies.cpp: implementation of the ListeBuddies class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ETBuddies.h"
#include "ListeBuddies.h"
#include "defines.h"
#include <algorithm>
#include "ClientMasterWolf.h"
#include <process.h>
#include "ETBuddiesDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//#define NOMCLASSE		"ListeBuddies"

/*static*/ UINT ListeBuddies::ON_ADD_BUD = 1 ;
/*static*/ UINT ListeBuddies::ON_DEL_BUD = 2 ;
/*static*/ UINT ListeBuddies::ON_PROGRESS_RECHERCHE = 3 ;
/*static*/ UINT ListeBuddies::ON_CACHE_REFRESH = 40 ;

// nom de cette classe (ListeBuddies)
/*static*/ CString ListeBuddies::NOM_CLASSE = "ListeBuddies" ;

#define FICHIER_BUDDIES			"Buddies.dat"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

ListeBuddies::ListeBuddies(bool autoErase /*= true*/) : Objet(NOM_CLASSE)
{
	this->erase = autoErase ;
	this->masterET = new ClientMasterWolf (ClientMasterWolf::GAME_ET) ;
}

ListeBuddies::~ListeBuddies()
{
	if (this->erase)	this->effacerListe() ;
	if (this->masterET)	delete (this->masterET) ;
}

// efface la liste
void ListeBuddies::effacerListe () 
{
	EFFACER_LISTE(Buddie,this->liste) ;
	this->notifierObs () ;
}

void ListeBuddies::ajouterBuddie (Buddie * bud) throw (Exception)
{
	if (this->getBuddie(bud->getNom()) != NULL)
	{
		CString e = "" ;
		e.Format ("Buddy \"%s\" has already been added!", bud->getNom()) ;
		if (erase)	delete (bud) ;
		throw (Exception ((CString)e)) ;
	}

	if (this->masterET) {
		bud->setServeurs (this->masterET->rechercherIp (bud->getNom())) ;
		this->notifierObs (ON_CHANGE) ;
	}

	this->liste.push_back (bud) ;
	this->notifierObs (ON_ADD_BUD, (void*)bud) ;
	try {
		saveList() ;
	}
	catch (Exception e) {}
}

// enleve le buddie de nom 'nom'
// leve une exception s'il n'est pas present dans la liste
void ListeBuddies::enleverBuddie (CString nom) throw (Exception) {
	this->enleverBuddie(this->getBuddie (nom)) ;
}

// enleve le buddie de nom 'nom'
// leve une exception s'il n'est pas present dans la liste
void ListeBuddies::enleverBuddie (Buddie * bud) throw (Exception)
{
	if (!bud) {
	/*	CString e = "" ;
		e.Format ("Le buddie \"%s\" n'existe pas dans la liste", nom) ;
		throw (Exception ((CString)e)) ;*/
		return ;
	}

	vector<Buddie*>::iterator i = find (this->liste.begin(), this->liste.end(), bud) ;
	if (i == this->liste.end())
	{
		CString e = "" ;
		e.Format ("Couldn't find this buddy(%s) in ListeBuddies::enleverBuddie()", bud->getNom()) ;
		throw (Exception ((CString)e)) ;
	}
	this->liste.erase (i) ;
	this->notifierObs (ON_DEL_BUD,(void*)bud) ;
	delete (bud) ;

	try {
		saveList() ;
	}
	catch (Exception e) {}
}

Buddie * ListeBuddies::getBuddie (CString nom)
{
	Buddie * retour = NULL ;
	FOR_VECTOR(Buddie*, this->liste)
	{
		if ((*i)->getNom().CompareNoCase(nom) == 0)
		{
			retour = *i ;
		}
	}

	return (retour) ;
}

// sauvegarde la liste dans un fichier
/*virtual*/ void ListeBuddies::serialize (Fichier * f) throw (Exception)
{
	Objet::serialize (f) ;


	// nb d'elements de la liste
	int nbElem = this->liste.size() ;
	f->Write (&nbElem, 1, sizeof (int)) ;

	FOR_VECTOR(Buddie*, this->liste)
	{
		(*i)->serialize (f) ;
	}
}

// cree une nouvelle liste a partir du fichier
/*static*/ Objet * ListeBuddies::getFromFile (Fichier * f) throw (Exception)
{
	ListeBuddies * retour = new ListeBuddies () ;

	// verification de la validite du fichier
	delete (Objet::getFromFile(f, NOM_CLASSE)) ;


	int nbElem = 0 ;
	f->Read (&nbElem, 1, sizeof (int)) ;
	if (nbElem < 0)		FICHIER_CORROMPU(f) ;

	for (int i = 0 ; i < nbElem ; i++)
	{
		retour->ajouterBuddie ((Buddie*)Buddie::getFromFile(f)) ;
	}

	return (retour) ;

}

// retourne le nieme Buddie de la liste
// leve une exception si n < 0 ou n >= getSize ()
Buddie * ListeBuddies::getBuddie (int n)
{
	Buddie * retour = NULL ;
	int enCours = 0 ;

	if (n < 0 || n >= this->getSize())
	{
		throw (Exception ("Utilisation incorrecte de ListeBuddies::getBuddie (n)")) ;
	}

	FOR_VECTOR(Buddie*, this->liste)
	{
		if (enCours == n)		retour = *i ;
		enCours++ ;
	}

	return (retour) ;
}
// actualise la liste des joueurs Online/Offline
void ListeBuddies::actualiserJoueurs ()
{
//	if (this->masterET)		delete (this->masterET) ;
	if (!this->masterET) {
		this->masterET = new ClientMasterWolf (ClientMasterWolf::GAME_ET) ;
	}
/*	else {
		this->masterET->enleverObservers() ;
	}*/
	this->masterET->ajouterObserver (this) ;
	this->masterET->litInfos () ;
}

// stop l'actualisation des joueurs
void ListeBuddies::stopperActualisation ()
{
	if (this->masterET)	{
		this->masterET->stopperRecherche() ;
	}
}

// actualise partiellement
void ListeBuddies::actualiserPartiellement ()
{
}

/*virtual*/ void ListeBuddies::OnChange (Objet * obj, UINT msg, void * param1, void * param2)
{
	if (obj == this->masterET)
	{
		if (msg == ClientMaster::ON_REFRESH_COMPLETE)
		{
			this->actualiserFromCache () ;
			int pos = 0 ;
			this->notifierObs (ON_PROGRESS_RECHERCHE, &pos) ;
		}
		else if (msg == ClientMaster::ON_SERVER_DELETE)
		{
			// tous les serveurs on t effacs, on les enleve des buddies
			FOR_VECTOR(Buddie*,this->liste)		(*i)->setServeurs (NULL) ;
		}
		else if (msg == ClientMaster::ON_REFRESH_PARTIEL)
		{
			ASSERT(param1 && param2);
			UINT nbServ = *((UINT*)param1) ;
			UINT total = *((UINT*)param2) ;

			this->OnProgress (nbServ, total) ;
		}
	}
}

// actualise a partir des donnes en cache ds le QStatUtil
void ListeBuddies::actualiserFromCache ()
{
	int j = 0 ;
	FOR_VECTOR(Buddie*,this->liste)
	{
		(*i)->setServeurs (this->masterET->rechercherIp ((*i)->getNom())) ;
		j++ ;
		this->progression = j * 100 / liste.size() ;
	}
	this->notifierObs (ON_CACHE_REFRESH) ;
}

void ListeBuddies::OnProgress (UINT nbServeurs, UINT nbTotalServeurs)
{
	if (nbTotalServeurs != 0) {
		this->progression = nbServeurs * 100 / nbTotalServeurs ;
	}
	else {
		this->progression = 0 ;
	}

	this->notifierObs (ON_PROGRESS_RECHERCHE, &progression) ;
	
}



void ListeBuddies::saveList() throw (Exception) 
{
	Fichier f (FICHIER_BUDDIES, Fichier::MODE_WRITE) ;
	serialize (&f) ;
}

/*static*/ ListeBuddies * ListeBuddies::loadList() throw (Exception) 
{
	Fichier f (FICHIER_BUDDIES, Fichier::MODE_READ) ;
	return (ListeBuddies*)ListeBuddies::getFromFile(&f) ;
}