// ListServerCtrl.cpp : implementation file
//

#include "stdafx.h"
#include "ETBuddies.h"
#include "ListServerCtrl.h"
#include "TexteColore.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define SEL_INT			RGB(194,200,218)
#define SEL_EXT			RGB(10,36,106)

#define TEXTE_DEFAUT	RGB(0,0,0)

#define BACK_COLOR		RGB(255,255,255)
		

/////////////////////////////////////////////////////////////////////////////
// ListServerCtrl

ListServerCtrl::ListServerCtrl()
{
	this->nbColonnes = 0 ;
	this->colIp = -1 ;
	this->colNom = -1 ;
}

ListServerCtrl::~ListServerCtrl()
{
}


BEGIN_MESSAGE_MAP(ListServerCtrl, CListCtrl)
	//{{AFX_MSG_MAP(ListServerCtrl)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// ListServerCtrl message handlers
void ListServerCtrl::DrawItem(LPDRAWITEMSTRUCT item)
{

	ListCtrl::Dessiner(item/*, false*/) ;
	HDC hDC = item->hDC ;
	CDC * dc = CDC::FromHandle (hDC) ;
	CRect rcItem = item->rcItem ;
	



	if (item->itemID != -1 && this->nbColonnes > 0) 
	{
		CRect rect = CRect(0,0,0,0) ;
		rect.top = item->rcItem.top ;
		rect.bottom = item->rcItem.bottom ;

		/********************************************************
		* Affichage de l'eventuelle selection					*
		********************************************************/
		if (item->itemState & ODS_SELECTED)
		{
			CRect sel(rcItem) ;
			sel.bottom -= 2;
			sel.right -= 2 ;

			/* L'item est selectionn */
			CPen pen (PS_SOLID, 1, SEL_EXT) ;
			CPen * old = dc->SelectObject (&pen) ;
			dc->MoveTo (sel.left,	sel.top) ;
			dc->LineTo (sel.right,	sel.top) ;
			dc->LineTo (sel.right,	sel.bottom) ;
			dc->LineTo (sel.left,	sel.bottom) ;
			dc->LineTo (sel.left,	sel.top) ;
			dc->SelectObject (old) ;

			sel.DeflateRect (1, 1, 0, 0) ;
			dc->FillRect (&sel, &CBrush(SEL_INT)) ;

		}

		/********************************************************
		* Affichage du texte de chaque colonne					*
		********************************************************/
		for (int i = 0 ; i < this->nbColonnes ; i++)
		{
			this->SetTextColor (TEXTE_DEFAUT) ;
			CString texte = this->GetItemText (item->itemID, i) ;
			ASSERT(this->maitre) ;
			int taille = this->GetColumnWidth (i) ;
			if (rect.left + taille < item->rcItem.right) {
				rect.right = rect.left + taille - 10 ;
			}
			else {
				rect.right = item->rcItem.right ;
			}
			


			if (i == this->colNom && this->maitre != NULL) 
			{
				CRect r(rect) ;
				CString ip = this->GetItemText (item->itemID, this->colIp) ;
				Server * s = this->maitre->getServer (STR_BUFFER(ip)) ;
				for (int j = 0 ; j < texte.GetLength() ; j++)
				{
					CString car = texte[j] ;
					COLORREF oldC = dc->SetTextColor (TexteColore::GetCouleurCar (s->getNomColore(), j)) ;
					dc->DrawText (STR_BUFFER(car), &r, DT_LEFT) ;
					r.left += dc->GetTextExtent(car).cx ;
					dc->SetTextColor (oldC) ;
				}
				
			}

			/*************************************************/
			else {
				dc->DrawText (STR_BUFFER(texte), -1, &rect, DT_LEFT) ;
			}

			rect.left += taille ;
		}		
	}

}

/*virtual*/ void ListServerCtrl::initControl (int nbColonnes, int colIp, int colNom,  ClientMaster * maitre, DWORD style /*= LVS_EX_FULLROWSELECT | LVS_EX_TWOCLICKACTIVATE | LVS_EX_GRIDLINES | LVS_EX_HEADERDRAGDROP*/)
{
	ListCtrl::initControl (style) ;
	this->nbColonnes = nbColonnes ;
	this->colIp = colIp ;
	this->maitre = maitre ;
	this->colNom = colNom ;
}
