//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#if !defined(AFX_LISTCTRL_H__36DDF5FC_445F_4522_B6CD_A4DC2AEB2638__INCLUDED_)
#define AFX_LISTCTRL_H__36DDF5FC_445F_4522_B6CD_A4DC2AEB2638__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// ListCtrl.h : header file
//


/////////////////////////////////////////////////////////////////////////////
// ListCtrl window


#define MAX_COL			50
#define SORT_DESC		MAX_COL


enum ArrowType { arrowDown = IDB_DOWN, arrowUp = IDB_UP };


class ListCtrl : public CListCtrl
{
private:
	
	ArrowType		m_atSortArrow ;
	CMenu			m_choixColonne ;

	int				m_colonnes[MAX_COL] ;

protected:
	bool			m_SortAscending;
	int				m_CurrentSortItem;
	bool			m_afficheBack2 ;
	COLORREF		m_backColor ;
	// nombre de colonnes de la liste
	int nbColonnes ;
	

// Construction
public:
	ListCtrl();

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(ListCtrl)
	//}}AFX_VIRTUAL

// Implementation
public:


	virtual ~ListCtrl();

	virtual void initControl (DWORD style = LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES) ;

	
	virtual void DrawItem(LPDRAWITEMSTRUCT) ;
	void Dessiner (LPDRAWITEMSTRUCT item, bool afficheTexte = true) ;

	virtual int InsertColumn(int nCol, LPCTSTR lpszColumnHeading, int nFormat = LVCFMT_LEFT, int nWidth = -1, int nSubItem = -1) ;

	/************************************************************
	* Tri selon cette colonne									*
	* Utilise la fonction de comparaison pfnCompare				 *
	************************************************************/
	virtual void trier (int col, PFNLVCOMPARE pfnCompare) ;

	/************************************************************
	* Met a jour le tri											*
	************************************************************/
	virtual void majTri (PFNLVCOMPARE pfnCompare) ;



	virtual void Invalidate (BOOL bErase = TRUE) ;

	
	void SetSortArrow (int iColumn, ArrowType atType) ;

	/************************************************************
	* Returns item associated with this data					*
	* Returns -1 if this data is not found						*
	************************************************************/
	int getItem (void * data) ;

	/************************************************************
	* Redraws this item											*
	************************************************************/
	void redrawsItem (int item) ;

	

	

/*	virtual int InsertItem( int nItem, LPCTSTR lpszItem ) ;
	virtual BOOL SetItemText( int nItem, int nSubItem, LPTSTR lpszText );*/




	// Generated message map functions
protected:
	//{{AFX_MSG(ListCtrl)
	afx_msg void OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_LISTCTRL_H__36DDF5FC_445F_4522_B6CD_A4DC2AEB2638__INCLUDED_)
