//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// ListCtrl.cpp : implementation file
//

#include "stdafx.h"
#include "ETBuddies.h"
#include "ListCtrl.h"
#include "TexteColore.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//#define BACK_COLOR		RGB(255,255,255)
#define BACK_COLOR		RGB(198,198,198)
#define BACK_COLOR2		RGB(170,170,170)
#define SEL_INT			RGB(194,200,218)
#define SEL_EXT			RGB(10,36,106)

#define MENU_ID(num)	((num) + WM_USER + 1)


/////////////////////////////////////////////////////////////////////////////
// ListCtrl

ListCtrl::ListCtrl()
{
	this->nbColonnes = 0 ;
	this->m_backColor = BACK_COLOR ;
	this->m_afficheBack2 = false ;
	this->m_CurrentSortItem = 0 ;
	this->m_SortAscending = true ;
}

ListCtrl::~ListCtrl()
{
}


BEGIN_MESSAGE_MAP(ListCtrl, CListCtrl)
//{{AFX_MSG_MAP(ListCtrl)
ON_WM_DRAWITEM()
//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// ListCtrl message handlers

void ListCtrl::initControl (DWORD style /*= LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES*/)
{
	DWORD styleEx = this->GetExStyle() | style ;
	styleEx &= ~LVS_EX_CHECKBOXES ;
	this->SetExtendedStyle (styleEx) ;
	this->SetBkColor(m_backColor) ;
	this->m_choixColonne.CreatePopupMenu() ;
	
}


void ListCtrl::OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
	// TODO: Add your message handler code here and/or call default
	
	CListCtrl::OnDrawItem(nIDCtl, lpDrawItemStruct);
}





void ListCtrl::Dessiner (LPDRAWITEMSTRUCT item, bool afficheTexte /*= true*/)
{
	HDC hDC = item->hDC ;
	CDC * dc = CDC::FromHandle (hDC) ;
	CRect rcItem = item->rcItem ;
	BOOL bCtrlFocused = ((GetFocus() == this) || (GetStyle() & LVS_SHOWSELALWAYS));
	BOOL bHighlight = item->itemState & ODS_SELECTED ;


	COLORREF backColor = (item->itemID % 2 == 1) ? BACK_COLOR2 : BACK_COLOR ;
	this->m_afficheBack2 = !this->m_afficheBack2 ;
	CRect rectC ;
	this->GetClientRect(&rectC) ;
	rectC.left		= rcItem.left ;
	rectC.top		= rcItem.top ;
	rectC.bottom	= rcItem.bottom ;
	dc->FillRect (&rectC, &CBrush(backColor)) ;

/*	LOGFONT f; 
	dc->GetCurrentFont ()->GetLogFont (&f) ;*/

	
	
	if (item->itemID == -1 || this->nbColonnes <= 0) {
		return ;
	}
	

	
	
	/********************************************************
	* Affichage de l'eventuelle selection					*
	********************************************************/
	if (bHighlight && bCtrlFocused)
	{
		CRect sel(rcItem) ;
		sel.bottom -= 2;
		sel.right -= 2 ;
		
		/* L'item est selectionn */
		CPen pen (PS_SOLID, 1, SEL_EXT) ;
		CPen * old = dc->SelectObject (&pen) ;
		dc->MoveTo (sel.left,	sel.top) ;
		dc->LineTo (sel.right,	sel.top) ;
		dc->LineTo (sel.right,	sel.bottom) ;
		dc->LineTo (sel.left,	sel.bottom) ;
		dc->LineTo (sel.left,	sel.top) ;
		dc->SelectObject (old) ;
		
		sel.DeflateRect (1, 1, 0, 0) ;
		dc->FillRect (&sel, &CBrush(SEL_INT)) ;
		
	}
	
	
	
	
	/********************************************************
	* Affichage du texte de chaque colonne					*
	********************************************************/
	rcItem.left += 4 ;
	CRect rect(rcItem) ;
	if (afficheTexte) 
	{
		
		for (int i = 0 ; i < this->nbColonnes ; i++)
		{
			
			/* initialisations texte et position */
			CString texteColore = this->GetItemText (item->itemID, i) ;
			CString texte = COULEUR2INCO(texteColore) ;
			int taille = this->GetColumnWidth (i) ;
			if (rect.left + taille < rcItem.right) {
				rect.right = rect.left + taille - 10 ;
			}
			else {
				rect.right = item->rcItem.right ;
			}

			UINT align = DT_LEFT ;			
			TEXTE_OUT(dc, texteColore, &rect, align);
			

			/* passe a la colonne suivante */
			rect.left += taille ;
			
			
		}
	}

	
}


void ListCtrl::DrawItem(LPDRAWITEMSTRUCT item)
{
	this->Dessiner (item) ;
}

/*virtual*/ int ListCtrl::InsertColumn(int nCol, LPCTSTR lpszColumnHeading, int nFormat /*= LVCFMT_LEFT*/, int nWidth /*= -1*/, int nSubItem /*= -1*/)
{
	int retour = -1 ;
	this->nbColonnes++ ;
	this->m_choixColonne.InsertMenu (-1, MF_STRING|MF_BYPOSITION, MENU_ID(nbColonnes), lpszColumnHeading) ;

	retour = CListCtrl::InsertColumn (nCol, lpszColumnHeading, nFormat, nWidth, nSubItem) ;
	return (retour) ;
}

/************************************************************
* Tri selon cette colonne									*
************************************************************/
/*virtual*/ void ListCtrl::trier (int col, PFNLVCOMPARE pfnCompare)
{
	if (col == m_CurrentSortItem) {
		/* Cette colonne est deja trie, on inverse le tri */
		m_SortAscending = !m_SortAscending ;
	}
	else {
		m_SortAscending = true ;
	}
	SetSortArrow(col, m_SortAscending ? arrowUp : arrowDown);
	m_CurrentSortItem = col ;
	this->majTri (pfnCompare) ;
}


void ListCtrl::SetSortArrow(int iColumn, ArrowType atType) {
	HDITEM headerItem;
	headerItem.mask = HDI_FORMAT | HDI_BITMAP;
	CHeaderCtrl* pHeaderCtrl = GetHeaderCtrl();

	//delete old image if column has changed
	if(iColumn != m_CurrentSortItem) {
		pHeaderCtrl->GetItem(m_CurrentSortItem, &headerItem);
		headerItem.fmt &= ~(HDF_BITMAP | HDF_BITMAP_ON_RIGHT);
		if (headerItem.hbm != 0) {
			DeleteObject(headerItem.hbm);
			headerItem.hbm = 0;
		}
		pHeaderCtrl->SetItem(m_CurrentSortItem, &headerItem);
		m_CurrentSortItem = iColumn;
	}

	//place new arrow unless we were given an invalid column
	if(iColumn >= 0 && pHeaderCtrl->GetItem(iColumn, &headerItem)) {
		m_atSortArrow = atType;
		if (headerItem.hbm != 0) {
			DeleteObject(headerItem.hbm);
			headerItem.hbm = 0;
		}
		headerItem.fmt |= HDF_BITMAP | HDF_BITMAP_ON_RIGHT;
		headerItem.hbm = (HBITMAP)LoadImage(AfxGetInstanceHandle(),
			MAKEINTRESOURCE(m_atSortArrow), IMAGE_BITMAP, 0, 0,
			LR_LOADMAP3DCOLORS);
		pHeaderCtrl->SetItem(iColumn, &headerItem);
	}
}

/*virtual*/ void ListCtrl::Invalidate (BOOL bErase /*= TRUE*/) 
{
	if (::IsWindow(m_hWnd)) {
		CListCtrl::Invalidate (bErase) ;
	}
}

/************************************************************
* Met a jour le tri											*
************************************************************/
/*virtual*/ void ListCtrl::majTri (PFNLVCOMPARE pfnCompare)
{
	SortItems(pfnCompare, m_CurrentSortItem + (m_SortAscending ? 0:SORT_DESC));	
	SetSortArrow(m_CurrentSortItem, m_SortAscending ? arrowUp : arrowDown);
}


/************************************************************
* Returns item associated with this data					*
* Returns -1 if this data is not found						*
************************************************************/
int ListCtrl::getItem (void * data)
{
	int id = -1 ;
	int nbItems = this->GetItemCount() ;

	/* Recherche de la ligne correspondante a ce server */
	for (int i = 0 ; i < nbItems && id == -1 ; i++) 
	{
		if ((void*)this->GetItemData(i) == data) {
			id = i ;
		}
	}

	return (id) ;
}

/************************************************************
* Redraws this item											*
************************************************************/
void ListCtrl::redrawsItem (int item)
{
	ASSERT(item != -1);
	if (item != -1) {
		CRect rect ;
		this->GetItemRect (item, &rect, LVIR_BOUNDS) ;
		this->InvalidateRect (&rect) ;
	}
}
