//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// JoueursDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ETBuddies.h"
#include "ETBuddiesDlg.h"
#include "JoueursDlg.h"
#include "Skin.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define BORD_FENETRE_Y		21

#define TETE_BMP			"tete.bmp"


#define TAILLE_MIN_X		100
#define TAILLE_MIN_Y		10


/////////////////////////////////////////////////////////////////////////////
// JoueursDlg dialog


JoueursDlg::JoueursDlg(CWnd* pParent /*=NULL*/)
	: CResizableDialog(JoueursDlg::IDD, pParent)
{
	this->skin		= NULL ;
	this->buddie	= NULL ;
	this->tete		= NULL ;
	this->font		= new CFont() ;
	this->font->CreateFont (15,0,0,0,400,0,0,0,0,0,0,0,0,"Arial") ;
	this->Create (IDD, pParent) ;
	//{{AFX_DATA_INIT(JoueursDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

JoueursDlg::~JoueursDlg()
{
	EFFACER_LISTE(BuddyJoueurImage,this->liste) ;
	if (this->tete)		delete (this->tete) ;
	delete (this->font) ;
}


void JoueursDlg::DoDataExchange(CDataExchange* pDX)
{
	CResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(JoueursDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(JoueursDlg, CDialog)
	//{{AFX_MSG_MAP(JoueursDlg)
	ON_WM_PAINT()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_SIZE()
	ON_WM_RBUTTONUP()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// JoueursDlg message handlers
/*
int JoueursDlg::DoModal(Skin * skin, Buddie * buddie) 
{
	// TODO: Add your specialized code here and/or call the base class
	ASSERT(skin && buddie) ;
	this->skin = skin ;
	this->buddie = buddie ;

	this->tete = new Image (this->skin->getPath() + TETE_BMP) ;


	if (!this->skin || !this->buddie || !this->buddie->estConnecte()) {		
		return (IDCANCEL) ;
	}



	return CResizableDialog::DoModal();
	
}*/


void JoueursDlg::afficher (Skin * skin, Buddie * buddie)
{
	ASSERT(skin && buddie) ;

	if (skin && buddie && buddie->estConnecte()) {
		this->skin = skin ;
		this->buddie = buddie ;
		MAIN_DLG->getListeBud()->getClientMaitre()->ajouterObserver(this);
		this->SetWindowText (buddie->getNom()) ;
		this->initJoueurs() ;
		this->ShowWindow (SW_SHOW) ;
	}
}



/* Redimensionne le dialog */
void JoueursDlg::setTaille (CSize taille)
{
	this->SetWindowPos (NULL, 0, 0, taille.cx, taille.cy + BORD_FENETRE_Y, SWP_NOMOVE | SWP_NOZORDER) ;
}

CSize JoueursDlg::getTaille ()
{
	CRect r ;
	this->GetWindowRect (&r) ;
	ScreenToClient (&r) ;

	return (CSize (r.Width(), r.Height())) ;
}

void JoueursDlg::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	CDC * cdc = this->GetDC() ;
	cdc->SelectObject (font) ;
	try	{
		this->skin->afficherJoueurs (this, cdc, this->buddie) ;
	}
	CATCH_EXCEPTION;

}

BOOL JoueursDlg::OnInitDialog() 
{
	CResizableDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	this->SetMinTrackSize (CSize (TAILLE_MIN_X,TAILLE_MIN_Y)) ;
//this->EnableSaveRestore (_T("Player")) ;
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void JoueursDlg::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	FOR_VECTOR(BuddyJoueurImage*,this->liste) {
		(*i)->OnLButtonDblClk (point) ;
	}
	CDialog::OnLButtonDblClk(nFlags, point);
}

void JoueursDlg::OnSize(UINT nType, int cx, int cy) 
{
	if (::IsWindow(m_hWnd)) {
		CResizableDialog::OnSize(nType, cx, cy);
		this->ArrangeLayout () ;
		this->Invalidate (FALSE); 
	}

	// TODO: Add your message handler code here
	
}

void JoueursDlg::OnRButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	FOR_VECTOR(BuddyJoueurImage*,this->liste) {
		(*i)->OnRButtonUp (point) ;
	}
	CDialog::OnRButtonUp(nFlags, point);
}


void JoueursDlg::initJoueurs ()
{
	/****************************************************************
	* Creation de la liste des BuddyJoueurImage						*
	****************************************************************/
	if (this->tete)		delete (this->tete) ;
	this->tete = new Image (this->skin->getPath() + TETE_BMP) ;

	EFFACER_LISTE(BuddyJoueurImage,this->liste) ;
	vector<Server*> * serveurs = this->buddie->getServeurs () ;	
	try
	{
		FOR_VECTOR(Server*,(*serveurs))
		{
			/****************************************************************
			* Creation du BuddyJoueurImage associ a ce serveur				*
			****************************************************************/
			vector<Joueur*> joueurs = this->buddie->getJoueurs(*i) ;
			FOR_VECTOR_IND(Joueur*,joueurs,j)
			{
				BuddyJoueurImage * dessin = new BuddyJoueurImage(
					this->skin->getPath() + this->skin->getChaine(BUDDY, true),
					this->buddie,
					*j,
					this->tete
					) ;
				
				
				/****************************************************************
				* Ajout de tous les observeurs du skin a ce BuddyJoueurImage	*
				****************************************************************/
				vector<Observer*> * listeObs = this->skin->getListeObserver() ;
				FOR_VECTOR(Observer*, (*listeObs))
				{
					dessin->ajouterObserver (*i) ;
				}
				
				/****************************************************************
				* Ajout du BuddyJoueurImage	a la liste							*
				****************************************************************/
				this->liste.push_back (dessin) ;
			}
		}
	}
	CATCH_EXCEPTION;

	this->Invalidate (FALSE) ;
}

/*virtual*/ void JoueursDlg::OnChange (Objet * obj, UINT msg, void * param1,void * param2)
{
	if (msg == ClientMaster::ON_REFRESH_UN_SERVER || msg == ClientMaster::ON_REFRESH_COMPLETE && this->IsWindowVisible()) {
		this->initJoueurs() ;
		this->Invalidate(FALSE) ;
	}
	else if (msg == ClientMaster::ON_SERVER_DELETE) {
		this->ShowWindow(SW_HIDE) ;
	}
}
