// Ip2Country.h: interface for the Ip2Country class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_IP2COUNTRY_H__1701BA9E_9576_477D_B21B_9B64848D1660__INCLUDED_)
#define AFX_IP2COUNTRY_H__1701BA9E_9576_477D_B21B_9B64848D1660__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <vector>
#include "ip.h"
#include "Fichier.h"
#include "Exception.h"

using namespace std ;

union IP {
	BYTE ipb[4];
	long ipi ;
} ;

class Country {
public:
	CString cntry ;
	CString fullCountry ;
	int num ;

	Country(CString cnt, CString fullCnt, int n) {
		fullCountry = fullCnt ;
		cntry = cnt ;
		num = n ;
	}
} ;

class CountryList {
	vector<Country> m_list ;

public:
	CountryList() {
	}

	~CountryList() {
	}

	bool exist(CString cntry) {
		bool retour = false ;
		vector<Country>::iterator i ;

		for (i = m_list.begin() ; i != m_list.end() && !retour ; i++) {
			if (cntry.CompareNoCase(i->cntry) == 0) {
				retour = true ;
			}
		}

		return (retour) ;
	}

	void add(Country & c) {
		if (!exist(c.cntry))		m_list.push_back(c) ;
	}

	Country * getCountry(CString cnt) {
		Country * retour = NULL ;
		vector<Country>::iterator i ;

		for (i = m_list.begin() ; i != m_list.end() && !retour ; i++) {
			if (cnt.CompareNoCase(i->cntry) == 0) {
				retour = i ;
			}
		}
		return (retour) ;
	}

	Country * getCountry(int num) {
		Country * retour = NULL ;
		vector<Country>::iterator i ;

		for (i = m_list.begin() ; i != m_list.end() && !retour ; i++) {
			if (i->num == num) {
				retour = i ;
			}
		}
		return (retour) ;
	}

	vector<Country> * getList() {return &m_list;}

	void clear() {
		m_list.clear() ;
	}
} ;

struct Range {
	IP ipFrom ;
	IP ipTo ;
	Country * country ;

public:
	Range(IP &ipF, IP &ipT, Country * cnt){
		ipFrom.ipi = ipF.ipi;
		ipTo.ipi = ipT.ipi ;
		country = cnt ;
	}

	Range() {
	}

	~Range() {
	}

	IP getIpFrom()	{return ipFrom;}
	IP getIpTo()	{return ipTo;}
	Country * getCountry() {return (country);}
	
};

class Ip2Country  
{
private:
	vector<Range> m_rangeList ;
	CountryList m_countryList ;
public:
	Ip2Country();
	virtual ~Ip2Country();
	void readDatabase (CString fileName)throw (Exception) ;
	
	Country * getCountry(Ip * ip) ;

	CountryList * getCountryList() {return &m_countryList;}

	UINT getImage(Country * c) ;
};

#endif // !defined(AFX_IP2COUNTRY_H__1701BA9E_9576_477D_B21B_9B64848D1660__INCLUDED_)
