// Ip2Country.cpp: implementation of the Ip2Country class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ETBuddies.h"
#include "Ip2Country.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

#define VERSION 0x01FF
#define HEADER	"Country database"

struct Flag {
	CString country ;
	UINT flag ;
	Flag(CString cnt, UINT fl) {
		country = cnt ;
		flag = fl;
	}
} ;

static Flag flagList[] = {	
Flag("FR", IDB_FR),
Flag("EU", IDB_EU),
Flag("UK", IDB_UK),
Flag("US", IDB_US),
Flag("CA", IDB_CA),
Flag("NL", IDB_NL),
Flag("CL", IDB_CL),
Flag("BS", IDB_BS),
Flag("AR", IDB_AR),
Flag("JP", IDB_JP),
Flag("DE", IDB_DE),
Flag("IN", IDB_IN),
Flag("AU", IDB_AU),
Flag("TH", IDB_TH),
Flag("CN", IDB_CN),
Flag("MY", IDB_MY),
Flag("NZ", IDB_NZ),
Flag("SG", IDB_SG),
Flag("KR", IDB_KR),
Flag("PK", IDB_PK),
Flag("PH", IDB_PH),
Flag("TW", IDB_TW),
Flag("AF", IDB_AF),
Flag("HK", IDB_HK),
Flag("BD", IDB_BD),
Flag("ID", IDB_ID),
Flag("BN", IDB_BN),
Flag("AP", IDB_AP),
Flag("IL", IDB_IL),
Flag("GR", IDB_GR),
Flag("CH", IDB_CH),
Flag("SA", IDB_SA),
Flag("SE", IDB_SE),
Flag("PL", IDB_PL),
Flag("IT", IDB_IT),
Flag("CZ", IDB_CZ),
Flag("BE", IDB_BE),
Flag("RU", IDB_RU),
Flag("KE", IDB_KE),
Flag("IE", IDB_IE),
Flag("DK", IDB_DK),
Flag("EG", IDB_EG),
Flag("AT", IDB_AT),
Flag("ES", IDB_ES),
Flag("UA", IDB_UA),
Flag("NO", IDB_NO),
Flag("TR", IDB_TR),
Flag("BG", IDB_BG),
Flag("FI", IDB_FI),
Flag("PT", IDB_PT),
Flag("IR", IDB_IR),
Flag("OM", IDB_OM),
Flag("DZ", IDB_DZ),
Flag("LV", IDB_LV),
Flag("EE", IDB_EE),
Flag("SK", IDB_SK),
Flag("LY", IDB_LY),
Flag("JO", IDB_JO),
Flag("HU", IDB_HU),
Flag("KW", IDB_KW),
Flag("LT", IDB_LT),
Flag("LB", IDB_LB),
Flag("AM", IDB_AM),
Flag("YU", IDB_YU),
Flag("KZ", IDB_KZ),
Flag("IS", IDB_IS),
Flag("MK", IDB_MK),
Flag("GE", IDB_GE),
Flag("MT", IDB_MT),
Flag("NG", IDB_NG),
Flag("AZ", IDB_AZ),
Flag("RO", IDB_RO),
Flag("MC", IDB_MC),
Flag("MA", IDB_MA),
Flag("MX", IDB_MX),
Flag("TT", IDB_TT),
Flag("DO", IDB_DO),
Flag("LS", IDB_LS),
Flag("PR", IDB_PR),
Flag("ZA", IDB_ZA),
Flag("BM", IDB_BM),
Flag("CO", IDB_CO),
Flag("VI", IDB_VI),
Flag("AG", IDB_AG),
Flag("SZ", IDB_SZ),
Flag("BB", IDB_BB),
Flag("JM", IDB_JM),
Flag("LU", IDB_LU),
Flag("BA", IDB_BA),
Flag("LI", IDB_LI),
Flag("CS", IDB_CS),
Flag("FO", IDB_FO),
Flag("IQ", IDB_IQ),
Flag("AL", IDB_AL),
Flag("HR", IDB_HR),
Flag("UZ", IDB_UZ),
Flag("CY", IDB_CY),
Flag("GH", IDB_GH),
Flag("BH", IDB_BH),
Flag("BY", IDB_BY),
Flag("SI", IDB_SI),
Flag("AE", IDB_AE),
Flag("TG", IDB_TG),
Flag("QA", IDB_QA),
Flag("KG", IDB_KG),
Flag("BJ", IDB_BJ),
Flag("PS", IDB_PS),
Flag("YE", IDB_YE),
Flag("SY", IDB_SY),
Flag("MR", IDB_MR),
Flag("MD", IDB_MD),
Flag("TJ", IDB_TJ),
Flag("AD", IDB_AD),
Flag("GI", IDB_GI),
Flag("VE", IDB_VE),
Flag("BR", IDB_BR),
Flag("FJ", IDB_FJ),
Flag("EC", IDB_EC),
Flag("MO", IDB_MO),
Flag("PE", IDB_PE),
Flag("CR", IDB_CR),
Flag("UY", IDB_UY),
Flag("NI", IDB_NI),
Flag("BO", IDB_BO),
Flag("PA", IDB_PA),
Flag("GT", IDB_GT),
Flag("SV", IDB_SV),
Flag("CU", IDB_CU),
Flag("TN", IDB_TN),
Flag("BF", IDB_BF),
Flag("NE", IDB_NE),
Flag("PF", IDB_PF),
Flag("PG", IDB_PG),
Flag("GA", IDB_GA),
Flag("MZ", IDB_MZ),
Flag("LK", IDB_LK),
Flag("UG", IDB_UG),
Flag("GL", IDB_GL),
Flag("SM", IDB_SM),
Flag("CM", IDB_CM),
Flag("MU", IDB_MU),
Flag("NA", IDB_NA),
Flag("TZ", IDB_TZ),
Flag("SN", IDB_SN),
Flag("BW", IDB_BW),
Flag("SD", IDB_SD),
Flag("ZW", IDB_ZW),
Flag("RW", IDB_RW),
Flag("AO", IDB_AO),
Flag("MW", IDB_MW),
Flag("MG", IDB_MG),
Flag("ML", IDB_ML),
Flag("ER", IDB_ER),
Flag("CI", IDB_CI),
Flag("DJ", IDB_DJ),
Flag("BZ", IDB_BZ),
Flag("SR", IDB_SR),
Flag("HT", IDB_HT),
Flag("HN", IDB_HN),
Flag("PY", IDB_PY),
Flag("AW", IDB_AW),
Flag("SB", IDB_SB),
Flag("MV", IDB_MV),
Flag("TV", IDB_TV),
Flag("WS", IDB_WS),
Flag("MN", IDB_MN),
Flag("VN", IDB_VN),
Flag("KI", IDB_KI),
Flag("GU", IDB_GU),
Flag("NC", IDB_NC),
Flag("IO", IDB_IO),
Flag("KH", IDB_KH),
Flag("NP", IDB_NP),
Flag("LA", IDB_LA),
Flag("TO", IDB_TO),
Flag("NU", IDB_NU),
Flag("CK", IDB_CK),
Flag("AS", IDB_AS),
Flag("VU", IDB_VU),
Flag("MP", IDB_MP),
Flag("PW", IDB_PW),
Flag("BT", IDB_BT),
Flag("NF", IDB_NF),
Flag("MM", IDB_MM),
Flag("NR", IDB_NR),
Flag("LC", IDB_LC),
Flag("GM", IDB_GM),
Flag("VA", IDB_VA),
Flag("ET", IDB_ET),
Flag("SL", IDB_SL),
Flag("TM", IDB_TM),
Flag("GD", IDB_GD),
Flag("ZM", IDB_ZM),
Flag("AN", IDB_AN)


													
} ;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Ip2Country::Ip2Country(){
}

Ip2Country::~Ip2Country(){
}


void Ip2Country::readDatabase (CString fileName) throw (Exception) {
	m_rangeList.clear() ;
	m_countryList.clear() ;

	Fichier * f = new Fichier(fileName,Fichier::MODE_READ | Fichier::TYPE_BINARY) ;
	char ligne[512] ;
	char *temp = ligne ;

	bool cntList = true ;
	int num = 0 ;
	CString cnt, cntFull ;



	int version = 0 ;
	CString header ;
	f->Read(&version, 1, 4) ;

	if (version % 0x100 != 0xFF) {
		THROW_E("Fichier corrompu") ;
	}

	header = f->ReadString() ;

	if (header.Compare(HEADER) != 0) {
		THROW_E("Fichier corrompu") ;
	}

	while (!f->isEof()) {
		if (cntList) {
			f->Read(&num, 1, 2) ;
			if (num == 0xFFFF) {
				cntList = false ;
			}
			else {
				cnt = f->ReadString() ;
				cntFull = f->ReadString() ;
				m_countryList.add(Country(cnt, cntFull, num)) ;
			}
		}
		else {
			IP ipf, ipt ;
			ipf.ipi = 0 ;
			ipt.ipi = 0 ;
			

			try {
				f->Read(&ipf.ipi, 1, 4) ;
				f->Read(&ipt.ipi, 1, 4) ;
				f->Read(&num, 1, 2) ;

				m_rangeList.push_back(Range(ipf,
											ipt,
											m_countryList.getCountry(num))) ;
			}
			catch (Exception e) {
			}

			

			
		}
	}

	f->Close() ;
	delete (f) ;
}

Country * Ip2Country::getCountry(Ip * ip) {
	Country * retour = NULL ;

	IP testIp ;
	testIp.ipb[0] = ip->getBytes()[0] ;
	testIp.ipb[1] = ip->getBytes()[1] ;
	testIp.ipb[2] = ip->getBytes()[2] ;
	testIp.ipb[3] = ip->getBytes()[3] ;

	FOR_VECTOR_COND(Range, m_rangeList, !retour) {
		if (i->getIpFrom().ipi <= testIp.ipi && testIp.ipi <= i->getIpTo().ipi) {
			retour = i->getCountry() ;
		}
	}	

	return (retour) ;

}

UINT Ip2Country::getImage(Country * c) {
	UINT retour = 0 ;
	
	if (c != NULL) 
	{
		for (int i = 0 ; i < TAILLE_LISTE(flagList) && retour == 0 ; i++) {
			if (c->cntry.Compare(flagList[i].country) == 0) {
				retour = flagList[i].flag ;
			}
		}
	}

	return (retour) ;

}